/*
 Programm: time.c
 Funktion: Timer-Plugin fuer PM123
 Sprache:  Borland C++ 2.0 for OS/2
 Autor:    Andreas Schoesser
 Datum:    Project Start: 18.9.1999
           Modified: 11.7.2000
 Bemerkung: Muss zur DLL mit Hilfe von TIME.DEF compiliert werden
*/

#define INCL_GPILOGCOLORTABLE   /* Color Table functions        */
#define INCL_GPIPRIMITIVES      /* GPI primitive functions      */
#define INCL_WINSWITCHLIST
#define INCL_DOS
#define INCL_WIN
#define INCL_PM
#define INCL_WINFRAMEMGR
#define INCL_BASE
#define OS2_API32
#define INCL_DOSDATETIME   /* Date and time values */


#include <os2.h>
#include <stdio.h>
#include <malloc.h>
#include <math.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>
#include <process.h>
#include <errno.h>

#include "plugin.h"

PVISPLUGININIT idata = NULL;

MRESULT EXPENTRY ConfDialog(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
void load(void);
void save(void);

int APIENTRY plugin_query(PPLUGIN_QUERYPARAM param);
int APIENTRY plugin_configure(HWND hwnd, HMODULE module);
int APIENTRY plugin_deinit(void);
void minus(float *base, float *p, int *pos, long len, long w);
HWND APIENTRY vis_init(PVISPLUGININIT initdata);
void start_timer(void *q);

int hours = 2, mins = 30, maxanz = 10, anz = 0;
int beachte_time = 1, beachte_songs = 0;
char shutdown[255];
time_t endtime, currenttime = 0;

PFN getFile;

int APIENTRY plugin_query(PPLUGIN_QUERYPARAM param)
 {
  param -> type         = PLUGIN_VISUAL;
  param -> author       = "Andreas Schoesser";
  param -> desc         = "Timing-plugin v1.0";
  param -> configurable = TRUE;

  endtime = currenttime + hours * 60 * 60 + mins * 60;
  strcpy(shutdown, "C:\\apm\\apm.exe /poweroff");
  load();
  beachte_songs = beachte_time = 0;
  return(0);
 }

HWND APIENTRY vis_init(PVISPLUGININIT initdata)
 {
  ULONG ThreadID;
  HWND hwndFake;

  hwndFake = WinCreateWindow(HWND_DESKTOP, WC_FRAME, "Fake Window", WS_VISIBLE,
                               0, 0, 0, 0, HWND_DESKTOP, HWND_TOP, initdata -> id, 0, 0);

  getFile = initdata -> procs -> pm123_getstring;
  _beginthread(start_timer, 34000, 0);
  return(hwndFake);
 }

int APIENTRY plugin_configure(HWND hwnd, HMODULE module)
 {
  WinDlgBox(HWND_DESKTOP, hwnd, ConfDialog, module, 1, NULL);
  return(TRUE);
 }

MRESULT EXPENTRY ConfDialog(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
 {
  int i;
  time_t t, diff;
  char s[255];

  switch(msg)
   {
    case WM_INITDLG:
        WinCheckButton(hwnd, 102, beachte_songs);
        WinCheckButton(hwnd, 109, beachte_time);

        WinSendDlgItemMsg(hwnd, 103, SPBM_SETLIMITS, MPFROMLONG(24),
                          MPFROMLONG(0));
        WinSendDlgItemMsg(hwnd, 103, SPBM_SETCURRENTVALUE, MPFROMLONG(hours), 0);
        WinSendDlgItemMsg(hwnd, 105, SPBM_SETLIMITS, MPFROMLONG(60),
                          MPFROMLONG(0));
        WinSendDlgItemMsg(hwnd, 105, SPBM_SETCURRENTVALUE, MPFROMLONG(mins), 0);
        WinSendDlgItemMsg(hwnd, 108, SPBM_SETLIMITS, MPFROMLONG(1000),
                          MPFROMLONG(1));
        WinSendDlgItemMsg(hwnd, 108, SPBM_SETCURRENTVALUE, MPFROMLONG(maxanz), 0);
        WinSendDlgItemMsg(hwnd, 113, EM_SETTEXTLIMIT, MPFROMSHORT(200), 0);
	WinSetDlgItemText(hwnd, 113, shutdown);
	if(beachte_songs == 1)
	  sprintf(s, "remaining songs: %d", maxanz - anz);
	else
	  strcpy(s, "");
	WinSetDlgItemText(hwnd, 111, s);
	diff = endtime - currenttime;
	if(beachte_time == 1)
	  sprintf(s, "remaining time: %d:%d h:min", diff / 3600, (diff % 3600) / 60);
        else
          strcpy(s, "");
        WinSetDlgItemText(hwnd, 110, s);

        return(0);
    case WM_COMMAND:
        switch(SHORT1FROMMP(mp1))
         {
          case DID_OK:
                    beachte_songs = WinQueryButtonCheckstate(hwnd, 102);
                    beachte_time = WinQueryButtonCheckstate(hwnd, 109);
                    WinSendDlgItemMsg(hwnd, 103, SPBM_QUERYVALUE, &hours, 0);
                    WinSendDlgItemMsg(hwnd, 105, SPBM_QUERYVALUE, &mins, 0);
                    WinSendDlgItemMsg(hwnd, 108, SPBM_QUERYVALUE, &maxanz, 0);
                    WinQueryDlgItemText(hwnd, 113, 255, shutdown);
                    endtime = hours * 60 * 60 + mins * 60;
                    currenttime = 0;
                    anz = 0;
                    save();
                    WinDismissDlg(hwnd, 0);
                    break;
          case DID_CANCEL: WinDismissDlg(hwnd, 0);
                    break;
         }
        break;
    default:
        return((MRESULT) WinDefDlgProc(hwnd, msg, mp1, mp2));
   }
  return(0);
 }


int APIENTRY plugin_deinit(void)
 {
  save();
  return(0);
 }

void save(void)
 {
  FILE *fp;

  if(!(fp = fopen("time.ini", "wb")))
    return;

  fwrite(&hours, 1, sizeof(hours), fp);
  fwrite(&mins, 1, sizeof(mins), fp);
  fwrite(&maxanz, 1, sizeof(maxanz), fp);
  fwrite(&beachte_time, 1, sizeof(beachte_time), fp);
  fwrite(&beachte_songs, 1, sizeof(beachte_songs), fp);
  fwrite(shutdown, 1, 255, fp);
  fclose(fp);
 }

void load(void)
 {
  FILE *fp;

  if(!(fp = fopen("time.ini", "rb")))
    return;

  fread(&hours, 1, sizeof(hours), fp);
  fread(&mins, 1, sizeof(mins), fp);
  fread(&maxanz, 1, sizeof(maxanz), fp);
  fread(&beachte_time, 1, sizeof(beachte_time), fp);
  fread(&beachte_songs, 1, sizeof(beachte_songs), fp);
  fread(shutdown, 1, 255, fp);
  fclose(fp);
 }

void start_timer(void *q)
 {
  char currentFile[300], oldFile[300];
  HAB hab;


  hab = WinInitialize(0);
  WinCreateMsgQueue(hab, 200);

  strcpy(oldFile, "No file loaded, buddy!");

  for(;;)
   {
    DosSleep(1000);
    currenttime += 1;

    getFile(STR_FILENAME, 0, 300, currentFile);
    if(strcmp(currentFile, oldFile) != 0)
     {
      strcpy(oldFile, currentFile);
      anz++;
     }

    if(currenttime > endtime && beachte_time == 1)
     {
      DosBeep(100, 200);
      system(shutdown);
     }

    if(anz > maxanz && beachte_songs == 1)
     {
      DosBeep(100, 200);
      system(shutdown);
     }
   }
 }
