/* CFGinst - Install / UnInstall for ConfigTool */

PARSE ARG action
IF RxFuncQuery('SysLoadFuncs') THEN DO
    CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
    CALL SysLoadFuncs
END
CALL SysCls
action = TRANSLATE(LEFT(action,1))
SELECT
    WHEN action = 'I' THEN CALL InstallMe
    WHEN action = 'U' THEN CALL UnInstallMe
    OTHERWISE CALL WhatAction
END
Exit /* End of CFGinst.cmd */

/* WhatAction - no action selected */

WhatAction:     PROCEDURE

CALL SysCls
SAY 'Please enter installation parameter (I=Install, U=UnInstall, other=Exit):'
PARSE PULL action
SELECT
    WHEN TRANSLATE(LEFT(action,1)) = 'I' THEN CALL InstallMe
    WHEN TRANSLATE(LEFT(action,1)) = 'U' THEN CALL UnInstallMe
    OTHERWISE CALL NoAction 'Installation failed.'
END
RETURN /* End of WhatAction */

/* NoAction - abort Install */

NoAction:   PROCEDURE

CALL SysCls
PARSE ARG noinstmsg
SAY noinstmsg
SAY 'Press Enter to exit ...'
PULL answer
CALL SysCls
Exit /* End of NoAction */

/* InstallMe - install ConfigTool */

InstallMe:  PROCEDURE

prgname = 'ConfigTool 1.0.0'
compname = 'ConfigCompare 1.0.0'
cfgfiles = 'CFGtool.exe CFGcomp.exe CFGTOOL.DAT CFGTOOL.CHK Cfgbmp32.dll ENGLISH.INI'
IF RIGHT(Directory(),2) = ':\' THEN DO
    SAY 'Problem! '||prgname||' can not be installed in root directory.'
    SAY 'Create directory for '||prgname||', copy files: '||cfgfiles||' there and start this procedure again.'
    SAY 'Press Enter to exit ...'
    PULL answer
    Exit
END

CALL SysCls
SAY 'Welcome to '||prgname||' Installation procedure!'
SAY 'Your files are in directory: '||Directory()
SAY 'This procedure will:'
SAY '- Create Folder "OS/2 System Tools" on your Desktop,'
SAY '- Create Program objects for '||prgname||','
SAY '- Associate CONFIG.* files with '||prgname||','
SAY '- Add '||prgname||' specific entries in OS2.INI file, in App ToolsByGoran.'
SAY 'Press "Y" (and Enter) to start Installation, Enter to exit...'
PARSE PULL answer

IF TRANSLATE(LEFT(answer,1)) <> "Y" THEN DO
    CALL NoAction 'Installation aborted'
END

SAY ' '
SAY 'Checking files:'
DO i = 1 TO WORDS(cfgfiles)
    CALL SysFiletree Directory()||'\'||WORD(cfgfiles,i), 'chkfile', 'FO'
    SELECT
    WHEN chkfile.0 = 1 THEN SAY '- '||LEFT(WORD(cfgfiles,i),12)||' - OK'
    OTHERWISE CALL NoAction LEFT(WORD(cfgfiles,i),12)||' - Missing file. Installation failed!'
    END
END

SAY ' '
SAY 'Writing entries to OS2.INI'
dummy = SysIni('USER','ToolsByGoran','CFGtoolWorkDir',Directory())
SAY 'Working directory - '||Rc1(dummy)
dummy = SysIni('USER','ToolsByGoran','CFGtoolINIfile',Directory()||'\CFGTOOL.INI')
SAY 'INI file - '||Rc1(dummy)

SAY ' '
SAY 'Writing default values to CFGTOOL.INI'
CALL SysIni 'CFGTOOL.INI', 'Language', 'ENGLISH', 'English.inf'
CALL SysIni 'CFGTOOL.INI', 'Language', 'CROATIAN', 'English.inf'
CALL SysIni 'CFGTOOL.INI', 'Language', 'FRENCH', 'English.inf'
CALL SysIni 'CFGTOOL.INI', 'Language', 'GERMAN', 'English.inf'
CALL SysIni 'CFGTOOL.INI', 'Language', 'SWEDISH', 'Swedish.inf'
CALL SysIni 'CFGTOOL.INI', 'Settings', 'RAM', '3'
CALL SysIni 'CFGTOOL.INI', 'Settings', 'Processor', '3'
CALL SysIni 'CFGTOOL.INI', 'Settings', 'CDROM', '2'
CALL SysIni 'CFGTOOL.INI', 'Settings', 'CDRW', '1'
CALL SysIni 'CFGTOOL.INI', 'Settings', 'ZIP', '1'
CALL SysIni 'CFGTOOL.INI', 'Settings', 'Version', '2'
CALL SysIni 'CFGTOOL.INI', 'Settings', 'FileSystem', '3'
CALL SysIni 'CFGTOOL.INI', 'Settings', 'CurrLang', 'ENGLISH'
CALL SysIni 'CFGTOOL.INI', 'Settings', 'BackupFiles', '5'
CALL SysIni 'CFGTOOL.INI', 'Settings', 'BackupDir', Directory()
CALL SysIni 'CFGTOOL.INI', 'Settings', 'Backup2Boot', '0'
CALL SysIni 'CFGTOOL.INI', 'Settings', 'DescArea', '50'
CALL SysIni 'CFGTOOL.INI', 'Settings', 'BeepLong', '1'
CALL SysIni 'CFGTOOL.INI', 'Settings', 'OnExit', '0 1'
CALL SysIni 'CFGTOOL.INI', 'Settings', 'PosSize', '50 50 540 480'
CALL SysIni 'CFGTOOL.INI', 'Settings', 'PosWindows', '1'
CALL SysIni 'CFGTOOL.INI', 'Settings', 'KeepWindows', '1'
CALL SysIni 'CFGTOOL.INI', 'Settings', 'Comment', '0 0 0 Changed with '||prgname
CALL SysIni 'CFGTOOL.INI', 'Settings', 'ColorB', '#0'
CALL SysIni 'CFGTOOL.INI', 'Settings', 'ColorF', '#7'
CALL SysIni 'CFGTOOL.INI', 'Settings', 'FontP', '9.WarpSans'
CALL SysIni 'CFGTOOL.INI', 'Settings', 'FontM', '10.System VIO'

SAY ' '
cfgpath = VALUE('PATH',,'OS2ENVIRONMENT')
cfgpath = TRANSLATE(cfgpath)
bootdrv = SUBSTR(cfgpath,POS(':\OS2\SYSTEM',cfgpath)-1,1)
SAY 'OS/2 boot drive is: '||bootdrv
SAY 'Press Enter if this is OK, or type correct boot drive and press Enter.'
PARSE PULL bootdrive
SELECT
    WHEN STRIP(bootdrive) = '' THEN bootdrive = bootdrv
    OTHERWISE bootdrive = TRANSLATE(LEFT(bootdrive,1))
END
CALL SysIni 'CFGTOOL.INI', 'Settings', 'BootDrive', bootdrive

SAY ' '
assocme = 0
SAY 'Do you want to associate CONFIG.* files with '||prgname||'? (Y/N)'
PARSE PULL answer
IF TRANSLATE(answer) = 'Y' THEN DO
    assocme = 1
END

SAY ' '
InstallDir = Directory()
WorkDir = Directory()

FoldTitle='OS/2 System Tools'
Icon1=Directory()||'\Folder1.ico'
Icon2=Directory()||'\Folder2.ico'
Icon='ICONFILE='Icon1||';ICONNFILE=1,'||Icon2
Setup='OBJECTID=<GISYSTOOLS_FOLD>;'||Icon||''
Action = 'U'
dummy = SysCreateObject('WPFolder',FoldTitle,'<WP_DESKTOP>',Setup,Action)
SAY 'Creating '||FoldTitle||' Folder - '||Rc2(dummy)

FoldTitle='Help'
Setup='OBJECTID=<GISYSTOOLS_HELP>'
Action = 'U'
dummy = SysCreateObject('WPFolder',FoldTitle,'<GISYSTOOLS_FOLD>',Setup,Action)
SAY 'Creating '||FoldTitle||' Folder - '||Rc2(dummy)

ProgTitle = prgname
EXE = 'CFGtool.exe'
ICO = 'CFGtool.ico'
Setup = 'OBJECTID=<CONFIGTOOL_PROGRAM>;EXENAME='InstallDir'\'EXE';ICONFILE='InstallDir'\'ICO';STARTUPDIR='WorkDir''
IF assocme = 1 THEN DO
    Setup = 'OBJECTID=<CONFIGTOOL_PROGRAM>;EXENAME='InstallDir'\'EXE';ASSOCFILTER=CONFIG.*;ICONFILE='InstallDir'\'ICO';STARTUPDIR='WorkDir''
END
Action = 'U'
dummy = SysCreateObject('WPProgram',ProgTitle,'<GISYSTOOLS_FOLD>',Setup,Action)
SAY 'Creating '||prgname||' Program object - '||Rc2(dummy)

ProgTitle = compname
EXE = 'CFGcomp.exe'
ICO = 'CFGcomp.ico'
Setup = 'OBJECTID=<CONFIGCOMP_PROGRAM>;EXENAME='InstallDir'\'EXE';ICONFILE='InstallDir'\'ICO';STARTUPDIR='WorkDir''
Action = 'U'
dummy = SysCreateObject('WPProgram',ProgTitle,'<GISYSTOOLS_FOLD>',Setup,Action)
SAY 'Creating '||prgname||' Program object - '||Rc2(dummy)

ProgTitle = prgname||'^English manual'
EXE = 'View.exe'
INF = 'English.inf'
Setup = 'OBJECTID=<CONFIGTOOL_HENG>;EXENAME='EXE';PARAMETERS='InstallDir'\'INF';STARTUPDIR='WorkDir''
Action = 'U'
dummy = SysCreateObject('WPProgram',ProgTitle,'<GISYSTOOLS_HELP>',Setup,Action)
SAY 'Creating '||prgname||' English manual - '||Rc2(dummy)

ProgTitle = prgname||'^Swedish manual'
EXE = 'View.exe'
INF = 'Swedish.inf'
Setup = 'OBJECTID=<CONFIGTOOL_HSWE>;EXENAME='EXE';PARAMETERS='InstallDir'\'INF';STARTUPDIR='WorkDir''
Action = 'U'
dummy = SysCreateObject('WPProgram',ProgTitle,'<GISYSTOOLS_HELP>',Setup,Action)
SAY 'Creating '||prgname||' Swedish manual - '||Rc2(dummy)

ProgTitle = prgname||'^Database (INF)'
EXE = 'View.exe'
INF = 'CFGDAT.INF'
Setup = 'OBJECTID=<CONFIGTOOL_DAT_INF>;EXENAME='EXE';PARAMETERS='InstallDir'\'INF';STARTUPDIR='WorkDir''
Action = 'U'
dummy = SysCreateObject('WPProgram',ProgTitle,'<GISYSTOOLS_FOLD>',Setup,Action)
SAY 'Creating '||prgname||' Database object - '||Rc2(dummy)

SAY ' '
SAY 'Installation finished! Press Enter to exit ...'
PULL answer
CALL SysCls
RETURN /* End of InstallMe */

/* UnInstallMe - uninstall ConfigTool */

UnInstallMe: PROCEDURE

prgname = 'ConfigTool 1.0.0'
CALL SysCls
SAY 'This is '||prgname||' UnInstallation procedure!'
SAY 'Your files are in directory: '||Directory()
SAY 'This procedure will:'
SAY '- Remove '||prgname||' specific entries in OS2.INI file, App ToolsByGoran.'
SAY '- Destroy '||prgname||' Program object'
SAY 'Press "Y" (and Enter) to start UnInstall, any other key to exit...'
PULL answer
IF answer <> "Y" THEN DO
    CALL NoAction 'UnInstall terminated.'
END
SAY ' '
SAY 'Removing entries from OS2.INI'
CALL SysIni 'USER','ToolsByGoran','CFGtoolWorkDir','DELETE:'
CALL SysIni 'USER','ToolsByGoran','CFGtoolINIfile','DELETE:'
SAY ' '
SAY 'Destroying Program object'
CALL SysDestroyObject '<CONFIGTOOL_DAT_INF>'
CALL SysDestroyObject '<CONFIGTOOL_DAT_TXT>'
CALL SysDestroyObject '<CONFIGTOOL_DAT_HTM>'
CALL SysDestroyObject '<CONFIGTOOL_HENG>'
CALL SysDestroyObject '<CONFIGTOOL_HSWE>'
CALL SysDestroyObject '<CONFIGTOOL_PROGRAM>'
CALL SysDestroyObject '<CONFIGCOMP_PROGRAM>'
SAY ' '
SAY 'UnInstallation complete.'
SAY 'You can delete files in directory '||Directory()
SAY 'To install '||prgname||' again, start CFGinst I. Press Enter to exit...'
PULL answer
RETURN /* End of UnInstallMe */

/* Rc1 - return code - SysIni */

Rc1:        PROCEDURE

PARSE ARG rcSysIni
SELECT
    WHEN rcSysIni = 'ERROR:' THEN rc1 = 'Error writing to INI file!'
    OTHERWISE rc1 = 'OK'
END
RETURN rc1 /* End of Rc1 */

/* Rc2 - return code - SysCreateObject */

Rc2:        PROCEDURE

PARSE ARG rcSysCreateObject
SELECT
    WHEN rcSysIni = 0 THEN rc2 = 'Error'
    OTHERWISE rc2 = 'OK'
END
RETURN rc2 /* End of Rc2 */
