/* enumerate device drivers on system */

/*
* Copyright 1993 by Kenneth Porter (shiva@well.sf.ca.us).
* Freely redistributable.
* Code may be used if attribution given.
*/

#define INCL_NOPM
#define INCL_NOCOMMON
#define INCL_DOSERRORS
#define INCL_DOSFILEMGR
#define INCL_DOSMISC
#include <stdio.h>
#include <string.h>
#include <os2.h>

#if defined(__BORLANDC__)
#   define __32BIT__	/* 2.0 indicator */
#endif

typedef struct _FSQ {
    USHORT iType;
    UCHAR szName[CCHMAXPATH];
    UCHAR szFSDName[CCHMAXPATH];
} FSQ;
typedef FSQ *PFSQ;

static void QueryDevs(USHORT InfoLevel);

static unsigned QueryDevice(unsigned Ordinal, unsigned InfoLevel, PFSQ pfsq);
static void DisplayDevice(PFSQ pfsq);

static void EnablePopUps(void);
static void DisablePopUps(void);

int main(void)
{
    printf("                Device List\n");
    QueryDevs(FSAIL_DEVNUMBER);
    printf("\n                Drive List\n");
    QueryDevs(FSAIL_DRVNUMBER);
    return 0;
}

static void QueryDevs(USHORT InfoLevel)
{
    unsigned devnum, error;
    FSQ fsq;
    
    for (error=0,devnum=1; ERROR_NO_MORE_ITEMS != error; devnum++) {
	/* disallow error popups (mostly for floppy queries when
	    drive is empty) */
	DisablePopUps();
	error = QueryDevice(devnum, InfoLevel, &fsq);
	EnablePopUps();
	if (0 == error) DisplayDevice(&fsq);
	else if (ERROR_NO_MORE_ITEMS != error) {
	    if (ERROR_NOT_READY == error)
		printf("Drive %d not ready\n",devnum);
	    /* single drive shares two drive letters */
	    else if (ERROR_DISK_CHANGE == error) continue;
	    else printf(
		"InfoLevel %d, Device Number %d returned Error %d\n",
		InfoLevel, devnum, error);
	}
    }
}

static void DisplayDevice(PFSQ pfsq)
{
    char *type;
    
    switch (pfsq->iType) {
	case FSAT_CHARDEV: type = "Resident character device"; break;
	case FSAT_PSEUDODEV: type = "Pseudo-character device"; break;
	case FSAT_LOCALDRV: type = "Local drive"; break;
	case FSAT_REMOTEDRV: type = "Remote drive"; break;
	default: type = "Unknown type"; break;
    }
    printf("%-20s%-26s%-s\n",pfsq->szName,type,pfsq->szFSDName);
}

/* DosError symbol names changed from 1.x to 2.x */

static void DisablePopUps(void)
{
    DosError(
#if defined(__32BIT__)
	     FERR_DISABLEHARDERR|FERR_ENABLEEXCEPTION
#else
	     HARDERROR_DISABLE|EXCEPTION_ENABLE
#endif
	     );
}

static void EnablePopUps(void)
{
    DosError(
#if defined(__32BIT__)
	     FERR_ENABLEHARDERR|FERR_ENABLEEXCEPTION
#else
	     HARDERROR_ENABLE|EXCEPTION_ENABLE
#endif
	     );
}

/* DosQFSAttach -> DosQueryFSAttach, and order of contents of buffer changed */

static unsigned QueryDevice(unsigned Ordinal, unsigned InfoLevel, PFSQ pfsq)
{
#if defined(__32BIT__)
    union {
	BYTE byte[100];
	FSQBUFFER2 fsqbuffer2;
    } fsqbuf;
    ULONG fsqsize, error;
    fsqsize = sizeof fsqbuf;
    error = DosQueryFSAttach(NULL,Ordinal,InfoLevel,
			     &fsqbuf.fsqbuffer2,&fsqsize);
    if (!error) {
	pfsq->iType = fsqbuf.fsqbuffer2.iType;
	strcpy((char *)pfsq->szName,(char *)fsqbuf.fsqbuffer2.szName);
	/* file system name follows name and null char */
	strcpy((char *)pfsq->szFSDName,
	       (char *)fsqbuf.fsqbuffer2.szName+fsqbuf.fsqbuffer2.cbName+1);
    }
#else
    union {
	BYTE byte[100];
	FSQBUFFER fsqbuffer;
    } fsqbuf;
    USHORT fsqsize, error;
    fsqsize = sizeof fsqbuf;
    error = DosQFSAttach(NULL,Ordinal,InfoLevel,fsqbuf.byte,&fsqsize,0l);
    if (!error) {
	pfsq->iType = fsqbuf.fsqbuffer.iType;
	strcpy((char *)pfsq->szName,(char *)fsqbuf.fsqbuffer.szName);
	/* file system name follows name, null char, and USHORT count */
	strcpy((char *)pfsq->szFSDName,(char *)fsqbuf.fsqbuffer.szName+
	       fsqbuf.fsqbuffer.cbName+1+sizeof fsqbuf.fsqbuffer.cbFSDName);
    }
#endif
    return error;
}
