typedef struct
{
    BYTE pStatus;
    BYTE startHead;
    unsigned startSec : 6;
    unsigned startCyl : 10;
    BYTE pType;
    BYTE endHead;
    unsigned endSec : 6;
    unsigned endCyl : 10;
    ULONG bootLoc;
    ULONG secCount;
} PARTITIONENTRY;

typedef PARTITIONENTRY* PPARTITIONENTRY;

typedef struct
{
    BYTE bootCode[446];
    BYTE partTable[64];
    BYTE remainder[1];
} BOOTRECORD;

typedef BOOTRECORD* PBOOTRECORD;

typedef struct
{
    ULONG totalSectors;
    ULONG actualFreeSectors;
    ULONG reportedFreeSectors;
    ULONG sectorSize;
} FREESPACEINFO;

typedef FREESPACEINFO* PFREESPACEINFO;

typedef struct
{
    UCHAR errorFunc[256];
    UCHAR errorHome[256];
    ULONG errorCode;
    BOOL success;
} FUNCRETURN;

typedef FUNCRETURN* PFUNCRETURN;

typedef struct
{
    ULONG sectorSize;
    ULONG totalSectors;
    ULONG dirBandSectors;
    ULONG dirBandBitmapSectors;
    ULONG spareDirBlockSectors;
    ULONG codePageSectors;
    ULONG frontStructures;
    ULONG hotfixSectors;
    ULONG hotfixListSectors;
    ULONG bitmapListSectors;
    ULONG bitmapSectors;
    ULONG badSectorListSectors;
    ULONG securityBlockSectors;
    ULONG rootFNode;
    ULONG rootDirBlock;
    ULONG totalSystemSectors;
} SYSTEMUSAGE;

typedef SYSTEMUSAGE* PSYSTEMUSAGE;

typedef struct
{
    ULONG signature[2];
    BYTE version;
    BYTE funcVersion;
    BYTE align32[2];
    ULONG rootFNode;
    ULONG sectorCount;
    ULONG badSectorCount;
    ULONG bitmapList;
    ULONG spareBitmapList;
    ULONG badSectorList;
    ULONG spareBadSectorList;
    ULONG lastCheckDate;
    ULONG lastOptimizedDate;
    ULONG dirBandSectorCount;
    ULONG dirBandStart;
    ULONG dirBandEnd;
    ULONG dirBandBitmap;
    BYTE reserved[32];
    ULONG securityBlock;
} SUPERBLOCK;

typedef SUPERBLOCK* PSUPERBLOCK;

typedef struct
{
    ULONG signature[2];
    BYTE partStatus;
    BYTE align32[3];
    ULONG hotfixList;
    ULONG hotfixUsed;
    ULONG hotfixTotal;
    ULONG spareDirBlockCount;
    ULONG spareDirBlockFree;
    ULONG codePageSector;
    ULONG codePageCount;
    ULONG superBlockCRC;
    ULONG spareBlockCRC;
    BYTE reserved[60];
    ULONG firstSpareDirBlock[1];
} SPAREBLOCK;

typedef SPAREBLOCK* PSPAREBLOCK;

typedef struct
{
    unsigned bit0 : 1;
    unsigned bit1 : 1;
    unsigned bit2 : 1;
    unsigned bit3 : 1;
    unsigned bit4 : 1;
    unsigned bit5 : 1;
    unsigned bit6 : 1;
    unsigned bit7 : 1;
} BYTEBITFIELD;
