{$A+,B-,D-,F-,G+,I-,K+,L-,N-,P+,Q-,R-,S+,T-,V+,W-,X+,Y-}
{$M 8192,8192}
Program GENKBRES; {$d               Tastaturtabellen-Ressourcen-Generator }
                  {$ifndef Windows} fr Microsoft Windows
                  {$endif}{         Martin Krieger - c't 12/93  }
{ Wegen der ANSI-Codes bitte unter BPW eingeben! }
uses wintypes, winprocs;

type b= byte;  { spart Platz und Tipparbeit }

const
  { die fehlenden virtuellen Tasten }
  VK_OEM_1      = $BA;   {     }  VK_OEM_PLUS   = $BB;   { + * ~ }
  VK_OEM_COMMA  = $BC;   { , ;   }  VK_OEM_MINUS  = $BD;   { - _   }
  VK_OEM_PERIOD = $BE;   { . :   }  VK_OEM_2      = $BF;   { # '   }
  VK_OEM_3      = $C0;   {     }  VK_OEM_4      = $DB;   {  ? \ }
  VK_OEM_5      = $DC;   { ^    }  VK_OEM_6      = $DD;   {  `   }
  VK_OEM_7      = $DE;   {     }
  VK_OEM_8      = $DF;   { # ^  auf AT-Tastatur }
  VK_OEM_102    = $E2;   { < > | }
  VK_SCROLL     = $91;   { in WIN31 definiert }
  VK_0          = $30;   { Zahlen sind, da identisch mit '0' bis '9',}
  VK_1          = $31;   { nicht in Wintypes definiert. }
  VK_2 = $32; VK_3 = $33; VK_4 = $34; VK_5 = $35;
  VK_6 = $36; VK_7 = $37; VK_8 = $38; VK_9 = $39;
    { Tabelle, welche nach Tastatur-Scancodes geordnet die }
    { virtuellen Tastencodes beinhaltet. Hier knnen Tasten }
    { vertauscht werden. }
  KeyTrTab: array [0..$59] of byte =
    ($FF, VK_ESCAPE,                                 { $00 - $01}
     VK_1, VK_2, VK_3, VK_4, VK_5, VK_6, VK_7, VK_8, VK_9, VK_0,
     VK_OEM_4, VK_OEM_6, VK_BACK,                    { $02 - $0e}
     VK_TAB, b('Q'), b('W'), b('E'), b('R'), b('T'), b('Z'),
     b('U'), b('I'), b('O'), b('P'), VK_OEM_1, VK_OEM_PLUS,
                                                     { $0f - $1b}
     VK_RETURN, VK_CONTROL,                          { $1c - $1d}
     b('A'), b('S'), b('D'), b('F'), b('G'), b('H'), b('J'),
     b('K'), b('L'), VK_OEM_3, VK_OEM_7,             { $1e - $28}
     VK_OEM_5, VK_SHIFT, VK_OEM_2,                   { $29 - $2b}
     b('Y'), b('X'), b('C'), b('V'), b('B'), b('N'), b('M'),
     VK_OEM_COMMA, VK_OEM_PERIOD, VK_OEM_MINUS,      { $2c - $35}
     VK_SHIFT, VK_MULTIPLY, VK_MENU, VK_SPACE, VK_CAPITAL,
                                                     { $36 - $3a}
     VK_F1, VK_F2, VK_F3, VK_F4, VK_F5, VK_F6, VK_F7, VK_F8,
     VK_F9, VK_F10,                                  { $3b - $44}
     VK_NUMLOCK, VK_SCROLL,                          { $45 - $46}
     VK_HOME, VK_UP, VK_PRIOR, VK_SUBTRACT, VK_LEFT, VK_CLEAR,
     VK_RIGHT, VK_ADD, VK_END, VK_DOWN, VK_NEXT, VK_INSERT,
     VK_DELETE, $FF, $FF,                            { $47 - $55}
     VK_OEM_102, VK_F11, VK_F12,                     { $56 - $58}
     $00);        { Nullterminiert! }                      { $59}

  { Tastaturoptionen }
  kbShiftLock = $40;  { wenn man lieber Shift als Capslock mag...}
  kbAltGr     = $08;  { AltGr oder rechte Alt-Taste? }

  { Resourcenkonstanten }
  rt_Tastaturtab = $0abc; rd_KbdTable    = 1; rd_KeyTrTab    = 2;
  rd_Header      = 3;     rd_KeyNames    = 4;

  { Resource - Ladeoptionen }
  RnMove = $0010; RnPure = $0020; RnPreload = $0040; RnDiscard = $1000;

var
  resfile: file;                respfad, msgtext: string;
  tabelle: array [1..3, 1..$FF] of byte;
  namentab: array [0..76] of word;
  laenge, position, w, x: word;

  ResHead: record  { Der Kopf jeder Resource in der .RES Datei }
             NameResType: byte;  { $FF wenn kein Name angegeben }
             ResType: word;      { Nummer des Resourcentyps }
             NameResource: byte; { $FF wenn kein Name angegeben }
             Resource: word;     { Nummer der Resource }
             Flags: word;        { Ladeoptionen }
             Length: word;       { Lnge in Bytes der Resource }
             Reserved: word;     { 0 }
           end;

  Header: record  { Informationen zu den Tastaturdaten }
            TableType: byte;  { Welche Tastatur? 4= MF-II }
            fKeyType: byte;   { Die Tastaturoptionen }
            szAscTran,        { Tabellengren }
            szAscControl, szAscCtlAlt, szAscShCtlAlt,
            szMorto, szSGCaps, szCapital, szDeadKey: word;
              { Positionen der zu bersetzenden VK_Codes }
            AscTranVK, AscControlVK, AscCtlAltVK, AscShCtlAltVK,
            Morto, DeadKeyCode, SGCapsVK, CapitalTable: word;
              { Positionen der ASCII Codes fr die VK_Codes }
            AscTran, AscControl, AscCtlAlt, AscShCtlAlt,
            MortoCode, DeadChar, SGTrans: word;
          end;

  { Einige HilfsProzeduren, um die bersetzten und zu bersetzenden }
  { Zeichen lesbarer nebeneinander eingeben zu knnen }
procedure startTab;
begin laenge:= 0 end;

procedure e (vkcode: byte); { e_in-Zeichen-Tabelle }
begin
  inc(laenge); tabelle[1,laenge]:= vkcode;
end;

procedure endeTabE (var Tabgroesse, vkcode: word);
begin
  for w:= 1 to laenge do blockwrite (resfile, tabelle[1,w], 1);
  Tabgroesse:= laenge;   vkcode:= position;
  position:= position + laenge;
end;

procedure z (vkcode: byte; ansi: char); { z_wei-Zeichen-Tab }
begin
  inc(laenge);
  tabelle[1,laenge]:= vkcode;   tabelle[2,laenge]:= b( ansi);
end;

procedure endeTabZ (var Tabgroesse, vkcode, ansicode: word);
begin
  for x:= 1 to 2 do
    for w:= 1  to laenge do blockwrite (resfile, tabelle[x,w], 1);
  Tabgroesse:= laenge;            vkcode:= position;
  ansicode:= position + laenge;   position:= position + laenge * 2;
end;

procedure d (vkcode: byte ; ansi, ansishift :char); { d_rei-... }
begin
  inc(laenge);                    tabelle[1,laenge]:= vkcode;
  tabelle[2,laenge]:= b (ansi);   tabelle[3,laenge]:= b (ansishift);
end;

procedure EndeTabD (var Tabgroesse, vkcode, ansicode: word);
begin
  for w:= 1 to laenge do blockwrite (resfile, tabelle [1,w], 1);
  for w:= 1 to laenge do begin
    blockwrite (resfile, tabelle [2,w], 1);
    blockwrite (resfile, tabelle [3,w], 1);
  end;
  Tabgroesse:= laenge;            vkcode:= position;
  ansicode:= position + laenge;   position:= position + laenge * 3;
end;

procedure tt (vkcode, shift: byte; ansi: char); { Tottasten }
begin
  inc(laenge);                  tabelle[1,laenge]:= vkcode;
  tabelle[2,laenge]:= shift;    tabelle[3,laenge]:= b (ansi);
end;

procedure t (grundz, akzent, ansi: char); { Tottastenbuchst. }
begin
  inc(laenge);                    tabelle[1,laenge]:= b (grundz);
  tabelle[2,laenge]:= b (akzent); tabelle[3,laenge]:= b (ansi);
end;

procedure EndeTabT (var Tabgroesse, vkcode, ansicode: word);
begin
  for w:= 1 to laenge do begin
    blockwrite (resfile, tabelle [1,w], 1);
    blockwrite (resfile, tabelle [2,w], 1);
  end;
  for w:= 1 to laenge do blockwrite (resfile, tabelle [3,w], 1);
  Tabgroesse:= laenge * 2;          vkcode:= position;
  ansicode:= position + laenge * 2; position:= position + laenge * 3;
end;

procedure n (name: string); { Tastennamen }
begin
  namentab[laenge]:= position;  inc(laenge); name:=name+#0;
  blockwrite (resfile, name[1], length(name));
  inc(position, length(name));
end;

procedure endeTabN;
begin
  seek(resfile, (filepos (resfile)- position - sizeof(namentab)));
  blockwrite(resfile, namentab, sizeof(namentab));
end;

Begin
  getdir(0, respfad);
  if length(respfad) > 3 then respfad:= respfad +'\';
  respfad:= respfad+'KBD_CT.RES';
  assign(resfile,respfad);
  filemode := 0;
  reset(resfile);       close(resfile);
  if ioresult = 0 then begin
    msgtext:='Datei '+respfad+' existiert bereits.'+
             #10'berschreiben?'#0;
    if idok <> messagebox(0,@msgtext[1], 'GENKBDRES',
         mb_iconquestion or mb_okcancel) then halt;
  end;
  rewrite(resfile,1);
{### KbdTable ###}
  with ResHead do begin
    NameResType := $FF;         NameResource := $FF;
    Reserved := 0;              ResType := rt_tastaturtab;
    Resource := rd_KbdTable;    Flags:= RnPreload or RnPure;
  end;
  blockwrite(resfile, reshead, sizeof(reshead));

  position := 0;
  with Header do begin
      { Die Tabelle der ANSI-Zeichen. Fr jede Zeichenaste, }
      { auer A - Z und den Zahlenblock - Zifferntasten, }
      { die Zeichen ohne und mit Shift. }
    startTab;
    d( VK_SPACE,       ' ',  ' '); d( VK_TAB,        #$09, #$09);
    d( VK_RETURN,     #$0d, #$0d); d( VK_BACK,       #$08, #$08);
    d( VK_ESCAPE,     #$1b, #$1b); d( VK_CANCEL,     #$03, #$03);
    d( VK_0,           '0',  '='); d( VK_1,           '1',  '!');
    d( VK_2,           '2',  '"'); d( VK_3,           '3',  '');
    d( VK_4,           '4',  '$'); d( VK_5,           '5',  '%');
    d( VK_6,           '6',  '&'); d( VK_7,           '7',  '/');
    d( VK_8,           '8',  '('); d( VK_9,           '9',  ')');
    d( VK_OEM_COMMA,   ',',  ';'); d( VK_OEM_PERIOD,  '.',  ':');
    d( VK_OEM_MINUS,   '-',  '_'); d( VK_OEM_PLUS,    '+',  '*');
    d( VK_OEM_1,       '',  ''); d( VK_OEM_2,       '#', #$27);{ ' }
    d( VK_OEM_3,       '',  ''); d( VK_OEM_4,       '',  '?');
    d( VK_OEM_5,       '^',  '');
    d( VK_OEM_6,      #$FF, #$FF);  {Tottasten}
    d( VK_OEM_7,       '',  ''); d( VK_OEM_102,     '<',  '>');
    d( VK_DECIMAL,     ',',  ',');
         { Zehnerblock mu nach den VK_OEM_ Tasten kommen! }
    d( VK_MULTIPLY,    '*',  '*'); d( VK_SUBTRACT,    '-',  '-');
    d( VK_ADD    ,     '+',  '+'); d( VK_DIVIDE ,     '/',  '/');
    endeTabD (szAscTran, AscTranVK, AscTran);

      { Tabelle der VK_Zeichen mit Ctrl und ihrer ANSI Werte }
    startTab;
    z( VK_CANCEL,     #$03);       z( VK_BACK,       #$7f);
    z( VK_RETURN,     #$0a);       z( VK_ESCAPE,     #$1b);
    z( VK_SPACE,       ' ');
    endeTabZ (szAscControl, AscControlVK, AscControl);
      { Das Original definiert zustzlich noch 2: $80; 6: $9e; }
      { : $1b; #: $1c; +: $1d; -: $9f. Nur ... wozu dient das? }

      { Tabelle fr Ctrl_Alt }
    startTab;
    z( VK_2,           '');    z( VK_3,           '');
    z( VK_7,           '{');    z( VK_8,           '[');
    z( VK_9,           ']');    z( VK_0,           '}');
    z( VK_OEM_4,       '\');    z( b('Q'),         '@');
    z( VK_OEM_PLUS,    '~');    z( b('M'),         '');
    z( VK_OEM_102,     '|');
    endeTabZ (szAscCtlAlt, AscCtlAltVK, AscCtlAlt);

      { Tabelle fr Shift_Ctrl_Alt. Hier leer. }
    startTab;
    { z( VK_xx, 'y'); }
    endeTabZ (szAscShCtlAlt, AscShCtlAltVK, AscShCtlAlt);

      { Welche Tasten sind 'Tottasten'? VK_Code; Shiftstatus }
      { 0: ohne Shift, 1: mit; Zeichen. }
    startTab;
    tt( VK_OEM_6, 0, '' );
    tt( VK_OEM_6, 1, '`' );
    endeTabT (szMorto, Morto, MortoCode);

      { Die Tottasten. Jeweils das Grundzeichen, den Akzent und }
      { der akzentuierte Buchstabe. }
    startTab;
    t( 'a', '', '');  t( 'e', '', '');  t( 'i', '', '');
    t( 'o', '', '');  t( 'u', '', '');  t( 'y', '', '');
    t( 'A', '', '');  t( 'E', '', '');  t( 'I', '', '');
    t( 'O', '', '');  t( 'U', '', '');  t( 'Y', '', '');
    t( ' ', '', '');  t( 'a', '`', '');  t( 'e', '`', '');
    t( 'i', '`', '');  t( 'o', '`', '');  t( 'u', '`', '');
    t( 'A', '`', '');  t( 'E', '`', '');  t( 'I', '`', '');
    t( 'O', '`', '');  t( 'U', '`', '');  t( ' ', '`', '`');
    endeTabT (szDeadKey, DeadKeyCode, DeadChar);

      { Tabelle der Zeichen, die mit Shift-Lock anders aussehen }
      { als mit Shift. Wird nur auf der Schweizer Tastatur }
      { bentigt. VK_ und das bei Shift-Lock auszugebende Zeichen. }
    startTab;
    { Format: z( VK_xx, 'y'); }
    endeTabZ (szSGCaps, SGCapsVK, SGTrans);

      { Tabelle der Zeichen, die von Caps- bzw. Shift-Lock }
      { beeinflut werden; zustzlich zu A bis Z, hier nut , ,  }
    startTab;
    e( VK_OEM_1 ); e( VK_OEM_3 );  e( VK_OEM_7 );
    endeTabE (szCapital, CapitalTable);
  end; {with}

      { Trage die Lnge im Resourcekopf ein. }
  seek(resfile, (filepos(resfile)- position - 4));
  blockwrite (resfile, position, 2);
  seek(resfile, (filepos(resfile)+ position + 2));
      { Ein Seek(8) tte es auch, so aber kann die Reihenfolge }
      { der Ressourcenkomponenten gendert werden. }

{### KeyTrTab ###}
  with ResHead do begin
    Resource := rd_KeyTrTab;
    Flags:= RnPreload or RnMove or RnDiscard or RnPure;
    Length:= SizeOf (KeyTrTab);
  end;
  blockwrite (resfile, reshead, SizeOf (reshead));
  blockwrite (resfile, KeyTrTab, SizeOf (KeyTrTab));

{### Header ###}
  with ResHead do begin
    Resource := rd_Header;
    Flags:= RnPreload or RnMove or RnDiscard or RnPure;
    Length:= SizeOf (Header);
  end;
  blockwrite (resfile, reshead, SizeOf (reshead));

  Header.TableType := 4;
  Header.fKeyType := kbAltGr;
  blockwrite (resfile, Header, SizeOf (Header));

{### KeyNames ###}
  with ResHead do begin
    Resource := rd_KeyNames;
    Flags:= RnPreload or RnMove or RnDiscard or RnPure;
  end;
  blockwrite (resfile, reshead, SizeOf (reshead));
  blockwrite (resfile, namentab, SizeOf (namentab));{Platzhalter}

  position:= 0;
  startTab;
    { Die "bersetzungsbedrftigen" Tastennamen. Der Inhalt und }
    { die Reihenfolge sind fr alle Tastaturen gleich, daher }
    { F13, HILFE usw. }
  n('Esc'); n('Rck'); n('Tabulator'); n('Eingabe'); n('Strg');
  n('Umschalt'); n(' (Zehnertastatur)'); n('Umschalt Rechts');
  n(' (Zehnertastatur)'); n('Alt'); n('Leer'); n('Feststell');
  n('F1'); n('F2'); n('F3'); n('F4'); n('F5'); n('F6'); n('F7');
  n('F8'); n('F9'); n('F10'); n('PAUSE'); n('Rollen-Feststell');
  n('7 (Zehnertastatur)'); n('8 (Zehnertastatur)');
  n('9 (Zehnertastatur)'); n('- (Zehnertastatur)');
  n('4 (Zehnertastatur)'); n('5 (Zehnertastatur)');
  n('6 (Zehnertastatur)'); n('+ (Zehnertastatur)');
  n('1 (Zehnertastatur)'); n('2 (Zehnertastatur)');
  n('3 (Zehnertastatur)'); n('0 (Zehnertastatur)');
  n('Komma (Zehnertastatur)'); n('F11'); n('F12'); n('F13');
  n('F14'); n('F15'); n('F16'); n('F17'); n('F18'); n('F19');
  n('F20'); n('F21'); n('F22'); n('F23'); n('F24'); n('HILFE');
  n('Lsch'); n('Untbr'); n('<00>'); n('Druck');
  n('Num-Feststell'); n('Eingabe (Zehnertastatur)'); n('Alt Gr');
  n('Pos1'); n('Nach-oben'); n('Bild-nach-oben');
  n('Nach-links'); n('nach-rechts'); n('Ende'); n('Nach-unten');
  n('Bild-nach-unten'); n('Einfg'); n('Entf'); n('Strg-Rechts');
  n('Akut'); n('Gravis'); n('Zirkumflex'); n('Umlaut');
  n('Tilde'); n('Cedille'); n('');
  endeTabN;

  position:= position+ sizeof(namentab);
  seek(resfile, (filepos(resfile)- sizeof(namentab) - 4));
  blockwrite (resfile, position, 2);
  seek(resfile, (filepos(resfile)+ sizeof(namentab) + 2));

  close(resfile);
  if inoutres <> 0 then begin
    str (ioresult, msgtext);
    msgtext:= 'Fehler #'+msgtext+' beim Schreiben der Datei '+
    respfad+#0;
    messagebox(0, @msgtext[1], nil, mb_iconexclamation);
  end else begin
    msgtext:='Datei '+respfad+' erfolgreich geschrieben.'#0;
    messagebox(0, @msgtext[1], 'GENKBDRES',mb_iconinformation);
  end
end.
