/* @(#)kill.c 1999Mar02 <jerodd@usa.net> */

/* Compile this with EMX. It's useful for handling programs like */
/* named, Apache (httpd/httpsd), or xfstt, which have features that */
/* are invoked by sending hangup signals and the like. Direct comments */
/* to <jerodd@usa.net>. http://iiinet.dhs.org:8/kill or Hobbes should */
/* contain the most recent version of this program. Includes kill -9 */
/* support which does not send a regular SIGKILL signal, but instead */
/* invokes the ``death'' signal sending; this behavior will require */
/* a recent version of XF86SUP.SYS and a recent OS2KRNL version (FixPak 17 */
/* should be sufficient for OS/2 Version 3). */

/*
    A utility for sending signals to processes that use EMX.
    Copyright (C) 1999 Joshua E. Rodd, <jerodd@usa.net>.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version. The file COPYING should contain
    this licence.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details. The file COPYING should
    contain this licence.

    You should have received a copy of the GNU General Public License
    along with this program in the file COPYING; if not, write to the
    Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
    USA.
*/

#include <stdio.h>
#include <signal.h>
#define INCL_DOS
#define INCL_ERRORS
#include <os2.h>

#define DOSIG( tkn ) { #tkn, SIG##tkn } ,

/* You can add new signal types you want here. Make sure that flg[] is wide */
/* enough to hold the longest name (i.e. WINCH is five right now, so five */
/* plus a null is six, hence flg[6]; if you add SIGMYSIGNAL, then you'd */
/* have to make it flg[9]). */
typedef struct _asigtype {
 char flg[6]; int signum;
} asigtype;
asigtype sigtypes[10] = {
 DOSIG( HUP ) /* Hangup: user is turning off their terminal. */
 DOSIG( INT ) /* Interrupt: user pressed Ctrl+C. */
 DOSIG( QUIT ) /* Quit: windowing environment is closing your process. */
 DOSIG( KILL ) /* Kill: a very fatal signal was sent (but see -9). */
 DOSIG( TERM ) /* Terminate: user used kill(1) utility with no parameters. */
 DOSIG( USR1 ) /* User-defined signal 1 */
 DOSIG( USR2 ) /* User-defined signal 2 */
 DOSIG( WINCH ) /* Window size change: windowing environment resized window */
 { "9", -1, } , /* this is for the ``fatal'' kill -9 usage */
 { "", 0 }
};

/* Print correct usage. */
int usage( char* pname ) {
 fprintf( stdout, "Usage: %s [SIGNALTYPE] PID\n" \
  "Where:\n" \
  "PID is the decimal process ID of the process to be killed (or signalled).\n" \
  "SIGNALTYPE is optional, but may be one of the following:\n" \
  " -HUP: Hangup process; typically reloads internal databases.\n" \
  " -INT: Interrupt; typically stops a subtask, such as an FTP transfer.\n" \
  " -QUIT: Quit; typically makes a program stop in a very clean fasion.\n" \
  " -KILL: Kill a process mandatorily. Try using -9 if this doesn't work.\n" \
  " -TERM: Ask a process to kill itself.\n" \
  " -USR1: Send user-defined signal 1; specific to your application.\n" \
  " -USR2: Send user-defined signal 2; specific to your application.\n" \
  " -WINCH: Notify of Windowsize change; useful if you used MODE COyy,xxx\n" \
  "         to change the number of rows and/or columns. Most applications\n" \
  "         will not understand this signal.\n" \
  " -9: Kill a process in a fatal manner. If using -KILL doesn't work, try\n" \
  "     this option (but be aware some processes still will not die).\n" \
  "named, the nameserver, uses -INT to dump its own database, -USR1 to\n" \
  "increase the debugging level, and -USR2 to stop debugging.\n" \
  "The -9 option requires that XF86SUP.SYS be installed and OS/2 version 3\n" \
  "with FixPak 17 or later (or any newer version of OS/2) be installed.\n" \
  "Please note that -9 is NOT a synonym for -KILL, at least not as it is\n" \
  "so used in kill(1) as found in 4.4BSD.\n" );
 return 0;
}

int main( int argc, char* argv[] ) {
 int pid;
 int rc;
 int sigtype = SIGTERM;
 int typi;
 if( argc < 2 || argc > 3 ) return usage( argv[0] );
 if( argc == 3 ) {
  if( argv[1][0] != '-' ) return usage( argv[0] );
  for( typi = 0; typi >= 0; typi++ ) {
   if( sigtypes[typi].flg[0] == '\0' ) {
    fprintf( stderr, "%s: unknown signal type `%s'\n", argv[0], &(argv[1][1])
     );
    return 1;
   }
   if( !strcmp( &(argv[1][1]), sigtypes[typi].flg ) ) {
    sigtype = sigtypes[typi].signum;
    break;
   }
  }
 }
 pid = atoi( argv[argc - 1] );
 if( pid < 1 ) {
  fprintf( stderr, "%s: bad process ID\n", argv[0] );
  return 1;
 }
 if( sigtype < 0 ) {
  HFILE fd;
  ULONG action, plen;
  USHORT param = pid;
  if( pid < 13 ) {
   fprintf( stderr, "%s: cannot send signal 9 to processes with IDs lower " \
    "than 13\n", argv[0] );
   return 1;
  }
  if( DosOpen( "\\DEV\\FASTIO$", &fd, &action, 0, FILE_SYSTEM, FILE_OPEN,
   OPEN_SHARE_DENYNONE | OPEN_FLAGS_NOINHERIT | OPEN_ACCESS_READONLY,
   0 ) ) {
   fprintf( stderr, "%s: the `-9' parameter requires that XF86SUP.SYS is " \
    "installed.\n" \
    "%s: add a line like `DEVICE=S:\\OMEWHERE\\XF86SUP.SYS to CONFIG.SYS\n",
    argv[0], argv[0] );
   return 1;
  }
  if( DosDevIOCtl( fd, 118, 101, (PULONG*)(&param), 2, &plen, NULL, 0, NULL ) )
  {
   fprintf( stderr, "%s: process ID %d: error sending signal 9\n", argv[0],
    pid );
   return 1;
  }
  DosClose( fd );
 }
 else {
  rc = kill( pid, sigtype );
  if( rc < 0 ) {
   fprintf( stderr, "%s: process ID %d", argv[0], pid );
   perror( ": error" );
   return 1;
  }
 }
 return 0;
}
