
package NET.ibm.malamut.transformator;

import java.io.*;
/**
 * This class can be used to read and write files that use different font encodings.
 * 
 */
public class Transformator {
	private String text = null;

/**
 * Returns the text that has been input so far.
 * @return java.lang.StringBuffer
 */
public String getText () {
	return text;
}
/**
 * Reads in some text from the file called fileName using the given encoding.
 *
 * If fileName is null, stdin is being used.
 * @param fileName java.lang.String
 * @param encoding java.lang.String
 */
public void read (String fileName, String encoding) throws FileNotFoundException, UnsupportedEncodingException, IOException {
	InputStream in;
	if (fileName==null) in = System.in;
	else in = new FileInputStream (new File(fileName));
	BufferedReader b;
	if (encoding==null) b = new BufferedReader (new InputStreamReader (in));
	else b = new BufferedReader (new InputStreamReader (in, encoding));
	
	StringBuffer buffer = new StringBuffer ();
	String s = null;
	do {
		s = b.readLine ();
		if (s!=null) buffer.append (s+"\n");
	} while (s!=null);
	text = buffer.toString();
		
}
/**
 * Writes some text to the file called fileName using the given encoding.
 *
 * If fileName is null, stdout is being used.
 * @param fileName java.lang.String
 * @param encoding java.lang.String
 */
public void write (String fileName, String encoding) throws NullPointerException, IOException, UnsupportedEncodingException {
	OutputStream out;
	if (fileName==null) out = System.out;
	else out = new FileOutputStream (new File(fileName));
	BufferedWriter b;
	if (encoding==null) b = new BufferedWriter (new OutputStreamWriter (out));
	else b = new BufferedWriter (new OutputStreamWriter (out, encoding));
	
	if (text==null) throw new NullPointerException ("Transformator.write(): nothing to write!");
	int start = 0, end = 0;
	while ( (end = text.indexOf ('\n',end)) != -1 ) {
		String s = text.substring (start, end);
		b.write (s,0,s.length());
		b.newLine();
		start = ++end;
	}
	try {
		String s = text.substring (start);
		b.write (s,0,s.length());
	} catch (IndexOutOfBoundsException e) {};	
		
	b.flush ();
	
}
}