
package NET.ibm.malamut.transformator.ui;

import java.awt.event.*;
import java.awt.*;
/**
 * This Listener handles the Choose-Button for encodings.
 * 
 */
class ChooseEncodingListener implements java.awt.event.ActionListener {
	Checkbox c;
	TextField t;
	static final String [][] choices = {
		{ "iso-8859-1", "Latin-1 (Unix Western Europe)" },
		{ "iso-8859-2", "Latin-2 (Unix Eastern Europe)" },
		{ "Cp437", "IBM Codepage 437 (PC International)" },
		{ "Cp850", "IBM Codepage 850 (PC Western Europe)" },
		{ "Cp852", "IBM Codepage 852 (PC Eastern Europe)" },
		{ "Cp1004", "MS Windows International" },
		{ "Cp1250", "MS Windows Eastern Europe" }};

/**
 * The only constructor.
 * @param c CheckBox
 * @param t TextField
 */
public ChooseEncodingListener (Checkbox c, TextField t) {
	this.c = c;
	this.t = t;
}
/**
 * Builds up a list of encodings, from which the user can choose.
 */
public void actionPerformed(ActionEvent e) {
	Frame f = new Frame ("Please choose an encoding scheme");
	f.setLayout (new BorderLayout());
	BroadList l = new BroadList (6);
	for (int i=0; i<choices.length; i++)
		l.add (choices[i][1]);
	f.add ("Center", l);
	Panel p = new Panel ();
	p.setLayout (new FlowLayout());
	Button bOk = new Button ("OK");
	bOk.addActionListener (new ChooseEncodingOkListener (this,f,l));
	p.add (bOk);
	Button bCancel = new Button ("Cancel");
	p.add (bCancel);
	bCancel.addActionListener (new CloseButtonListener (f));
	f.add ("South", p);
	f.addWindowListener (new CloseWindowAdapter());
	f.pack ();
	f.setSize (f.getPreferredSize());
	f.show ();
}
/**
 * Called if the user made a choice instead of cancelling the list of encodings.
 * @param index int
 */
public void choose (int index) {
	c.setState (true);
	t.setText (choices[index][0]);
}
}