
package NET.ibm.malamut.transformator.ui;

import java.awt.*;
import java.io.*;
/**
 * This class displays exceptions via awt.
 * 
 */
public class ErrorBox extends Frame {
	Throwable e;

/**
 * The only constructor.
 * @param e java.lang.Throwable
 */
public ErrorBox (Throwable e ) {
	super ("An Error Occurred");
	this.e = e;
	init ();
}
/**
 * Initializes the frame elements.
 */
public void init () {
	StringWriter sw = new StringWriter ();
	PrintWriter pw = new PrintWriter (sw);
	pw.println ("Exception occurred ("+e.getMessage()+"):");
	e.printStackTrace (pw);
	
	setLayout (new BorderLayout());
	TextPanel tp = new TextPanel ();
	tp.setText (sw.toString());
	add ("Center", tp);
	
	Panel p = new Panel();
	Button b = new Button ("OK");
	b.addActionListener (new CloseButtonListener (this));
	p.add (b);
	add ("South", p);	
	
	pack();
	Dimension ps = getPreferredSize ();
	setSize (ps);
	Dimension d = Toolkit.getDefaultToolkit().getScreenSize ();
	setLocation (new Point ((d.width-ps.width)/2, (d.height-ps.height)/2));
	addWindowListener (new CloseWindowAdapter());
}
}