/*
 * This REXX script will install The Larsen Commander folder object on your
 * WPS desktop. The folder object will have the WPS ID <LarsenCommanderFolder>.
 * This script checks if the folder already exist. If it does then it will
 * be automatically updated rather than replaced and a shadow will be created
 * on the desktop if necessary.
 */

call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
call SysLoadFuncs

say ""
say "-----------------------------------------------------------------------------"
say ""
say "Larsen Commander Desktop Installation Utility"
say ""
say "Do you want to install The Larsen Commander object on your Desktop (y or n)?"
say ""

key = SysGetKey('NOECHO')
parse upper var key key
if key == 'N' then call dont_install
call install

dont_install:
say "Installation was canceled."
call end

install:
say "Creating or updating The Larsen Commander objects..."

Directory = directory()

/*
 * First, create the LC folder object. If the LC folder is already
 * existing then make a shadow on the desktop, but only if the already
 * existing LC folder is existing in another folder than the desktop.
 */

type="WPFolder"
title="Larsen Commander"
folder="<WP_DESKTOP>"
objid="<LarsenCommanderFolder>"
params="BACKGROUND="Directory"\lcmdfldr.bmp,T,,I,0 0 0;ICONVIEWPOS=10,35,60,40;ICONFONT=9.WarpSans Bold;ICONTEXTCOLOR=0 0 64;ICONSHADOWCOLOR=0 0 255;ICONVIEW=FLOWED;OBJECTID="objid";ICONFILE="Directory"\lcmdfld1.ico;ICONNFILE=1,"Directory"\lcmdfld2.ico;"
if SysCreateObject(type, title, folder, params, "fail") then
   say "Larsen Commander Folder Object successfully created."
else do
   type="WPShadow"
   params="SHADOWID="objid";"
   if SysCreateObject(type, title, folder, params, "fail") then do
      say "Larsen Commander Folder Shadow Object already exists!"
   end
end

/*
 * Create or update the README object.
 */

type="WPShadow"
folder="<LarsenCommanderFolder>"
params="SHADOWID="Directory"\lcmd.txt;"
if SysCreateObject(type, "lcmd.txt", folder, params, "replace") then
   say "LCMD.TXT Shadow Object successfully created."
else do
   say "Failed on create the LCMD.TXT Shadow Object!"
   call end
end

/*
 * Create or update the KEYS HELP object.
 */

type="WPShadow"
folder="<LarsenCommanderFolder>"
params="SHADOWID="Directory"\lcmdkeys.txt;"
if SysCreateObject(type, "lcmdkeys.txt", folder, params, "replace") then
   say "LCMDKEYS.TXT Shadow Object successfully created."
else do
   say "Failed on create the LCMDKEYS.TXT Shadow Object!"
   call end
end

/*
 * Create or update the User Menu Resource Script program object.
 */

type="WPProgram"
title="User Menu Definition"
objid="<LarsenCommanderUserResourceScript>"
folder="<LarsenCommanderFolder>"
params="PROGTYPE=PM;EXENAME=e.exe;PARAMETERS=lcmduser.rc;OBJECTID="objid";STARTUPDIR="Directory";"
if SysCreateObject(type, title, folder, params, "update") then
   say "User Menu Definition Object successfully created."
else do
   say "Failed on create the User Menu Definition Object!"
   call end
end

/*
 * Create or update the LC program object.
 */

type="WPProgram"
title="Larsen Commander"
objid="<LarsenCommanderProg>"
folder="<LarsenCommanderFolder>"
params="PROGTYPE=PM;EXENAME="Directory"\lcmd.exe;OBJECTID="objid";STARTUPDIR="Directory";ICONFILE="Directory"\lcmd.ico;"
if SysCreateObject(type, title, folder, params, "update") then
   say "Larsen Commander Program Object successfully created."
else do
   say "Failed on create the Larsen Commander Program Object!"
   call end
end

end:
exit 0

