{}
{                                                       }
{      Virtual Pascal Runtime Library.  Version 1.0.    }
{      DosGetMessage and DosQueryMessageCP support.     }
{      }
{      Copyright (C) 1995 fPrint UK Ltd                 }
{                                                       }
{}

{ I found no references to the following in the documentation.          }
{ The only source of information is OS2386.LIB import library file      }
{ supplied with IBM C/C++ Developer toolkit for OS/2.                   }
{ DosGetMessage can be found in the msgseg32 object module,             }
{ DosQueryMessageCP in qryseg32.                                        }

{$OrgName+,Cdecl+,SmartLink-,AlignCode+,S-}

unit MsgSeg32;

interface

type
  ULong  = Longint;
  ApiRet = Longint;
  PPChar = ^PChar;

function DosGetMessage(Table: PPChar; cTable: ULong; Buf: PChar; cbBuf: ULong;
  MsgNumber: ULong; FileName: PChar; var cbMsg: ULong): ApiRet;
function DosQueryMessageCP(pb: PChar; cb: ULong; FileName: PChar; var Buf: ULong): ApiRet;

implementation

procedure MagicEndSignature; forward;
function DosIQueryMessageCP(pb: PChar; cb: ULong; FileName: PChar; var Buf: ULong; Signature: Pointer): ApiRet; external;
function DosTrueGetMessage(Signature: Pointer; var Table: PChar; cTable: ULong; Buf: PChar; cbBuf: ULong;
  MsgNumber: ULong; FileName: PChar; var cbMsg: ULong): ApiRet; external;

{ Apparently some kind of signature used to mark the start of _MSGSEG32 segment }

procedure MagicHeaderSignature; assembler; {$USES None} {$Frame-}
asm
                db      0FFh, 'MSGSEG32', 0
                dd      8001h, OFFSET MagicEndSignature
end;

{ DosGetMessage is declared in the OS2BASE unit, however actual name of OS/2  }
{ API function is DosTrueGetMessage. It requires additional first parameter,  }
{ pointing to the above magic header. The following procedure pops out return }
{ address, pushes extra parameter and pushes return address back to stack.    }

function DosGetMessage; assembler; {$USES None} {$Frame-}
asm
                pop     eax
                push    OFFSET MagicHeaderSignature
                push    eax
                jmp     DosTrueGetMessage
end;

{ DosQueryMessageCP is declared in the OS2BASE unit, however actual name of   }
{ OS/2 API function is DosIQueryMessageCP. It requires additional last        }
{ parameter, pointing to the above magic signature.                           }

function DosQueryMessageCP(pb: PChar; cb: ULong; FileName: PChar; var Buf: ULong): ApiRet;
begin
  DosQueryMessageCP := DosIQueryMessageCP(pb, cb, FileName, Buf, @MagicEndSignature);
end;

{ Apparently some kind of signature used to mark the end of _MSGSEG32 segment }

procedure MagicEndSignature; assembler; {$USES None} {$Frame-}
asm
                dd      0FFFF0000h
end;

end.
