# include <stdio.h>
# include <sys/types.h>

# ifndef lint
static char *rcs_id =
	"@(#) $Header: mp_glob.c,v 2.7 89/08/09 11:44:01 mark Exp $";
# endif

# include "mp_head.h"

/*
 * mpage:	a program to reduce pages of print so that several pages
 * 	  	of output appear on one printed page.
 *
 * Written by:
 *   ...!uunet!\                       Mark Hahn, Sr Systems Engineer
 *              >pyrdc!mark            Pyramid Technology Corporation
 * ...!pyramid!/                       Vienna, Va    (703)848-2050
 *
 *
 * Copyright (c) 1988 Mark P. Hahn, Herndon, Virginia
 *  
 *     Permission is granted to anyone to make or distribute verbatim
 *     copies of this document as received, in any medium, provided
 *     that this copyright notice notice is preserved, and that the
 *     distributor grants the recipient permission for further
 *     redistribution as permitted by this notice.
 *
 */

/* $Log:	mp_glob.c,v $
 * Revision 2.7  89/08/09  11:44:01  mark
 * change the defaults so that outlines are normally printed
 * 
 * Revision 2.6  89/05/25  10:42:37  mark
 * changes to print a page count on stderr after the print job is queued.
 * 
 * Revision 2.5  89/05/25  09:50:29  mark
 * turned off all debugging.
 * 
 * Revision 2.4  89/05/25  08:58:21  mark
 * rearranged the rcs header keywords for better readability.
 * 
 * Revision 2.3  89/05/22  14:40:49  mark
 * Fixed the type-o in the rcs identification string
 * 
 * Revision 2.2  89/05/22  14:37:51  mark
 * Added rcs identification usable with the "what" program
 * 
 * Revision 2.1  89/05/22  14:31:18  mark
 * New Major Revision
 * 
 * Revision 1.1  89/05/22  14:21:16  mark
 * Initial revision
 *  */

/*
 * to turn on debugging, define the preprocessor macro DEBUG and set
 * the variable Debug_flag to the sum of the sections to debug.
 */
# ifdef DEBUG
int Debug_flag = DB_PSMPAGE;
# endif DEBUG

/*
 * some basic PS parameters
 */
int ps_width = 612;	/* number of points in the X direction (8.5 inches) */
int ps_height = 792;	/* number of points in the Y direction (11 inches) */

/*
 * outlines for various page orientations and number of output pages to
 * put on printed pages
 */
int outline_1();
int outline_2();
int outline_4();
int outline_8();

/*
 * the structures describe where to put the reduced pages of output on the
 * printed page.
 */
/* base point for one page, normal aspect */
struct pagepoints one_normal[] = {
	{ xbase1, ybase1 },
	{  0,  0 }
};
/* base points for two pages, normal aspect */
struct pagepoints two_normal[] = {
	{ xbase1, ytop4 },	{ xbase1 , ytop2 },
	{  0,  0 }
};
/* base points for four pages, normal aspect, running reduced pages
 * read from left to right */
struct pagepoints lr_four_normal[] = {
  	{ xbase1, ybase3 },	{ xbase2, ybase3 },
	{ xbase1, ybase1 },	{ xbase2, ybase1 },
	{  0,  0 }
};
/* base points for four pages, normal aspect, running reduced pages
 * read from top to bottom (up/down) */
struct pagepoints ud_four_normal[] = {
  	{ xbase1, ybase3 },	{ xbase1, ybase1 },
	{ xbase2, ybase3 },	{ xbase2, ybase1 },
	{  0,  0 }
};
/* base points for eight pages, normal aspect, running reduced pages
 * read from left to right */
struct pagepoints lr_eight_normal[] = {
	{ xbase2, ytop4 },	{ xbase2, ytop3 },
	{ xbase2, ytop2 },	{ xbase2, ytop1 },
	{ xbase1, ytop4 },	{ xbase1, ytop3 },
	{ xbase1, ytop2 },	{ xbase1, ytop1 },
	{  0,  0 }
};
/* base points for eight pages, normal aspect, running reduced pages
 * read from top to bottom (up/down) */
struct pagepoints ud_eight_normal[] = {
	{ xbase2, ytop4 },	{ xbase1, ytop4 },
	{ xbase2, ytop3 },	{ xbase1, ytop3 },
	{ xbase2, ytop2 },	{ xbase1, ytop2 },
	{ xbase2, ytop1 },	{ xbase1, ytop1 },
	{  0,  0 }
};
/* base point for one page, in landscape */
struct pagepoints one_landscape[] = {
  	{ xbase1, ytop4 },
	{  0,  0 }
};
/* base points for two pages, in landscape */
struct pagepoints two_landscape[] = {
  	{ xbase1, ybase3 },	{ xbase1, ybase1 },
	{  0,  0 }
};
/* base points for four pages, in landscape, running reduced pages
 * read from left to right */
struct pagepoints lr_four_landscape[] = {
  	{ xbase2, ytop4 },	{ xbase2, ytop2 },
	{ xbase1, ytop4 },	{ xbase1, ytop2 },
	{  0,  0 }
};
/* base points for four pages, in landscape, running reduced pages
 * read from top to bottom (up/down) */
struct pagepoints ud_four_landscape[] = {
  	{ xbase2, ytop4 },	{ xbase1, ytop4 },
  	{ xbase2, ytop2 },	{ xbase1, ytop2 },
	{  0,  0 }
};
/* base points for eight pages, in landscape, running reduced pages
 * read from left to right */
struct pagepoints lr_eight_landscape[] = {
	{ xbase1, ybase4 },	{ xbase2, ybase4 },
	{ xbase1, ybase3 },	{ xbase2, ybase3 },
	{ xbase1, ybase2 },	{ xbase2, ybase2 },
	{ xbase1, ybase1 },	{ xbase2, ybase1 },
	{  0,  0 }
};
/* base points for eight pages, in landscape, running reduced pages
 * read from top to bottom (up/down) */
struct pagepoints ud_eight_landscape[] = {
	{ xbase1, ybase4 },	{ xbase1, ybase3 },
	{ xbase1, ybase2 },	{ xbase1, ybase1 },
	{ xbase2, ybase4 },	{ xbase2, ybase3 },
	{ xbase2, ybase2 },	{ xbase2, ybase1 },
	{  0,  0 }
};

/* list of sheets (printed page formats) for
 * left to right reading, in normal aspect */
struct sheet lr_normal[] = {
/* 0 */	80, 66, xwid1, yht1,    0, outline_1, one_normal,
/* 1 */	80, 66, yht2,  xwid1, -90, outline_2, two_normal,
/* 2 */	80, 66, xwid2, yht2,    0, outline_4, lr_four_normal,
/* 3 */	80, 66, yht4,  xwid2, -90, outline_8, lr_eight_normal,
};

/* list of sheets (printed page formats) for
 * top to bottom reading, in normal aspect */
struct sheet ud_normal[] = {
/* 0 */	80, 66, xwid1, yht1,    0, outline_1, one_normal,
/* 1 */	80, 66, yht2,  xwid1, -90, outline_2, two_normal,
/* 2 */	80, 66, xwid2, yht2,    0, outline_4, ud_four_normal,
/* 3 */	80, 66, yht4,  xwid2, -90, outline_8, ud_eight_normal,
};

/* list of sheets (printed page formats) for
 * left to right reading, in landscape */
struct sheet lr_landscape[] = {
/* 0 */	132, 52, yht1,  xwid1, -90, outline_1, one_landscape,
/* 1 */	132, 52, xwid1, yht2,    0, outline_2, two_landscape,
/* 2 */	132, 52, yht2,  xwid2, -90, outline_4, lr_four_landscape,
/* 3 */	132, 52, xwid2, yht4,    0, outline_8, lr_eight_landscape,
};

/* list of sheets (printed page formats) for
 * top to bottom reading, in landscape */
struct sheet ud_landscape[] = {
/* 0 */	132, 52, yht1,  xwid1, -90, outline_1, one_landscape,
/* 1 */	132, 52, xwid1, yht2,    0, outline_2, two_landscape,
/* 2 */	132, 52, yht2,  xwid2, -90, outline_4, ud_four_landscape,
/* 3 */	132, 52, xwid2, yht4,    0, outline_8, ud_eight_landscape,
};

/* array of sheet lists for left to right reading printed pages */
struct sheet *left_right[] = {
	lr_normal,
	lr_landscape
  };

/* arrays for top to bottom reading printed pages */
struct sheet *up_down[] = {
	ud_normal,
	ud_landscape
  };

/*
 * Variables for holding the chosen options,  The defaults are set here.
 * the sheetlist pointer is set to point to the array for either up/down
 * or left/right reading.  This array is index by sheetorder, and then
 * sheetindex.  sheetindex encodes the number of reduced pages per printed
 * page and indexes into the sheet list (0 = 1 page, 1 = two pages, 2 =
 * four pages, 3 = eight pages).
 */
struct sheet **sheetlist;/* array of sheet lists (up/down or left/right) */
int sheetaspect = NORMAL;/* either normal or landscape */
int sheetorder = UPDOWN;/* up/down or left/right flag */
int sheetindex = 2;	/* index to number of pages of output per printed */
int pg_sheetmargin = 20;/* non-printable border on sheet */
int pg_pagemargin = 4;  /* border for pages */
int fsize = 12;		/* font scale size */
int opt_pr = 0;		/* boolean, if true use pr(1) to format output */
int opt_lines = 0;	/* number of lines to fit on an reduced page */
int opt_width = 0;	/* number of columns to fit on an reduced page */
int opt_doheader = 0;	/* have a head for pr's -h option */
int opt_a4 = 0;		/* default to US paper */
int opt_outline = 1;	/* don't normally outline the pages */
int opt_verbose = 1;	/* by default, print a count of pages produced */
char opt_header[LINESIZE]; /* the header for pr's -h option */
char outcommand[LINESIZE]; /* the command which is the output filter */
# ifndef DEBUG
char printer[LINESIZE] = "PostScript";	/* the printer(argument to lpr -P??) */
# else
char printer[LINESIZE] = "";	/* the printer (argument to lpr -P??) */
# endif DEBUG
/*
 * various global information
 */
char MPAGE[] = "mpage";	/* program name */
int ps_pagenum = 0;	/* current page count */
char usage[] =		/* usage string */
"mpage [-aulnp1248] [-Llines] [-Wwidth] [-hheader] [-Pprinter] [files...]\n";

