/* SetPriority (SP) */
#define INCL_DOSPROCESS
#define INCL_NOPM
#include <os2.h>
#include <dos.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>

#define PATHLEN 120

static struct _pt
{
  char ch;
  USHORT usClass;
} pt[]=
{
  {'i', PRTYC_IDLETIME},
  {'n', PRTYC_NOCHANGE},
  {'r', PRTYC_REGULAR},
  {'f', PRTYC_FOREGROUNDSERVER},
  {'t', PRTYC_TIMECRITICAL},
  {0,   0}
};

char *prior[]={"no change in", "idle", "regular", "time critical", "foreground"};

int main(int argc, char *argv[])
{
  char args[255];
  PIDINFO pidUs;
  USHORT usClass;
  USHORT rc;
  SHORT sDelta;
  struct _pt *ppt;
  char **p;

  if (argc < 3)
  {
    printf("Usage:\n\n");

    printf("SP <class>[delta] <program> [args...]\n\n");

    printf("<class>:  n=no change, i=idle, r=regular, f=foreground, t=time critical\n");
    printf("[delta]:  Any number from -31 to 31\n");
    return 1;
  }

  DosGetPID(&pidUs);

  usClass=PRTYC_NOCHANGE;
  sDelta=0;

  *argv[1]=(char)tolower(*argv[1]);

  for (ppt=pt; ppt->ch; ppt++)
    if (ppt->ch==*argv[1])
    {
      usClass=ppt->usClass;
      break;
    }

  sDelta=atoi(argv[1] + !!islower(*argv[1]));

  if ((rc=DosSetPrty(PRTYS_PROCESSTREE, usClass, sDelta, pidUs.pid)) != 0)
    printf("DosSetPrty() rc=%u\n", rc);

  *args='\0';

  for (p=argv+2; *p; p++)
  {
    strcat(args, *p);
    strcat(args, " ");
  }

  if (args[strlen(args)-1]==' ')
    args[strlen(args)-1]='\0';

  printf("SP: running %s, %s priority, delta %d\n",
         argv[2], prior[usClass], sDelta);

  rc=system(args);

  if (rc != 0)
    printf("SP: system() rc=%u\n", rc);

  return rc;
}
