{ PCI Classes }

type pci_record =
  record
    class       : word;
    name        : string[32];
  end;

const
   pci_class_names      : array [0..$11] of string[32] = (

   'Unknown',
   'Storage',
   'Network',
   'Display',
   'Multimedia',
   'Memory',
   'Bridge',
   'Simple Communication',
   'System',
   'Input',
   'Docking',
   'Processor',
   'Serial',
   'Wireless',
   'Intelligent I/O',
   'Satellite Communication',
   'En/Decription',
   'Data Aquisition & Signal Processing'

   );


   high_class_name	: word = $11;	{ update this to same as line above }
   high_class_array	: word = 90;	{ update this to same as line below }

   pci_class_array : array [0..90] of pci_record = (

   (class:$0000;name:'Undefined'),
   (class:$0001;name:'VGA'),

   (class:$0100;name:'SCSI'),
   (class:$0101;name:'IDE'),
   (class:$0102;name:'Floppy'),
   (class:$0103;name:'IPI'),
   (class:$0104;name:'RAID'),
   (class:$0180;name:'Other'),

   (class:$0200;name:'Ethernet'),
   (class:$0201;name:'Token Ring'),
   (class:$0202;name:'FDDI'),
   (class:$0203;name:'ATM'),
   (class:$0204;name:'ISDN'),
   (class:$0280;name:'Other'),

   (class:$0300;name:'VGA'),
   (class:$0301;name:'XGA'),
   (class:$0302;name:'3D'),
   (class:$0380;name:'Other'),

   (class:$0400;name:'Video'),
   (class:$0401;name:'Audio'),
   (class:$0402;name:'Telephony'),
   (class:$0480;name:'Other'),

   (class:$0500;name:'RAM'),
   (class:$0501;name:'Flash'),
   (class:$0580;name:'Other'),

   (class:$0600;name:'PCI-to-HOST'),
   (class:$0601;name:'PCI-to-ISA'),
   (class:$0602;name:'PCI-to-EISA'),
   (class:$0603;name:'PCI-to-MCA'),
   (class:$0604;name:'PCI-to-PCI'),
   (class:$0605;name:'PCI-to-PCMCIA'),
   (class:$0606;name:'PCI-to-NuBUS'),
   (class:$0607;name:'PCI-to-Cardbus'),
   (class:$0608;name:'PCI-to-RACEway'),
   (class:$0609;name:'PCI-to-PCI'),
   (class:$060A;name:'PCI-to-InfiBand'),
   (class:$0680;name:'PCI-to-Other'),

   (class:$0700;name:'Serial'),
   (class:$0701;name:'Parallel'),
   (class:$0702;name:'Multiport Serial'),
   (class:$0703;name:'Hayes Compatible Modem'),
   (class:$0780;name:'Other'),

   (class:$0800;name:'PIC'),
   (class:$0801;name:'DMA'),
   (class:$0802;name:'Timer'),
   (class:$0803;name:'RTC'),
   (class:$0803;name:'Hot-Plug'),
   (class:$0880;name:'Other'),

   (class:$0900;name:'Keyboard'),
   (class:$0901;name:'Pen'),
   (class:$0902;name:'Mouse'),
   (class:$0903;name:'Scanner'),
   (class:$0904;name:'Game Port'),
   (class:$0980;name:'Other'),

   (class:$0a00;name:'Generic'),
   (class:$0a80;name:'Other'),

   (class:$0b00;name:'386'),
   (class:$0b01;name:'486'),
   (class:$0b02;name:'Pentium'),
   (class:$0b03;name:'PentiumPro'),
   (class:$0b10;name:'DEC Alpha'),
   (class:$0b20;name:'PowerPC'),
   (class:$0b30;name:'MIPS'),
   (class:$0b40;name:'Coprocessor'),
   (class:$0b80;name:'Other'),

   (class:$0c00;name:'FireWire'),
   (class:$0c01;name:'Access.bus'),
   (class:$0c02;name:'SSA'),
   (class:$0c03;name:'USB'),
   (class:$0c04;name:'Fiber'),
   (class:$0c05;name:'SMBus Controller'),
   (class:$0c06;name:'InfiniBand'),
   (class:$0C80;name:'Other'),

   (class:$0d00;name:'iRDA'),
   (class:$0d01;name:'Consumer IR'),
   (class:$0d10;name:'RF'),
   (class:$0d80;name:'Other'),

   (class:$0e00;name:'I2O'),
   (class:$0e80;name:'Other'),

   (class:$0f01;name:'TV'),
   (class:$0f02;name:'Audio'),
   (class:$0f03;name:'Voice'),
   (class:$0f04;name:'Data'),
   (class:$0f80;name:'Other'),

   (class:$1000;name:'Network'),
   (class:$1010;name:'Entertainment'),
   (class:$1080;name:'Other'),

   (class:$1100;name:'DPIO Modules'),
   (class:$1101;name:'Performance Counters'),
   (class:$1110;name:'Comm Sync, Time+Frequency Measurement'),
   (class:$1180;name:'Other')

   );


