/*
 * StHealth.H
 * Autor:               Stefan Milcke
 * Erstellt am:         14.12.1998
 * Letzte Aenderung am: 05.11.1999
 *
*/

#ifndef STHEALTH_H_INCLUDED
#define STHEALTH_H_INCLUDED

/* defines for OS/2 include */

/* Standard headers */

/* UI Class Library headers */

/* Application headers */

/* OS/2 Headers */
#include <os2.h>

#define STHEALTH_VERSION         3
#define STHEALTH_NOT_PRESENT_ERROR  (-255)
#define STHELATH_CORRECTION_QUERY   (-65535)

#pragma library("StHealth.LIB")

extern unsigned long StHealthBuildLevel;

#ifdef __cplusplus
extern "C" {
#endif
/* version */
int StHealthDLLVersion(void);

/* presence check */
BOOL StHealthIsPresent(void);

/* chip type string */
char *StHealthChipType(char *buffer,unsigned long bufferLen);

/* chip id */
int StHealthChipId(void);

/* temperatures */
float StHealthTemperature1(void);
float StHealthTemperature2(void);
float StHealthTemperature3(void);

/* fan speeds */
float StHealthFan1(void);
float StHealthFan2(void);
float StHealthFan3(void);

/* voltage querying */
float StHealthCoreVoltage1(void);
float StHealthCoreVoltage2(void);
float StHealthVoltage33(void);
float StHealthVoltage5(void);
float StHealthVoltage12(void);
float StHealthVoltage12n(void);
float StHealthVoltage5n(void);

/* fan divisors */
int StHealthFanDivisor1(void);
int StHealthFanDivisor2(void);
int StHealthFanDivisor3(void);

/* misc functions */
int StHealthVendorId(void);

/* Corrections */
/* If the parameter cor is equal to STHELATH_CORRECTION_QUERY no value is set */
/* Only the current correction value is returned */
/* Note ! */
/* All correction values are stored in StHealth.INI located in the */
/* OS2 directory on the boot drive */

float StHealthSetTemperature1Correction(float cor);
float StHealthSetTemperature2Correction(float cor);
float StHealthSetTemperature3Correction(float cor);
float StHealthSetFan1Correction(float cor);
float StHealthSetFan2Correction(float cor);
float StHealthSetFan3Correction(float cor);
float StHealthSetCoreVoltage1Correction(float cor);
float StHealthSetCoreVoltage2Correction(float cor);
float StHealthSetVoltage33Correction(float cor);
float StHealthSetVoltage5Correction(float cor);
float StHealthSetVoltage12Correction(float cor);
float StHealthSetVoltage12nCorrection(float cor);
float StHealthSetVoltage5nCorrection(float cor);

/* Some helper functions */
/* Note: reserved must be set to zero !! */
int StHealthPowerOff(unsigned long reserved);

#ifdef __cplusplus
};
#endif

#endif /* STHEALTH_H_INCLUDED */
