/* INSTALL.CMD */
/* This program places a UPSMonitor folder on the
   desktop and fills it with the UPSMONS
   program objects.
*/

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

SAY 'Installing UPS Monitor...'
SAY ''

objerror = 0
folder.name = 'UPSMonitor'

pwd = Directory()
execs.0 = 2
execs.1.spec = pwd || '\*.exe'
execs.1._title = ''
execs.2.spec = pwd || '\*.txt'
execs.2._title = '0A'x || 'UPSMon'


folder.objId = Translate(folder.name, '__', '^ ')
folder.title  = Translate(folder.name, '0A'x, '^')

rc = SysCreateObject('WPFolder', folder.title,,
    '<WP_DESKTOP>',,
    'OBJECTID=<' || folder.objId || '>;' ||,
    'ICONVIEW=NORMAL;ICONFONT=8.Helv;',,
    'ReplaceIfExists')

IF rc = 0 THEN
  DO
    SAY ''
    SAY 'Could not create folder' folder.name
    EXIT
  END

DO i = 1 TO execs.0
  CALL SysFileTree execs.i.spec, 'files.', 'FO'
  DO j = 1 TO files.0
    title = Translate(Reverse(FileSpec('Name', files.j)))
    PARSE VAR title 5 title
    title = Reverse(title) || execs.i._title
    IF title = 'UPSMONB' then
      title = 'UPSMon B^(for Back-UPS only)'
    IF title = 'UPSMONS' then
      title = 'UPSMonitor'
    IF title = 'README' then
      title = 'UPSMon^Readme'
    parm = ''
    IF POS('README.TXT', Translate(files.j)) > 0 | POS('BMTORDER.TXT', Translate(files.j)) > 0 then
     DO
       parm = 'STARTUPDIR=' || pwd || ';PARAMETERS=' || files.j || ';'
       files.j = 'E.EXE'
     END
    ELSE
       parm = 'STARTUPDIR=' || pwd || ';'

    rc = SysCreateObject('WPProgram', title,,
	'<'folder.objId'>',,
	'EXENAME=' || files.j || ';' ||,
        parm,,
	'ReplaceIfExists')
    IF rc = 0 THEN
      DO
        SAY 'Could not create program object for' files.j
        objerror = objerror + 1
      END
  END
END

SAY ''
IF objerror = 0 then
  DO
    SAY 'UPSMonitor folder and program objects successfully created.'
    SAY ''
    SAY '       ======= I M P O R T A N T ======='
    SAY ''
    SAY 'Please read the README.TXT file first.'
    SAY ''
    SAY 'To read README.TXT, open UPSMonitor folder'
    SAY 'and double-click on README UPSMon object.'
    SAY ''
    SAY 'To start UPS Monitor, double-click on the UPS Monitor icon.'
    SAY 'Please read the online Help to learn how to use UPS Monitor.'
  END
ELSE
  DO
    SAY 'Could not install one or more UPSMon objects.'
    SAY ''
    SAY 'Make sure all UPSMon files are present'
    SAY 'and run INSTALL again.'
  END

EXIT

