/*
 * (Install.cmd) Installs the PMX server updates from disk or diskette.
 * This version installs incremental fixes above PMX version 2.0.4.
 * This must be run from the disk or diskette e.g. "a:install".
 * This version checks that XFILES environment variable has been
 * set up properly and both TCPBASE and TCPPMX have already been installed.
 */
SYSLEVELVAL= "SYSLEVEL                       %       UN87312 UN68122  X-WINDOWS for TCP/IP on OS/2                                                   562208600                   "
XFILES = envvarcheck('XFILES')
ETC = envvarcheck('ETC')
/*
    CID = 0 means not CID install, and we can prompt the user for answers.
    CID = 1 means the user has asked for no prompting.
*/
CID = 0
doi = 0
doe = 0
doj = 0
dok = 0
arg arglist
do forever
    parse var arglist nextarg arglist
    select
    when nextarg = '-INSTALLFIXES' then do
        doi = 1
        CID = 1
        end
    when nextarg = '-DELETESNF' then do
        doe = 1
        CID = 1
        end
    when nextarg = '-DELETEJAPANESE' then do
        doj = 1
        CID = 1
        end
    when nextarg = '-DELETEKOREAN' then do
        dok = 1
        CID = 1
        end
    when nextarg = "" then
        leave
    otherwise
        say "If 'install' has command line arguments, it is assumed that the user"
        say "does not want to be prompted for replies (to allow installing over"
        say "a network, for example).  The install procedure then allows the"
        say "following command line options:"
        say "-installfixes    Install PMX fixes, backing up certain files such as"
        say "                 fonts.ali or xinit.cmd"
        say "-deletesnf       Delete old *.snf font files in the \tcpip\x11\misc"
        say "                 and \tcpip\x11\75dpi directories."
        say "-deletejapanese  Delete certain Japanese fonts, to save space."
        say "-deletekorean    Delete certain Korean fonts, to save space."
        exit 1
    end /* select */
end

/*
    Do not do the following call. there are shared environments where this
    makes for problems.  PMX itself should (does?) check for it when it runs.
        call envvarcheck 'HOSTNAME'
*/
X11PATH=filespec("path",XFILES)
if substr(X11PATH, length(X11PATH), 1) = '\' then
    X11PATH = substr(X11PATH, 1, length(X11PATH) - 1)
X11BASE=filespec("drive",XFILES)||X11PATH
/*
    Assume X11BASE and BASE are the same for now. Eventually we may want to
    allow them to be different.  I.e. look down the PATH variable for
    the BIN files, the LIBPATH for the DLLs, and so on.
    Better yet, prompt the user for an optional change and then check to find
    the files that we should update.
*/
BASE = X11BASE
call dircheck XFILES
call dircheck BASE
call dircheck BASE'\DLL'
call dircheck BASE'\HELP'
call dircheck X11BASE'\X11\MISC'

/* This CD is done because direxist leaves the drive in the
 * arg dir, if it exists.  This then causes RD to fail, as OS/2
 * thinks a process is using the directory.                      */
'CD' X11BASE'\X11'
call dircheck X11BASE'\X11\DEFAULTS'
call pmx203check
CMDLOC = getinstalldir()
diskette = getdiskettedrive(CMDLOC)
if CID then do
    /*
        Just do the things that are selected by the user on the command line,
        after checking that they can indeed be done.
    */
    if doi then do
        call installfiles
        end
    if doe then do
        snfcnt = anyfiles(X11BASE'\x11\misc\*.snf')
        snfcnt = snfcnt + anyfiles(X11BASE'\x11\75dpi\*.snf')
        if ( snfcnt > 0) then
            call erasesnf
        end
    if doj then do
        if fileexists(X11BASE'\x11\misc\jiskan16.pcf') + ,
                fileexists(X11BASE'\x11\misc\jiskan24.pcf') + ,
                fileexists(X11BASE'\x11\misc\k14.pcf') > 0 then
            call erasejapanese
        end
    if dok then do
        if fileexists(X11BASE'\x11\misc\hanglg16.pcf') + ,
                fileexists(X11BASE'\x11\misc\hanglm16.pcf') + ,
                fileexists(X11BASE'\x11\misc\hanglm24.pcf') > 0 then
            call erasekorean
        end
    end /* CID */
else do   /* not CID install */
    /*
        Tell the user what options remain, and read an entered reply.
    */
    doi = 1
    snfcnt = anyfiles(X11BASE'\x11\misc\*.snf')
    snfcnt = snfcnt + anyfiles(X11BASE'\x11\75dpi\*.snf')
    if ( snfcnt > 0) then
        doe = 1
    else
        doe = 0
    if fileexists(X11BASE'\x11\misc\jiskan16.pcf') + ,
            fileexists(X11BASE'\x11\misc\jiskan24.pcf') + ,
            fileexists(X11BASE'\x11\misc\k14.pcf') > 0 then
        doj = 1
    else
        doj = 0
    if fileexists(X11BASE'\x11\misc\hanglg16.pcf') + ,
            fileexists(X11BASE'\x11\misc\hanglm16.pcf') + ,
            fileexists(X11BASE'\x11\misc\hanglm24.pcf') > 0 then
        dok = 1
    else
        dok = 0
    if fileexists(CMDLOC'readme.1st') > 0 & ,
            fileexists(CMDLOC'pmxfix2x.exe') > 0 then
        dod = 1
    else
        dod = 0
    dor = 1
    'cls'
    say ' '
    say ' '
    call beep 700,200
    do until doi + doe + doj + dok + dor = 0
        say "The following options are available. Enter the letter to the left"
        say "in order to select the related option."
        if doi then do
            say ""
            say "i   Install program fixes."
            say "    (You will need to reboot after installation, before you"
            say "    can use PMX.)"
            end
        if dod then do
            say ""
            say "d   Create installation diskette for installing PMX update on"
            say "    another computer. (One blank formatted diskette is needed.)"
            if doi then
                say "   (You can use the 'i' option to install on this computer.)"
            end
        if doe then do
            say ""
            say "e   Erase old PMX 1.2.1 snf fonts (not used by PMX 2.0)."
            end
        if doj then do
            say ""
            say "j   Erase Japanese fonts to save space (about 1.5 mb)."
            say "    Fonts jiskan16.pcf, jiskan24.pcf, and k14.pcf."
            end
        if dok then do
            say ""
            say "k   Erase Korean fonts to save space (about 1.9 mb)."
            say "    Fonts hanglg16.pcf, hanglm16.pcf, and hanglm24.pcf."
            end
        say ""
        say "r   Read the README.1ST file."
        say ""
        say "x   Exit from install."
        say ""
        pull reply
        select
            when doi & reply = 'I' then do
                call installfiles
                'cls'
                doi = 0
                end
            when dod & reply = 'D' then do
                call makediskettes
                'cls'
                end
            when doe & reply = 'E' then do
                call erasesnf
                'cls'
                doe = 0
                end
            when doj & reply = 'J' then do
                call erasejapanese
                'cls'
                doj = 0
                end
            when dok & reply = 'K' then do
                call erasekorean
                'cls'
                dok = 0
                end
            when reply = 'R' then do
                call browsefile 'readme.1st'
                'cls'
                dor = 0
                end
            when reply = 'X' then do
                if doi then do
                    call beep 440,250
                    call beep 524,200
                    say ""
                    say "You did not install any fixes."
                    say "Enter Y if you really want to exit."
                    pull reply
                    if reply = 'Y' then exit 1
                    'cls'
                    iterate
                    end
                else do
                    call beep 440,250
                    call beep 524,200
                    'cls'
                    say ""
                    say ""
                    say "Before you can use PMX, you must shutdown and reboot"
                    say "your system!!!"
                    say ""
                    end
                if dor then do
                    call beep 440,250
                    call beep 524,200
                    say ""
                    say "You have not selected the README.1ST option yet."
                    say "Enter Y if you really want to exit."
                    pull reply
                    if reply = 'Y' then exit 1
                    'cls'
                    iterate
                    end
                exit 0
                end
            otherwise
                'cls'
                say ' '
                say ' '
                call beep 524,200
                call beep 440,250
                say "'"reply"' is not an available option. Please try again."
                say ""
        end /* select */
    end /* forever */
end  /* not CID install */
'cls'
say ""
say ""
call beep 440,250
call beep 524,200
if doi = 0 then do
    say "Remember, you will need to reboot after installation, before you"
    say "can use PMX."
    end
say ""
say "Install is ended."
say ""
exit 0

installfiles: procedure expose BASE X11BASE CMDLOC CID diskette X11PATH
/* do backups before erases! That way, the user can safely do ctrl-c */
/****
call backupfile BASE'\BIN XINIT.CMD' 'XINITBAK.CMD'
****/
/* if we cannot erase, PMX is probably running */
call runcheckanderase BASE'\BIN\PMX.EXE'
call runcheckanderase BASE'\DLL\PMXRES.DLL'
/* now updating the CSD level info */
say ""
say "Now loading from the update files."
say ""
CMDLOC'pmxfix2x -d -o' BASE
/**/
say ""
say "Loading from the update files is complete."
say ""
call beep 700,200
if \ CID then
    'pause'
return

bailout: procedure expose CID
arg arglist
parse var arglist operation dir
/* This proc is called to report a failure of 'operation' */
/* performed with 'dir' as its parameter. */
/* Write the message, if not CID, pause.  Then exit */
say operation "FAILURE on directory" dir
say "Ensure no other process is using the directory."
say "Install is ABORTING."
if \ CID then
   pause
exit 1


buildfontsdir: procedure expose X11BASE
arg dir
/* build the fonts.dir in the x11\dir directory. */
/* save the user's current directory */
currentdir = directory()
/* make dir font directory the current one */
call directory X11BASE'\X11\'dir
say "Making a new fonts.dir file in "X11BASE"\X11\"dir "directory..."
X11BASE'\bin\mkfontdr'
/* restore the user's current directory */
call directory(currentdir)
return

dircheck: procedure
arg dir
curdir = directory()
newdir = directory(dir)
call directory(curdir)
if newdir \= '' then
    do
    return newdir
    end
else
    do
    call beep 524,200
    call beep 440,250
    say ""
    say "Directory '"dir"' could not be found even though the XFILES"
    say "environment variable is defined as '"XFILES"'!"
    say "The directory was supposed to be created when the TCP/IP 2.0"
    say "base and X Window System 2.0 option were installed."
    say "Installation is terminated!"
    exit 1
    end

direxist: procedure
arg dir
/* return fileexists(arg) */
curdir = directory()
newdir = directory(dir)
call directory(curdir)
return newdir \= ''

getinstalldir: procedure
parse source system calltype CMDLOC
cmddir = filespec("drive",CMDLOC)||filespec("path",CMDLOC)
return cmddir

runcheckanderase: procedure
arg file
progname = STREAM(file, 'C', 'QUERY EXISTS')
if progname \= '' then do
    'ERASE' progname
    if STREAM(file, 'C', 'QUERY EXISTS') \= '' then do
        call beep 524,200
        call beep 440,250
        say ""
        say "The file '"file"' could not be erased."
        say "You probably have not stopped the PMX server."
        say "Please do so before you install this update."
        say ""
        exit 1
        end
    end
return

fileexists: procedure
arg file
progname = STREAM(file, 'C', 'QUERY EXISTS')
return progname \= ''

/* typical call: call backupfile BASE'\BIN  XINIT.CMD' 'XINITBAK.CMD' */
/*                               dirpath    oldfilename firstbackname */
backupfile: procedure expose CID
arg dirpath oldfilename firstbackname
oldfile = dirpath'\'oldfilename
backname = firstbackname
if CID then do
    oldloc = filespec("drive",oldfile)||filespec("path", oldfile)
    backfile = oldloc||backname
    say "A new version of '"oldfile"' will be loaded. For backup,"
    say "the old version will be copied to '"backname"'."
    'copy' oldfile dirpath'\'backname
    return
    end
if STREAM(oldfile, "C", "QUERY EXISTS") \= '' then do
    oldloc = filespec("drive",oldfile)||filespec("path", oldfile)
    do forever
        backfile = oldloc||backname
        if STREAM(backfile, "C", "QUERY EXISTS") \= '' then do
            'cls'
            say ' '
            say ' '
            say "A new version of '"oldfile"' will be loaded. For backup,"
            say "the old version would have been renamed to '"backname"'."
            say "However, the backup file '"backfile"' already exists."
            say ' '
            backname = getnewbackname(oldfile backfile)
            if backname = '' then
                return  /* no backup wanted, old file will be replaced */
            if backname = '=' then do
                'copy' oldfile dirpath'\'firstbackname
                return
                end
            iterate
            end /* if */
        else
            do
            'cls'
            say ' '
            say ' '
            say "A new version of '"oldfile"' will be loaded. For backup,"
            say "the old version will be renamed to '"backname"'."
            'rename' oldfile backname
            if STREAM(backfile, "C", "QUERY EXISTS") \= '' then do
                say ''
                call beep 700,200
                'pause'
                leave
                end
            call beep 524,200
            call beep 440,250
            say "Error! Renaming '"oldfile"' to '"backname"' did not work!"
            say "RC="rc 'from the rename command.'
            'pause'
            /* exit 1 */
            end /* else */
        end /* do forever */
    end /* if */
return

/* typical call
    backname = getnewbackname(oldfile backfile)
 */
getnewbackname: procedure
arg oldfile backfile junk
do forever
    say "Please enter a new name to rename '"oldfile"',"
    say " or else enter  =  to use '"backfile"' for backup anyway,"
    say " or else press  Enter  without any name, if you do not want a backup;"
    say " or else press  ctrl-c  and then  Enter  if you want to end the update."
    call beep 700,200
    pull enteredfilename
    if newfilename = '=' | newfilename = ' ' then
        return newfilename
    newfilename = filespec("name", enteredfilename)
    if newfilename = enteredfilename then
        return newfilename
    say "Try again, please. You should have entered a simple filename."
    say ''
    end /* do forever */

envvarcheck: procedure
arg envvar
ENV = 'OS2ENVIRONMENT'
retvar = VALUE(envvar,,ENV)
if retvar = '' then
    do
    call beep 524,200
    call beep 440,250
    say ""
    say "WARNING!"
    say "You do NOT have the environment variable" envvar "defined!"
    say "You already should have installed the OS/2 TCP/IP 2.0 base"
    say "or its equivalent, and you already should have installed"
    say "the X Window System option.  This update package only provides"
    say "changes and additions to the already installed product."
    say "Installation will not continue!"
    say ""
    exit 1
    end
return retvar

erasekorean: procedure expose X11BASE CID
'erase' X11BASE'\x11\misc\hanglg16.pcf'
'erase' X11BASE'\x11\misc\hanglm16.pcf'
'erase' X11BASE'\x11\misc\hanglm24.pcf'
call buildfontsdir 'misc'
call beep 700,200
if \ CID then
    'pause'
return

erasejapanese: procedure expose X11BASE CID
'erase' X11BASE'\x11\misc\jiskan16.pcf'
'erase' X11BASE'\x11\misc\jiskan24.pcf'
'erase' X11BASE'\x11\misc\k14.pcf'
call buildfontsdir 'misc'
call beep 700,200
if \ CID then
    'pause'
return

erasesnf: procedure expose X11BASE CID
'erase' X11BASE'\x11\misc\*.snf'
'erase' X11BASE'\x11\75dpi\*.snf'
call beep 700,200
if \ CID then
    'pause'
return

browsefile: procedure expose CMDLOC diskette
arg fn
do while \ fileexists(CMDLOC||fn)
    if diskette = '' then do
        'cls'
        call beep 524,200
        call beep 440,250
        say ""
        say ""
        say "WARNING!!! The README.1ST file is missing!!!"
        say ""
        return
        end
    'cls'
    call beep 524,200
    call beep 440,250
    say ""
    say ""
    say "Put the first diskette, with the README.1ST file in it, in" diskette
    'pause'
end /* while */
'e' CMDLOC||fn
return

/* test if we get return codes for file patterns: anyfiles('*.snf') */
anyfiles: procedure
arg filepat
'dir' filepat '/b 1>nul 2>&1'
return rc = 0

pmx203check: procedure expose BASE SYSLEVELVAL
if fileexists(BASE'\syslevel.pmx') then do
    newsyslevel = linein(BASE'\syslevel.pmx')
    end
if fileexists(BASE'\help\pmx.hlp') then do
    if fileexists(BASE'\doc\pmx.inf') then DO
        if newsyslevel = SYSLEVELVAL then
            return
        END
    end
call beep 524,200
call beep 440,250
say ""
say "The install program could not find files that should be there if"
say "PMX 2.0.4 had been installed.  You must first install PMX 2.0, and then"
say "install fixes up to CSD UN87312 (PMX version 2.0.4)."
say "Another possible reason is that you moved or erased the"
say BASE"\help\pmx.hlp file or the" BASE"\doc\pmx.inf file."
say "Installation is terminated!"
exit 1


getdiskettedrive: procedure
parse upper arg commandloc
maybedrive = substr(commandloc, 1, 2)
select
when maybedrive = 'A:' then
    return maybedrive
when maybedrive = 'B:' then
    return maybedrive
otherwise
    return ''
end


makediskettes: procedure expose CMDLOC
'cls'
say ' '
say ' '
say "Place a blank formatted diskette in a diskette drive and"
say "enter the diskette drive letter, or enter QUIT if you do not want"
say "to make an installable diskette."
pull diskette
parse upper var diskette diskette ':' junk
if diskette = 'QUIT' then
    return
if length(diskette) > 1 then do
    call beep 524,200
    call beep 440,250
    say ""
    say "'"diskette"' is too long for a diskette name."
    say "No installable diskette was made!"
    'pause'
    return
    end
if \ datatype(diskette, 'U') then do
    call beep 524,200
    call beep 440,250
    say ""
    say "'"diskette"' is not a letter."
    say "No installable diskette was made!"
    'pause'
    return
    end
'copy' CMDLOC'install.cmd' diskette':'
'copy' CMDLOC'readme.1st' diskette':'
'copy' CMDLOC'pmxfix2x.exe' diskette':'
'copy' CMDLOC'pmxxt.exe' diskette':'
'copy' CMDLOC'PN83992.DOC' diskette':'
return
