import java.io.File;
import java.io.FileOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.RandomAccessFile;
import java.io.IOException;
import java.net.Socket;
import java.net.URL;
import java.util.StringTokenizer;

public class downloadfactory
{
 public final static int DOWNLOAD_OK=0;
 public final static int DOWNLOAD_ERR=1;
 public final static int DOWNLOAD_FATAL=2;
 public final static int DOWNLOAD_REDIRECT=3;
 public final static int DOWNLOAD_BUSY=4;
 public final static int DOWNLOAD_RESUME=5;

 public final static int RESUME_UNKNOWN=0;
 public final static int RESUME_NOCACHE=1;
 public final static int RESUME_DIRECT=2;
 public final static int RESUME_NONE=3;

 public static String checkreferer[]; /* url with special referer checks */
 public static String sendreferer[];  /* referer to send */

 public static final int downloadFactory(String URL,String localname,qfile qf) 
    throws java.net.MalformedURLException, java.io.IOException
 {
  int skipbytes=(int)new File(dmachine.tmp_dir,localname).length();
  if(skipbytes>0) System.out.println("[INFO] Continuing download of "+localname+" on pos="+skipbytes);
  URL url=new URL(URL);
  Socket s=null;
  // posleme request HTTP-proxy serveru
  if(url.getProtocol().equalsIgnoreCase("ftp"))
    if(dmachine.ftp_proxydefined)
      {
        boolean nocache=false;
        if(skipbytes>0)
	  {
	   if(dmachine.ftp_resume==RESUME_NOCACHE) nocache=true;
	   //TODO: Direct support for FTP is not here (yet)
	  }
        s=sendHTTPRequest(dmachine.ftp_proxyserver,dmachine.ftp_proxyport,URL,skipbytes,url.getHost(),nocache);  
      }
        else
      return DOWNLOAD_FATAL; // no internal FTP support
   
  else  /* HTTP direct */
   if(!dmachine.http_proxydefined && url.getProtocol().equalsIgnoreCase("http"))
        s=sendHTTPRequest(java.net.InetAddress.getByName(url.getHost()),url.getPort()>0? url.getPort():80, url.getFile(),skipbytes,url.getHost(),false);
    else
  {
    if(!dmachine.http_proxydefined) return DOWNLOAD_FATAL; // no luck here
    //other stuff via http_proxy
    boolean nocache=false;
    if(skipbytes>0)
    {
       if(dmachine.http_resume==RESUME_NOCACHE) nocache=true;
        else
	  if(dmachine.http_resume==RESUME_DIRECT)
              s=sendHTTPRequest(java.net.InetAddress.getByName(url.getHost()),url.getPort()>0? url.getPort():80, url.getFile(),skipbytes,url.getHost(),false);
    }
  if(s==null)
    s=sendHTTPRequest(dmachine.http_proxyserver,dmachine.http_proxyport,URL,skipbytes,url.getHost(),nocache);
  }
  DataInputStream dis=new DataInputStream(s.getInputStream());

 /* precist httprc */
 int rc=getHTTPRC(dis,URL);
 switch(rc)
 {
   case DOWNLOAD_FATAL: s.close();return DOWNLOAD_FATAL;
   case DOWNLOAD_ERR: s.close();return DOWNLOAD_ERR;
   case DOWNLOAD_BUSY: s.close();return DOWNLOAD_BUSY;
   case DOWNLOAD_RESUME: skipbytes=0;break;
 }

 int ctsize=getHTTPContentSize(dis,qf,url);
 if(rc!=DOWNLOAD_OK && rc!=DOWNLOAD_RESUME)
  {
   // System.out.println("[INTERNAL ERROR] rc="+rc);
   s.close();return rc;
  }
  /* check if ctsize < skipbytes */
  if(rc==DOWNLOAD_OK && ctsize<skipbytes)
   {
    /* file on the server is smaller than ours, download it again */
    System.out.println("[WARNING] Temporary file for "+localname+" is bigger than expected. Downloading it again.");
    new File(dmachine.tmp_dir,localname).delete();
    skipbytes=0;
   }
  return DataTransfer(dis,ctsize,skipbytes,qf,URL);
 }
 
 private final static Socket sendHTTPRequest(java.net.InetAddress adr,int port,String reqline,int skipbytes,String hostheader, boolean nocache) throws java.io.IOException
 {
  Socket s;
  s=new Socket(adr,port);
  s.setSoTimeout(dmachine.timeout);  

  DataOutputStream dos;  
  // otevrit data output stream
  dos=new DataOutputStream(new java.io.BufferedOutputStream(s.getOutputStream(),1024));
 
  // send request
  StringBuffer sb;
  sb=new StringBuffer(1024);
  sb.append("GET ");
  sb.append(reqline);
  if(skipbytes==0) sb.append(" HTTP/1.0");
   else
  sb.append(" HTTP/1.1");
   
  sb.append("\r\nAccept: */*\r\nUser-Agent: "+dmachine.NAME+"/"+dmachine.VERSION+" (Java Virtual Machine)\r\n");
  sb.append("Host: "+hostheader+"\r\nReferer: ");
  //referer check
  String url;
  String referer;
  if(reqline.indexOf("://")>0) url=reqline;
   else url="http://"+hostheader+reqline;
  referer=url;
  
  if(checkreferer==null) checkreferer=sendreferer=new String[0];
  for(int i=checkreferer.length-1;i>=0;i--)
   if(url.startsWith(checkreferer[i]))
    {
     referer=sendreferer[i];
     break;
    }
  sb.append(referer);
  sb.append("\r\nConnection: close\r\n");
  if(nocache) sb.append("Pragma: no-cache\r\n");
  if(skipbytes>0) sb.append("Range: bytes="+skipbytes+"-\r\n");
  sb.append("\r\n");  // end of HTTP/1.0+ Request
  dos.writeBytes(sb.toString());
  dos.flush();
  return s;
}

 private final static int getHTTPRC(DataInputStream dis,String URL) throws java.io.IOException
 {
  // read http-encoded reply
  int httprc;
  String line;
  line=dis.readLine(); /* HTTP/1.0 XX OK */
    /* precteme si tedy httprc kod */
    StringTokenizer st;
    st=new StringTokenizer(line);
    
    /* WARN: tady to spadne pri remote HTTP 0.9 serveru */
    try
    {
      st.nextToken(); /* http/1.0 - nezajimave */
      httprc=Integer.valueOf(st.nextToken()).intValue();
    } 
     catch (Exception http09)
    {
      dmachine.log_fatal(URL+" HTTP 0.9 server is unsupported");
      // s.close();
      return DOWNLOAD_FATAL;
    }
 
 /* HTTP RC test */
 if(httprc>400 && httprc< 500)
  {
   dmachine.log_fatal("Error "+httprc+" when loading "+URL); 
   return DOWNLOAD_FATAL;   
  }
 else if(httprc>=300 && httprc<400 && httprc!=305) return DOWNLOAD_REDIRECT;
 else if(httprc==206) return DOWNLOAD_RESUME;
 else if(httprc==200 || httprc==202) return DOWNLOAD_OK;
 else if(httprc==503) return DOWNLOAD_BUSY; // server busy
 else if(httprc==500) return DOWNLOAD_ERR; // server overloaded/tmp error
 else if(httprc==504) return DOWNLOAD_ERR; // gateway timeout
 else if(httprc>=500) {
   dmachine.log_fatal("Error "+httprc+" when loading "+URL); 
  return DOWNLOAD_FATAL;
  }
 else
  { 
    System.err.println("[ERR] GOT httprc="+httprc+" when loading "+URL+" - will retry"); 
    return DOWNLOAD_ERR; 
  } 
 }
 private final static int getHTTPContentSize(DataInputStream dis,qfile qf,URL url)
 throws IOException
 {
  /* cteme hlavicky */
  int ctsize=0;
  while(true)
    { 
      int j;
      String s1,s2,line;
      line=dis.readLine();
      if(line==null) break;
      if(line.length()==0) break;
      
    j=line.indexOf(':',0);
    if(j==-1) continue;
    s1=line.substring(0,j).toLowerCase();
    s2=line.substring(j+1).trim();
    
    if(s1.equals("location")) 
     { 
       /* Location: handler */

       /* get new URL */
       URL nurl;
       nurl=new URL(url,s2);
       qf.redirect(url.toString(),nurl.toString());
       // return DOWNLOAD_REDIRECT; 
       // supporting multiple redirects ...
      }        
    else if(s1.equals("content-length")) 
             try
              {
                 ctsize=Integer.valueOf(s2).intValue(); 
              }
              catch (Exception ignore)
              {}
              finally
              { continue;}    
                                
    
 } /* hlavicky */
 return ctsize;
 }
 
private static int DataTransfer(DataInputStream dis,int ctsize,int skipbytes,qfile qf,String URL) throws IOException
{
 if(skipbytes>0) { 
    System.err.println("[INFO] Resume on "+URL+" is not supported by server.");
    }

 long lastrep,ct,start;
 lastrep=0;  
 int total=0;
 start=System.currentTimeMillis()-1100L;
 byte b[]=new byte[4096];
 int rb;
 /* SKIP bytes on the beginning */
 while(skipbytes>0)
  {
   if(skipbytes>=4096) rb=dis.read(b);
      else
    rb=dis.read(b,0,skipbytes);
   if(rb==-1) break;
   skipbytes-=rb;
   total+=rb;
   ct=System.currentTimeMillis();
   if(ct-lastrep>dmachine.reptime) 
   {
     long CPS=total/( (ct-start)/1000L);

     System.err.println(
     "[SKIP]\t"+qf.getName()+" "+total+" of "+ctsize+
     " B, ETA= "+util.timeToString(ct-start)+" of "+util.timeToString(1000L*ctsize/CPS)+
     " CPS="+CPS);
     lastrep=ct;
   }
  }
 //open tmp outputfile
 DataOutputStream dos;
 RandomAccessFile ras;
 ras=new RandomAccessFile(dmachine.tmp_dir+File.separator+qf.getLocalName(),"rw");
 ras.seek(ras.length());
 dos=new DataOutputStream(new java.io.BufferedOutputStream(
 new java.io.FileOutputStream(ras.getFD()),4096));

 while(true)
 {
  try
  {
   rb=dis.read(b); 
  }
  catch (IOException ioe)
   { dos.close();throw ioe;}
   
  if(rb==-1) break; /* konec dat! */
  total+=rb;
  dos.write(b,0,rb);
  ct=System.currentTimeMillis();
  if(ct-lastrep>dmachine.reptime) 
   {
     long CPS=total/( (ct-start)/1000L);

     System.err.println(
     "[LOAD]\t"+qf.getName()+" "+total+"/"+ctsize+"("+(int)(100*(float)(total)/(float)(ctsize))+"%) B, ETA= "+util.timeToString(ct-start)+" of "+util.timeToString(1000L*ctsize/CPS)+
     " CPS="+CPS);
     lastrep=ct;
   }
 }
 
 dos.close();
 dis.close();
 if(total<ctsize) { System.out.println("[ERR] Connection closed on "+URL+" Got "+total+"B, expected "+ctsize+"B.");
                    return DOWNLOAD_ERR;
                  }     
 // hotovo
 System.out.println("[OK] *** Download of "+qf.getName()+" ("+new File(dmachine.tmp_dir,qf.getLocalName()).length()+" B) was SUCCESSFULL ***");
 new File(dmachine.tmp_dir,qf.getLocalName()).renameTo
  (new File(dmachine.download_dir,qf.getLocalName()));
  
 if(!qf.getName().equals(qf.getLocalName()))
 {
  System.out.println("[INFO] *** File "+qf.getName()+" saved as "+qf.getLocalName()+" ***");
  String autonm=qfile.genAutoName(qf.getName());
  if(!qf.getLocalName().equals(autonm)) qf.touch();
 }
 return DOWNLOAD_OK;
}

 public static boolean addReferer(String urlmask, String referer)
 {
  if(urlmask==null || referer==null) return false;
  if(urlmask.length()==0 || referer.length()==0) return false;

  if(checkreferer==null) checkreferer=sendreferer=new String[0];
  for(int i=checkreferer.length-1;i>=0;i--)
   if(checkreferer[i].startsWith(urlmask)) 
    {
     sendreferer[i]=referer;
     return false;
    }
 // add new record
 checkreferer=util.addStringToArray(urlmask,checkreferer);
 sendreferer= util.addStringToArray(referer,sendreferer);
 return true;
 }
}  /* class */
