import java.io.*;
import java.net.*;
import java.util.*;

public final class qfile implements Runnable
{
 // location INFO
 private String name; // jmeno souboru
 private String localname; // jmeno pro ulozeni na hadr
 private String URL[]; // na kterych URL je

 // retry status
 private int URLstatus[]; // kolikrat se z nej downloadovalo
 private short retry;  // kolikrat se nahravalo celkem
 private int mindown;
 
 private boolean ok;  // already downloaded?
 private boolean hold; // HOLD=fatal error or retry exhausted
 
 private Thread downloader;  // pro killnuti

 qfile(String fname,String url)
 {
  name=fname;
  URL=new String[1];
  URL[0]=url;
  URLstatus=new int[1];
  URLstatus[0]=0;
  ok=false;
  hold=false;
  downloader=null;
  retry=-1;
  mindown=0;
  
  if(!isGoodFilename(fname)) localname=genAutoName(fname);
   else localname=fname;

  //check for - OK file downloaded.
  checkOK();  
 }

 private final void checkOK()
 {
   if(new File(dmachine.download_dir,localname).exists()) 
    {
     ok=true;
     System.out.println("[OK] File "+name+(localname.equals(name)?"":" ("+localname+")")+" already sucessfully downloaded.");
    }
 }
 public final void addURL(String URL)
 {
  // dupe check
  for(int i=this.URL.length-1;i>=0;i--)
   if(this.URL[i].equals(URL)) return;
   
  System.out.println("[QUEUE] Alternate URL "+URL+" added for file "+name);
  
  this.URL=util.addStringToArray(URL,this.URL);
  this.URLstatus=util.incIntArraySize(this.URLstatus);
  mindown=0;
  // unhold
  hold=false; 
  
  if(retry+dmachine.uretry>dmachine.retry)
  {
    retry-=dmachine.uretry; 
    retry=(short)Math.max(0,retry);
  }
  
 }
 
 public final void run()
 {
  downloader=Thread.currentThread();
  int siteidx=-1;
  try
  {
   retry++;
   
   // najit vhodny sajt. Zatim bereme ten prvni co se namane
   if(mindown>=dmachine.uretry || retry>=dmachine.retry) 
      { 
        hold=true; // no more retries
	downloader=null;
	return;
      }

   idxscan:while(siteidx==-1)
   {
   for(int i=0;i<URLstatus.length;i++)
    if(URLstatus[i]<=mindown) {siteidx=i;break idxscan;}
   mindown++;
   if(mindown>=dmachine.uretry) 
     { 
       hold=true; // no more retries
       downloader=null;
       return;
     }
   }
   System.out.println("[TRYING] URL="+URL[siteidx]);
   URLstatus[siteidx]++;
   int i; 
   switch(downloadfactory.downloadFactory(URL[siteidx],localname,this))
   {
    case downloadfactory.DOWNLOAD_OK:
       ok=true;hold=true;break;
    case downloadfactory.DOWNLOAD_FATAL:
       URLstatus[siteidx]=dmachine.uretry;break;
    case downloadfactory.DOWNLOAD_BUSY:
       URLstatus[siteidx]--;break; // BUSY FTP server
   }
   
  }
  catch(java.net.UnknownHostException e)
  {
    dmachine.log_fatal("URL="+URL[siteidx]+" err="+
        e.getMessage()+": Host unknown.");
    
    URLstatus[siteidx]=dmachine.uretry;
  }
  catch(IOException e)
   {
    System.out.println("[ERR] "+name+" I/O err="+e);
   }
  catch(Exception e)
   {e.printStackTrace();}
  finally
   {
    downloader=null;
   }
 }
 
 public final boolean equals(Object o)
 {
  qfile q;
  if(o instanceof qfile) { q=(qfile)o; return name.equals(q.name);}
   else return false;
 }

 public final void redirect(String from,String to)
 {
  int i=0;
  for(;i<URL.length;i++)
    if(URL[i].equals(from))
      {
        URLstatus[i]=dmachine.uretry; // no longer needed
        System.out.println("[REDIRECT] "+from+" => "+to);
	addURL(to);
        if(!isGoodFilename(name) && genLocalName(to)!=null)
	 {
	  localname=genLocalName(to);
          checkOK();
	  if(ok==true) touch();
	 }
	return;
      }
 }

 private final static boolean isGoodFilename(String n)
 {
  if(n==null) return false;
  if(n.length()==0) return false;
  if(n.indexOf("/")>-1) return false;
  if(n.indexOf("\\")>-1) return false;
  if(n.indexOf(":")>-1) return false;
  return true;
 }
 
 public final static String genAutoName(String uname)
 {
    java.util.zip.CRC32 crc;
    crc=new java.util.zip.CRC32();
    crc.update(uname.getBytes());
    return dmachine.auto_prefix+Long.toHexString(crc.getValue())+dmachine.auto_suffix;
 }

 private final static String genLocalName(String uname)
 {
  String result;
  try
  {
   URL u;
   u=new URL(uname);
   result=dmachine.getFilename(u.getFile());
   if(result==null || result.length()==0) return null; else return result;
  }
  catch (Exception e)
   { return null; }
 }

 /* info methods */
 public final String getName()
 {
   return name;
 }

 public final String getLocalName()
 {
   return localname;
 }

public final boolean isActive()
{
  if(downloader!=null) return true;
   else return false;
}

 public final boolean needsDownload()
 {
  if(ok==true) return false;
  if(isActive()) return false;
  if(hold==true) return false;
  return true;
 }
 
/* create auto-touch generated name */

 public final void touch()
 {
    File f=new File(dmachine.download_dir,genAutoName(name));
    try
     {
      FileOutputStream fos;
      fos=new FileOutputStream(f.toString(),true);
      for(int i=0;i<URL.length;i++)
      {
        fos.write(URL[i].getBytes());
        fos.write('\n');
      }
      fos.write(localname.getBytes());
      fos.write('\n');
      fos.close();
      System.out.println("[INFO] Touched "+genAutoName(name)+" for "+name);
     }
     catch (IOException io) {}
  }
}
