MODULE Setup;

        (********************************************************)
        (*                                                      *)
        (*             FtpServer set-up utility                 *)
        (*                                                      *)
        (*  Programmer:         P. Moylan                       *)
        (*  Started:            22 January 1998                 *)
        (*  Last edited:        3 November 1999                 *)
        (*  Status:             OK                              *)
        (*                                                      *)
        (********************************************************)

IMPORT EditUsers, Security, Setup2, OS2;

FROM Windows IMPORT
    (* type *)  Window, Colour, FrameType, DividerType,
    (* proc *)  OpenWindow, CloseWindow, WriteChar, WriteString, WriteLn,
                SetCursor, GetKey, GetScreenSize;

FROM InetUtilities IMPORT
    (* proc *)  INIGet, INIPut;

FROM Menus IMPORT
    (* type *)  Menu, ItemText,
    (* proc *)  CreateMenu, MenuColours;

FROM ScreenEditor IMPORT
    (* type *)  Structure,
    (* proc *)  CardinalField, MenuField, Combine, ScreenEdit, DeleteStructure;

FROM MultiScreen IMPORT
    (* proc *)  EnableHotKeys;

FROM SetupINI IMPORT
    (* proc *)  OurINIHandle;

(************************************************************************)

VAR
    (* Number of display rows on screen.  *)

    ScreenRows: CARDINAL;

    (* Prompt line at bottom of screen.  *)

    bottombar: Window;

(************************************************************************)
(*                        INI FILE EDITING                              *)
(************************************************************************)

PROCEDURE EditDefaultParameters;

    VAR w: Window;
        R: Structure;
        port, MaxUsers, GuestLimit, FreeSpaceThreshold,
              UserLogging, TimeoutLimit,
              TransferLogLevel, TransactionLogLevel: CARDINAL;
        abort: BOOLEAN;
        hini: OS2.HINI;
        M1, M2: Menu;
        TrlOption: ARRAY [0..4] OF ItemText;
        Log2Option: ARRAY [0..4] OF ItemText;

    (********************************************************************)

    PROCEDURE LoadINIData;

        (* Loads setup parameters from "ftpd.ini". *)

        PROCEDURE GetItem (name: ARRAY OF CHAR;
                             VAR (*OUT*) variable: CARDINAL): BOOLEAN;

            BEGIN
                RETURN INIGet (hini, "$SYS", name, variable);
            END GetItem;

        (****************************************************************)

        BEGIN
            hini := OurINIHandle();
            IF hini = OS2.NULLHANDLE THEN
                WriteString (w, "Could not open FTPD.INI");
                WriteLn (w);
            ELSE
                TransactionLogLevel := 1;
                IF NOT GetItem ("ServerPort", port) THEN
                    port := 21;
                END (*IF*);
                IF NOT GetItem ("MaxUsers", MaxUsers) THEN
                    MaxUsers := 10;
                END (*IF*);
                IF NOT GetItem ("GuestLimit", GuestLimit) THEN
                    GuestLimit := MaxUsers - 1;
                END (*IF*);
                IF GetItem ("DebugLevel", TransactionLogLevel) THEN
                    TransactionLogLevel := 2*TransactionLogLevel + 1;
                END (*IF*);
                IF GetItem ("TransLevel", TransactionLogLevel) THEN
                    TransferLogLevel := TransactionLogLevel DIV 4;
                    INC (TransferLogLevel);
                    TransactionLogLevel := TransactionLogLevel MOD 4;
                    INC (TransactionLogLevel);
                END (*IF*);
                IF NOT GetItem ("SpaceThreshold", FreeSpaceThreshold) THEN
                    FreeSpaceThreshold := 10;
                END (*IF*);
                IF NOT GetItem ("LogLevel", UserLogging) THEN
                    UserLogging := 1;
                END (*IF*);
                IF NOT GetItem ("TimeOut", TimeoutLimit) THEN
                    TimeoutLimit := 900;
                END (*IF*);
            END (*IF*);
        END LoadINIData;

    (********************************************************************)

    PROCEDURE StoreINIData;

        (* Writes data back to the INI file. *)

        PROCEDURE PutItem (name: ARRAY OF CHAR;  VAR (*OUT*) variable: CARDINAL);

            BEGIN
                INIPut (hini, "$SYS", name, variable);
            END PutItem;

        (****************************************************************)

        BEGIN
            IF hini <> OS2.NULLHANDLE THEN
                PutItem ("ServerPort", port);
                PutItem ("MaxUsers", MaxUsers);
                PutItem ("GuestLimit", GuestLimit);
                IF TransactionLogLevel > 0 THEN
                    DEC (TransactionLogLevel);
                END (*IF*);
                IF TransferLogLevel > 0 THEN
                    DEC (TransferLogLevel);
                END (*IF*);
                INC (TransactionLogLevel, 4*TransferLogLevel);
                PutItem ("TransLevel", TransactionLogLevel);
                PutItem ("SpaceThreshold", FreeSpaceThreshold);
                PutItem ("LogLevel", UserLogging);
                PutItem ("TimeOut", TimeoutLimit);

                (* Get rid of the obsolete "DebugLevel" entry. *)

                OS2.PrfWriteProfileData (hini, "$SYS", "DebugLevel", NIL, 0);

            END (*IF*);
        END StoreINIData;

    (********************************************************************)

    BEGIN
        OpenWindow (w, white, blue, ScreenRows DIV 2 - 4, ScreenRows DIV 2 + 7,
                                                  14, 65, noframe, nodivider);
        LoadINIData;

        SetCursor (w, 1, 7);  WriteString (w, "Server port");
        SetCursor (w, 2, 7);  WriteString (w, "Maximum number of users");
        SetCursor (w, 3, 7);  WriteString (w, "Maximum number of guest users");
        SetCursor (w, 4, 7);  WriteString (w, "Free space threshold (MB)");
        SetCursor (w, 5, 7);  WriteString (w, "Timeout (seconds)");
        SetCursor (w, 10, 2);  WriteString (w, "Transaction logging");
        SetCursor (w, 8, 7);  WriteString (w, "Transfer logging level");
        SetCursor (w, 7, 2);  WriteString (w, "Transfer log format");

        R := CardinalField (port, 1, 37, 8);
        Combine (R, CardinalField (MaxUsers, 2, 37, 8));
        Combine (R, CardinalField (GuestLimit, 3, 37, 8));
        Combine (R, CardinalField (FreeSpaceThreshold, 4, 37, 8));
        Combine (R, CardinalField (TimeoutLimit, 5, 37, 8));

        (* Create the menu of transfer log options. *)

        Log2Option[1] := "None";
        Log2Option[2] := "User";
        Log2Option[3] := "Common";
        Log2Option[4] := "Both";
        CreateMenu (M2, 4, Log2Option, 4);
        MenuColours (M2, white, blue, blue, cyan, yellow);
        Combine (R, MenuField (TransferLogLevel, 7, 23, 1, 28, M2));

        Combine (R, CardinalField (UserLogging, 8, 32, 8));

        (* Create the menu of transaction log options. *)

        TrlOption[1] := "None";
        TrlOption[2] := "Disk";
        TrlOption[3] := "Screen";
        TrlOption[4] := "Both";
        CreateMenu (M1, 4, TrlOption, 4);
        MenuColours (M1, white, blue, blue, cyan, yellow);
        Combine (R, MenuField (TransactionLogLevel, 10, 23, 1, 28, M1));

        SetCursor (w, 1, 32);
        LOOP
            ScreenEdit (w, R, abort);
            IF abort THEN EXIT(*LOOP*) END(*IF*);

            (* Consume the character that took us off the edge, and     *)
            (* wrap to the other edge.                                  *)

            IF (GetKey(w) = CHR(0)) AND (GetKey(w) = 'H') THEN
                SetCursor (w, 11, 8);
            ELSE
                SetCursor (w, 1, 32);
            END (*IF*);

        END (*LOOP*);

        DeleteStructure (R);
        StoreINIData;
        CloseWindow (w);

    END EditDefaultParameters;

(************************************************************************)
(*                              MAIN PROGRAM                            *)
(************************************************************************)

PROCEDURE RunTheProgram;

    CONST Esc = CHR(1BH);

    VAR w0, w1: Window;

    BEGIN
        OpenWindow (w0, yellow, red, 0, 8, 0, 39, noframe, nodivider);
        WriteLn (w0);
        WriteLn (w0);
        WriteString (w0, "          FTPSERVER SETUP");
        WriteLn (w0);  WriteLn (w0);
        WriteString (w0, "       Type F4 to edit users");  WriteLn (w0);
        WriteString (w0, "        F5 for more options");  WriteLn (w0);
        WriteString (w0, "        Esc to exit program");

        OpenWindow (w1, black, green, 0, 8, 40, 79, noframe, nodivider);
        WriteLn (w1);
        WriteLn (w1);
        WriteString (w1, "    NOTE: Parameters set on this");  WriteLn (w1);
        WriteString (w1, "     page will take effect the");  WriteLn (w1);
        WriteString (w1, "    next time the server is run");  WriteLn (w1);
        WriteString (w1, "          on this machine");

        EditDefaultParameters;
        CloseWindow (w1);
        CloseWindow (w0);

    END RunTheProgram;

(************************************************************************)

VAR dummy: CARDINAL;

BEGIN
    GetScreenSize (ScreenRows, dummy);
    EnableHotKeys (TRUE, CHR(62), TRUE, CHR(63), TRUE, CHR(64));
    OpenWindow (bottombar, yellow, red, ScreenRows-1, ScreenRows-1, 0, 79, noframe, nodivider);
    WriteString (bottombar, " Esc exit");
    SetCursor (bottombar, 0, 55);
    WriteString (bottombar, "F4,F5 previous/next page");
    RunTheProgram;
FINALLY
    CloseWindow (bottombar);
END Setup.

