/* this cmd is called from forward.cmd . Do not use it alone. */

critsize=307200 /* If message size>critsize then executing smtp logoff before receiving it*/
smtpsock=-1

 server=arg(1)
 user=arg(2)
 password=arg(3)
 forward=arg(4)
 keep=arg(5)
 cenum=arg(6)
 smtpserver=arg(7)
 logfile=arg(8)
 tempfdir=arg(9)

call saynlog 'Forwarding from 'server' for 'user' to 'forward

/*------------------------------------------------------------------
 * get address of servers
 *------------------------------------------------------------------*/
rc = SockGetHostByName(server,"host.!")
if (rc = 0) then
   do
    call saynlog "Unable to resolve pop3server name" errno
    return -1
   end
server = host.!addr
/*------------------------------------------------------------------
 * open socket
 *------------------------------------------------------------------*/
sock = SockSocket("AF_INET","SOCK_STREAM","IPPROTO_TCP")
if (sock = -1) then
   do
    call saynlog "Error opening socket:" errno
    return -1
   end
/*------------------------------------------------------------------
 * connect socket
 *------------------------------------------------------------------*/
server.!family = "AF_INET"
server.!port   = 110
server.!addr   = server
rc = SockConnect(sock,"server.!")
if (rc = -1) then
   do
     call saynlog "Error connecting to popserver :" errno
     rc=SockSoclose(sock)
     return -1
   end

   call saynlog 'Connected to 'server
   trc = GetResponse(sock)

   trc = SendMessage(sock,'USER 'user)
   trc = GetResponseLine(sock)
   parse var trc status rest
   if status <> '+OK' then
     do
       qrc = SendMessage(sock,'QUIT')
       call saynlog ' Error: User' user 'unknown on' server '.'
       rc=SockSoclose(sock)
       return -1
     end

   trc = SendMessage(sock,'PASS 'password)
   trc = GetResponseLine(sock)
   parse var trc status rest
   if status <> '+OK' then
     do
       qrc = SendMessage(sock,'QUIT')
       call saynlog ' Error: Password wrong for' user ' on 'server'.'
       rc=SockSoclose(sock)
       return -1
     end
   else
     do 
       call saynlog 'Authentication completed successfully. Sending List command'
       trc = SendMessage(sock,'LIST')
       trc = GetResponse(sock)
       messages = 0
       parse var line.1 status rest
       if status = '+OK' then 
         do 
           msginfo = GetResponseLine(sock)
           do while msginfo <> '.'
             messages = messages + 1
             msginfo = GetResponseLine(sock)
           end
         end /* do */
       if messages = 0 
         then 
          do
           call saynlog ' There are no messages waiting for you.'
          end
         else
           do 
             call saynlog ' There are' messages 'messages waiting for you.'

             trc = SendMessage(sock,'LIST')
             trc = GetResponse(sock)
             do 
               msginfo = GetResponseLine(sock)
               messize.0=messages
               do while msginfo <> '.'
                 parse var msginfo number size
                 messize.number=size
                 call saynlog ' Message' number 'has' size 'bytes.'
                 msginfo = GetResponseLine(sock)
               end
             end /* do */

             if messize.1<=critsize then smtpsock=ConnectSmtp(smtpserver)

             /* Get Mails */
             do i = 1 to messages
               if messize.i>critsize then smtpsock=closesmtp(smtpsock)
               say ' Getting Message' i
               trc = SendMessage(sock,'RETR 'i)
               trc = GetResponse(sock)
               parse var line.1 status rest
               oneline = GetResponseLine(sock)
               linenum=0
               fromaddr=''
               do while oneline <> '.'
                 linenum=linenum+1
                 message.linenum=oneline
                 res=translate(substr(oneline,1,4))
                 if res='FROM' then 
                  do
                   beg=pos('<',oneline)
                   if beg>0 then
                    do 
                     length=pos('>',oneline)-pos('<',oneline)+1
                     fromaddr=substr(oneline,beg,length)                 
                    end
                             else
                    do
                     parse var oneline from addr rest
                     if space(addr)<>'' then fromaddr=space(addr)
                    end
                   call saynlog 'Message from: 'fromaddr
                  end
                 oneline = GetResponseLine(sock)
               end
               rc=stream(tempfname,'c','close')                 
               if fromaddr='' then
                do
                 call saynlog 'From adress not found. Substituting with nobody@mail.ru'
                 fromaddr='nobody@mail.ru'
                end 

               if smtpsock<0 then smtpsock=ConnectSmtp(smtpserver)
               trc25 = SendMessage(smtpsock,'HELO')
               trc25 = GetResponseLine(smtpsock)
               trc25 = SendMessage(smtpsock,'Mail from: 'fromaddr)
               trc25 = GetResponseLine(smtpsock)
               trc25 = SendMessage(smtpsock,'Rcpt to: 'forward)
               trc25 = GetResponseLine(smtpsock)
               trc25 = SendMessage(smtpsock,'Data')
               trc25 = GetResponseLine(smtpsock)
               do ind=1 to linenum
                trc25 = SendMessage(smtpsock,message.ind)              
               end
               trc25 = SendMessage(smtpsock,'.')
               trc25 = GetResponseLine(smtpsock)
               call saynlog 'Sendmail said: 'trc25
               mesnum=left(trc25,3)
               if mesnum=250 then '@del' tempfname

               if keep="" then
                do
                 trc = SendMessage(sock,'DELE 'i)
                 trc = GetResponse(sock)
                 call saynlog ' Got, forwarded and deleted Message' i
                end
                          else
                do
                 call saynlog ' Got, forwarded and kept Message' i
                end 
             end  
           end
     end

if smtpsock>0 then  smtpsock=closesmtp(smtpsock)
trc = SendMessage(sock,'QUIT')
trc = GetResponse(sock)
rc=SockSoclose(sock)

exit

/*--------------------End of processing current pop3account-----------*/ 

/*-------------Connecting to SmtpServer procedure----------------------------*/
ConnectSmtp: procedure expose logfile cenum

smtpserver=arg(1)

call saynlog 'Connecting to smtp server 'smtpserver

rc = SockGetHostByName(smtpserver,"host.!")
if (rc = 0) then
   do
    call saynlog "Unable to resolve smtpserver name" smtpserver 
    rc=stream(logfile,'c','close')
    return -1
   end
smtpserver = host.!addr
smtpsock = SockSocket("AF_INET","SOCK_STREAM","IPPROTO_TCP")
if (smtpsock = -1) then
 do
  call Saynlog "Error opening socket :" errno
  rc=stream(logfile,'c','close')
  return -1
 end
smtpserver.!family = "AF_INET"
smtpserver.!port   = 25
smtpserver.!addr   = smtpserver
rc = SockConnect(smtpsock,"smtpserver.!")
if (rc = -1) then
 do
  call saynlog "Error connecting to smtpserver :" errno
  rc=stream(logfile,'c','close')
  return -1
 end
trc25 = GetResponse(smtpsock)
call saynlog 'We are connected to smtp server'

return smtpsock

/*------------------------------------------------------------------
 * get a response from the server
 *------------------------------------------------------------------*/
GetResponse:     procedure expose !. line. logfile cenum smtpsock
   sock = arg(1)

   moreids = "100 215 220 221 222 223 230 231"

   line.0 = 1
   line.1 = GetResponseLine(sock)

   parse var line.1 rid .

   if (wordpos(rid,moreids) = 0) then
      return ""

   say ' getting further lines '

   do forever
      o = line.0 + 1

      line.o = GetResponseLine(sock)
      say line.o 

      if (line.o = ".")|(line.o = "") then
         return ""

      line.0 = o
   end

   return ""

/*------------------------------------------------------------------
 * get a line from the server
 *------------------------------------------------------------------*/
GetResponseLine: procedure expose !. logfile cenum smtpsock
   sock = arg(1)

   crlf = d2c(13) || d2c(10)

   if (symbol('!.buff') = "LIT") then
      !.buff = ""

   nullcount=0
   do while (pos(crlf,!.buff) = 0)
      semname='\SEM32\sem'||cenum     
      call SemEventCreate 'sem.cenum', semname      
      call SemStartTimer 'timer.cenum', 1000000, sem.cenum
      call ipccontextcreate contextsr.cenum
      call proccreatethread contextsr.cenum,'sockrcv.cmd', sock, queue.cenum, sem.cenum

      call SemEventWait sem.cenum,15000 /* timeout time is 15 sec for receiving 512 bytes */
      if result=640 then 
        do
         call saynlog 'Timeout receiving data from socket 'sock'. Closing forwarding.'
         call IpcContextClose contextsr.cenum
         call SemStopTimer timer.cenum
         call SemEventClose sem.cenum
         if smtpsock\=sock then smtpsock=closesmtp(smtpsock)
         rc=SockSoclose(sock)
         exit 
        end
      call IpcContextResult contextsr.cenum
      count=left(result,5)
      data=delstr(result,1,5)
      if count=0 then 
       do
        call saynlog 'Null characters received '||count||'  '||nullcount||' *'||data||'*'
        nullcount=nullcount+1
       end
      if nullcount>10 then 
       do
         Call saynlog 'Server closed connection on receive'
         if smtpsock\=sock then smtpsock=closesmtp(smtpsock)
         rc=SockSoclose(sock)
         exit
       end
      call SemStopTimer timer.cenum
      call SemEventClose sem.cenum
      !.buff = !.buff || data
   end

   p = pos(crlf,!.buff)
   line = substr(!.buff,1,p-1)
   !.buff = substr(!.buff,p+2)

   if left(line,4)='-ERR' then call saynlog 'Pop3server says:'line
   return line

/*------------------------------------------------------------------
 * send a string to the server
 *------------------------------------------------------------------*/
SendMessage:     procedure expose !. smtpsock logfile cenum
   sock = arg(1)
   data = arg(2) || d2c(13) || d2c(10)

   /* say 'Sending "'data'" to server.' */
   len = length(data)
   do while (len > 0)
     
      len = SockSend(sock,data);

      /* say 'Returncode: ' len   */
      /* say 'Errorcode:  ' errno */
      /*
      if (errno <> 0) then
         Error(-1,"Error sending data to server.")
      */

      if (len <= 0) then
       do
         call saynlog "Server closed the connection."
         if smtpsock\=sock then smtpsock=closesmtp(smtpsock)
         rc=SockSoclose(sock)
         exit
       end
      
      data = substr(data,len+1)
      len  = length(data)
   end

   return 0

/*-----------------------------*/
closesmtp: procedure expose !. logfile cenum
smtpsock=arg(1)

if smtpsock>0 then
 do
  trc = SockSend(smtpsock,'QUIT') 
  rc = SockSoclose(smtpsock)
 end 

return -1

/*-----------------------------*/
saynlog: procedure expose logfile cenum
 mes='Thread '||cenum||':'||arg(1)
 say mes
 call lineout logfile , mes
return
