/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.control;

import borland.jbcl.control.Res;
import borland.jbcl.dataset.AccessEvent;
import borland.jbcl.dataset.AccessListener;
import borland.jbcl.dataset.Column;
import borland.jbcl.dataset.ColumnAware;
import borland.jbcl.dataset.DataChangeEvent;
import borland.jbcl.dataset.DataChangeListener;
import borland.jbcl.dataset.DataSet;
import borland.jbcl.dataset.DataSetException;
import borland.jbcl.dataset.NavigationEvent;
import borland.jbcl.dataset.NavigationListener;
import borland.jbcl.dataset.SingletonDataSetManager;
import borland.jbcl.model.BasicSingletonContainer;
import borland.jbcl.model.ItemFormatter;
import borland.jbcl.model.SingletonModel;
import borland.jbcl.model.VariantFormatter;
import borland.jbcl.model.WritableSingletonModel;
import borland.jbcl.util.BlackBox;
import borland.jbcl.view.TextFieldView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.KeyEvent;

public class TextFieldControl
extends TextFieldView
implements NavigationListener,
DataChangeListener,
AccessListener,
WritableSingletonModel,
BlackBox,
ColumnAware {
    private DataSet dataSet;
    private String columnName;
    private boolean addNotifyCalled = false;

    public TextFieldControl() {
        this.setModel(new BasicSingletonContainer());
    }

    public void setModel(SingletonModel singletonModel) {
        if (singletonModel == this) {
            throw new IllegalArgumentException(Res.getString(77));
        }
        super.setModel(singletonModel);
    }

    protected void updateText() {
        VariantFormatter variantFormatter;
        Column column;
        if (this.model != null && this.dataSet != null && (column = this.dataSet.hasColumn(this.columnName)) != null && (variantFormatter = column.getFormatter()) != null) {
            Object object = this.model.get();
            int n = this.getSelectionStart();
            int n2 = this.getSelectionEnd();
            String string = "";
            try {
                string = ((ItemFormatter)variantFormatter).format(object);
            }
            catch (Exception exception) {
                DataSetException.handleException(this.dataSet, this, exception);
                return;
            }
            this.setSuperText(string != null ? string : "");
            this.setSelectionStart(n);
            this.setSelectionEnd(n2);
            return;
        }
        super.updateText();
    }

    public void setText(String string) {
        VariantFormatter variantFormatter;
        Column column;
        if (this.canSet(true) && !this.locateOnly && this.dataSet != null && (column = this.dataSet.hasColumn(this.columnName)) != null && (variantFormatter = column.getFormatter()) != null) {
            Object object = null;
            try {
                object = ((ItemFormatter)variantFormatter).parse(string);
            }
            catch (Exception exception) {
                DataSetException.handleException(this.dataSet, this, exception);
                return;
            }
            try {
                this.writeModel.set(object);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        super.setText(string);
    }

    protected void postText() {
        VariantFormatter variantFormatter;
        Column column;
        if (this.canSet(true) && !this.locateOnly && this.dataSet != null && (column = this.dataSet.hasColumn(this.columnName)) != null && (variantFormatter = column.getFormatter()) != null) {
            String string = super.getText();
            Object object = null;
            try {
                object = ((ItemFormatter)variantFormatter).parse(string);
            }
            catch (Exception exception) {
                DataSetException.handleException(this.dataSet, this, exception);
                return;
            }
            try {
                this.writeModel.set(object);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        super.postText();
    }

    public void accessChange(AccessEvent accessEvent) {
        switch (accessEvent.getID()) {
            case 1: {
                try {
                    this.openDataSet(this.dataSet);
                }
                catch (Exception exception) {
                    accessEvent.appendException(exception);
                }
                break;
            }
            case 2: {
                break;
            }
        }
    }

    public void navigated(NavigationEvent navigationEvent) {
        this.updateText();
    }

    public void dataChanged(DataChangeEvent dataChangeEvent) {
    }

    public void postRow(DataChangeEvent dataChangeEvent) throws Exception {
        String string;
        Object object = this.get();
        String string2 = string = object != null ? object.toString() : "";
        if (!string.equals(this.getText())) {
            this.postText();
        }
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(DataSet dataSet) {
        if (this.dataSet != null) {
            this.dataSet.removeAccessListener(this);
            this.dataSet.removeNavigationListener(this);
            this.dataSet.removeDataChangeListener(this);
        }
        this.openDataSet(dataSet);
        if (this.dataSet != null) {
            this.dataSet.addAccessListener(this);
            this.dataSet.addNavigationListener(this);
            this.dataSet.addDataChangeListener(this);
        }
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String string) {
        this.columnName = string;
        if (this.addNotifyCalled) {
            this.openDataSet(this.dataSet);
        }
    }

    public void addNotify() {
        super.addNotify();
        if (!this.addNotifyCalled) {
            this.addNotifyCalled = true;
            if (this.dataSet != null) {
                this.openDataSet(this.dataSet);
            }
        }
    }

    private void openDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
        if (this.dataSet == null) {
            this.setModel(new BasicSingletonContainer());
            return;
        }
        if (this.addNotifyCalled && !this.dataSet.isOpen()) {
            try {
                this.dataSet.open();
            }
            catch (DataSetException dataSetException) {
                DataSetException.handleException(this.dataSet, this, dataSetException);
                this.setModel(new BasicSingletonContainer());
                return;
            }
        }
        if (this.dataSet.isOpen()) {
            this.bindDataSet();
        }
    }

    private void bindDataSet() {
        Column column;
        if (this.dataSet != null && (column = this.dataSet.hasColumn(this.columnName)) != null) {
            this.setModel(new SingletonDataSetManager(this.dataSet, column, this));
            this.bindProperties(column);
        }
    }

    private void bindProperties(Column column) {
        Color color = column.getBackground();
        Color color2 = column.getForeground();
        Font font = column.getFont();
        if (color != null) {
            ((Component)this).setBackground(color);
        }
        if (color2 != null) {
            this.setForeground(color2);
        }
        if (font != null) {
            this.setFont(font);
        }
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (keyEvent.getID() != 401 || keyEvent.isConsumed() || this.dataSet == null || !this.dataSet.isOpen()) {
            return;
        }
        try {
            switch (keyEvent.getKeyCode()) {
                case 155: {
                    if (this.postOnFocusLost) {
                        this.postText();
                    }
                    this.dataSet.insertRow(false);
                    break;
                }
                case 127: {
                    if (keyEvent.isControlDown()) {
                        this.dataSet.deleteRow();
                    }
                    break;
                }
                case 34: {
                    if (this.postOnFocusLost) {
                        this.postText();
                    }
                    this.dataSet.next();
                    break;
                }
                case 33: {
                    if (this.postOnFocusLost) {
                        this.postText();
                    }
                    this.dataSet.prior();
                }
            }
        }
        catch (DataSetException dataSetException) {
            // empty catch block
        }
    }

    public Object get() {
        return this.getModel().get();
    }

    public void set(Object object) {
        if (this.getWriteModel() != null) {
            this.getWriteModel().set(object);
        }
    }

    public void touched() {
        if (this.getWriteModel() != null) {
            this.getWriteModel().touched();
        }
    }

    public void enableModelEvents(boolean bl) {
        if (this.getWriteModel() != null) {
            this.getWriteModel().enableModelEvents(bl);
        }
    }
}

