/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.ActiveBox;
import ice.htmlbrowser.Box;
import ice.htmlbrowser.BrowserURLLoader;
import ice.htmlbrowser.DocContainer;
import ice.htmlbrowser.ImageMap;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.net.MalformedURLException;
import java.net.URL;

class BoxImage
extends Box
implements ActiveBox,
ImageObserver {
    private transient Object lockObject = new Object();
    boolean doImageAnim = false;
    private transient Image image;
    private volatile boolean imageError = false;
    private volatile int iwidth = -1;
    private volatile int iheight = -1;
    private int v_space = 0;
    private int h_space = 0;
    private int v_align = 0;
    private String curLink = null;
    private String curTargetFrame = null;
    private boolean is_map = false;
    private boolean use_map = false;
    public static final int ALIGN_BOTTOM = 0;
    public static final int ALIGN_MIDDLE = 1;
    public static final int ALIGN_TOP = 2;

    BoxImage(DocContainer d, String imageName, int w, int h) {
        super(d);
        URL url;
        this.iwidth = w;
        this.iheight = h;
        this.image = null;
        try {
            url = new URL(this.doc.getDocumentBase(), imageName);
        }
        catch (MalformedURLException e) {
            System.err.println(String.valueOf("MalformedURLException : ").concat(String.valueOf(e)));
            return;
        }
        BrowserURLLoader aul = new BrowserURLLoader(url);
        this.image = aul.getImage();
        d.addImage(this.image);
    }

    public void activeShow() {
        this.doImageAnim = true;
        this.doc.prepareImage(this.image, -1, -1, this);
    }

    public void activeHide() {
        this.doImageAnim = false;
    }

    public void activeInterrupt() {
        this.doImageAnim = false;
    }

    public boolean imageUpdate(Image img, int info, int x, int y, int w, int h) {
        if ((info & 1) != 0 && this.iwidth < 0) {
            this.iwidth = w;
        }
        if ((info & 2) != 0 && this.iheight < 0) {
            this.iheight = h;
        }
        if ((info & 0xC0) != 0) {
            this.imageError = true;
        }
        if (this.iwidth > 0 && this.iheight > 0 || this.imageError) {
            Object object = this.lockObject;
            synchronized (object) {
                try {
                    this.lockObject.notify();
                    Object var9_8 = null;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    throw throwable;
                }
            }
        }
        if (this.doImageAnim && (info & 0x38) != 0) {
            this.doc.repaintBox(this);
        }
        return (info & 0xE0) == 0;
    }

    Dimension size() {
        if (this.image != null && !this.imageError) {
            if (this.iwidth < 0) {
                this.iwidth = this.image.getWidth(this);
            }
            if (this.iheight < 0) {
                this.iheight = this.image.getHeight(this);
            }
            if (this.iwidth < 0 || this.iheight < 0) {
                try {
                    Object object = this.lockObject;
                    synchronized (object) {
                        try {
                            this.lockObject.wait();
                            Object var3_3 = null;
                        }
                        catch (Throwable throwable) {
                            Object var3_4 = null;
                            throw throwable;
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (this.iwidth < 0) {
            this.iwidth = 10;
        }
        if (this.iheight < 0) {
            this.iheight = 10;
        }
        this.resize(this.iwidth, this.iheight);
        return super.size();
    }

    void paint(Graphics g) {
        if (this.imageError || this.image == null) {
            g.setColor(this.color);
            g.draw3DRect(this.h_space, this.v_space, this.width - this.h_space * 2 - 1, this.height - this.v_space * 2 - 1, false);
        }
        if (this.image != null) {
            if (this.doc.getBackgroundImage() != null) {
                g.drawImage(this.image, this.h_space, this.v_space, this.width - this.h_space * 2, this.height - this.v_space * 2, this);
            } else {
                g.drawImage(this.image, this.h_space, this.v_space, this.width - this.h_space * 2, this.height - this.v_space * 2, this.doc.getBackground(), this);
            }
        }
    }

    void setColor(Color c) {
        if (c.equals(Color.white)) {
            c = c.darker().darker();
        }
        if (c.equals(Color.black)) {
            c = Color.white;
        }
        super.setColor(c);
    }

    protected void resize(int iw, int ih) {
        super.resize(iw + this.h_space * 2, ih + this.v_space * 2);
    }

    Image getImage() {
        return this.image;
    }

    void setHSpace(int h) {
        this.h_space = h;
        if (this.link != null) {
            ++this.h_space;
        }
    }

    void setVSpace(int v) {
        this.v_space = v;
        if (this.link != null) {
            ++this.v_space;
        }
    }

    void setVAlign(int a) {
        this.v_align = a;
    }

    int getBaseLine() {
        if (this.v_align == 2 && this.height > 10) {
            return 10;
        }
        if (this.v_align == 1) {
            return this.height / 2;
        }
        return this.height;
    }

    void setLink(String href, String targetFrame) {
        this.curLink = href;
        this.curTargetFrame = targetFrame;
        super.setLink(href, targetFrame);
    }

    void setIsMap(boolean flag) {
        this.is_map = flag;
    }

    void setUseMap(String loc) {
        this.use_map = true;
        this.setLink(loc, this.linkTargetFrame);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Box mouseClicked(int x, int y) {
        if (this.link == null) return null;
        if (this.use_map) {
            ImageMap map = this.doc.getImageMap(this.link);
            if (map == null || !map.findLink(x, y, this.width, this.height)) return null;
            this.curLink = map.getLink();
            this.curTargetFrame = map.getLinkTargetFrame();
            return this;
        } else {
            if (!this.is_map) return this;
            this.curLink = String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.link).concat(String.valueOf("?"))).concat(String.valueOf(String.valueOf(x)))).concat(String.valueOf(","))).concat(String.valueOf(String.valueOf(y)));
            this.curTargetFrame = this.linkTargetFrame;
        }
        return this;
    }

    Box mouseMoved(int x, int y) {
        return this.mouseClicked(x, y);
    }

    String getLink() {
        return this.curLink;
    }

    String getLinkTargetFrame() {
        return this.curTargetFrame;
    }
}

