/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.Browser;
import ice.htmlbrowser.BrowserContext;
import ice.htmlbrowser.BrowserSecurityManager;
import ice.htmlbrowser.DocContainer;
import ice.htmlbrowser.DocFrameInfo;
import ice.htmlbrowser.DocFramesetInfo;
import ice.htmlbrowser.DocumentCustomizer;
import ice.htmlbrowser.DocumentTracker;
import ice.htmlbrowser.FontInfo;
import ice.htmlbrowser.HistoryEntry;
import ice.htmlbrowser.MouseOverLinkEvent;
import ice.htmlbrowser.MouseOverLinkListener;
import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;

public class Document
extends Panel
implements AdjustmentListener,
KeyListener,
MouseListener,
MouseOverLinkListener,
Externalizable {
    private static int frameNameCounter = 1;
    private String frameName;
    private static final Dimension zero = new Dimension(0, 0);
    private static Color defaultBackgroundColor = Color.white;
    public static String myProtocol = "jam";
    static boolean initDone = false;
    private int update_counter = 0;
    private boolean repaint_flag = false;
    private boolean layoutDone = false;
    private URL referer;
    private int marginWidth;
    private int marginHeight;
    private int scrollType = 0;
    private DocFramesetInfo mainFrameset;
    private Stack framesetStack = new Stack();
    private boolean flagDocWithFrames = false;
    private DocContainer doc;
    private Adjustable scrollH;
    private Adjustable scrollV;
    private Component scrollHC;
    private Component scrollVC;
    private URL waitForRef;
    private URL locURL;
    private transient Stack backHistory = new Stack();
    private transient Stack fwdHistory = new Stack();
    private transient Vector mouseOverLinkListeners = new Vector();
    private static transient Vector documentCustomizerList;
    private static transient FontInfo defaultFontInfo;
    public static final int SCROLL_AUTO = 0;
    public static final int SCROLL_YES = 1;
    public static final int SCROLL_NO = 2;
    public static final int DEFAULT_MARGIN_WIDTH = 10;
    public static final int DEFAULT_MARGIN_HEIGHT = 10;

    public Document() {
        this(null, null, 0);
    }

    public Document(URL url) {
        this(url, null, 0);
    }

    public Document(URL url, String outputString) {
        this(url, outputString, null, 0);
    }

    public Document(URL url, String outputString, URL ref) {
        this(url, outputString, ref, 0);
    }

    public Document(URL url, String outputString, int scrollType) {
        this(url, outputString, null, scrollType);
    }

    public Document(URL url, String outputString, URL ref, int scrollType) {
        Document.doStaticInit();
        this.scrollType = scrollType;
        this.setReferer(ref);
        this.setMarginWidth(10);
        this.setMarginHeight(10);
        this.frameName = String.valueOf("DocFrame#").concat(String.valueOf(frameNameCounter));
        ++frameNameCounter;
        this.setLayout(new BorderLayout());
        this.doc = new DocContainer(this, url, outputString, defaultFontInfo);
        this.locURL = url;
        this.add("Center", this.doc);
        this.setHorizAdjuster(new Scrollbar(0));
        this.setVertAdjuster(new Scrollbar(1));
        this.addMouseOverLinkListener(this);
        this.addKeyListener(this);
        this.doc.addKeyListener(this);
        this.doc.addMouseListener(this);
        this.backHistory.push(new HistoryEntry(url, this.getFrameName()));
        if (url != null && url.getRef() != null) {
            this.setWaitForRef(url);
        }
    }

    public static void setDefaultBackground(Color bg) {
        defaultBackgroundColor = bg;
    }

    public static Color getDefaultBackground() {
        return defaultBackgroundColor;
    }

    void setWaitForRef(URL url) {
        this.waitForRef = url;
    }

    URL getURL() {
        return this.locURL;
    }

    static void doStaticInit() {
        if (initDone) {
            return;
        }
        try {
            Properties newP = new Properties(System.getProperties());
            ((Hashtable)newP).put("java.protocol.handler.pkgs", String.valueOf("ice.protocols|").concat(String.valueOf(newP.getProperty("java.protocol.handler.pkgs"))));
            System.setProperties(newP);
        }
        catch (SecurityException se) {
            System.out.println("ICE Browser not allowed to add protocol handler");
        }
        initDone = true;
    }

    public static void addDocumentCustomizer(DocumentCustomizer dc) {
        if (!documentCustomizerList.contains(dc)) {
            documentCustomizerList.addElement(dc);
        }
    }

    private void fireDocumentCustomizers() {
        int n = documentCustomizerList.size();
        for (int i = 0; i < n; ++i) {
            DocumentCustomizer l = (DocumentCustomizer)documentCustomizerList.elementAt(i);
            l.customConfigure(this);
        }
    }

    public Container getDocumentContainer() {
        return this.doc;
    }

    boolean goBack() {
        if (this.flagDocWithFrames) {
            HistoryEntry he;
            String frameName = null;
            if (!this.backHistory.empty()) {
                he = (HistoryEntry)this.backHistory.peek();
                frameName = he.getFrameName();
            }
            if (!this.mainFrameset.goBack(frameName)) {
                if (this.backHistory.size() <= 1) {
                    return false;
                }
                he = (HistoryEntry)this.backHistory.peek();
                this.updateCurrentHistoryEntry();
                this.fwdHistory.push(this.backHistory.pop());
                he = (HistoryEntry)this.backHistory.peek();
                this.gotoLocation(he.getURL(), he.getFrameName(), null, false);
            }
        } else {
            if (this.backHistory.size() <= 1) {
                return false;
            }
            this.updateCurrentHistoryEntry();
            this.fwdHistory.push(this.backHistory.pop());
            HistoryEntry he = (HistoryEntry)this.backHistory.peek();
            this.setDocumentBase(he.getURL());
            this.scrollTo(he.getPosition().x, he.getPosition().y);
            this.updateCurrentURL();
        }
        return true;
    }

    boolean goForward() {
        if (this.flagDocWithFrames) {
            HistoryEntry he;
            String frameName = null;
            if (!this.backHistory.empty()) {
                he = (HistoryEntry)this.backHistory.peek();
                frameName = he.getFrameName();
            }
            if (!this.mainFrameset.goForward(frameName)) {
                if (this.fwdHistory.empty()) {
                    return false;
                }
                this.updateCurrentHistoryEntry();
                this.backHistory.push(this.fwdHistory.pop());
                he = (HistoryEntry)this.backHistory.peek();
                this.gotoLocation(he.getURL(), he.getFrameName(), null, false);
            }
        } else {
            if (this.fwdHistory.empty()) {
                return false;
            }
            this.updateCurrentHistoryEntry();
            this.backHistory.push(this.fwdHistory.pop());
            HistoryEntry he = (HistoryEntry)this.backHistory.peek();
            this.setDocumentBase(he.getURL());
            this.scrollTo(he.getPosition().x, he.getPosition().y);
            this.updateCurrentURL();
        }
        return true;
    }

    void updateCurrentHistoryEntry() {
        if (!this.backHistory.empty()) {
            HistoryEntry he = (HistoryEntry)this.backHistory.pop();
            he = this.flagDocWithFrames ? new HistoryEntry(he.getURL(), he.getFrameName(), this.doc.getScrollPosition()) : new HistoryEntry(he.getURL(), this.getFrameName(), this.doc.getScrollPosition());
            this.backHistory.push(he);
        }
    }

    void setFrameName(String str) {
        this.frameName = str;
        this.updateCurrentHistoryEntry();
    }

    String getFrameName() {
        return this.frameName;
    }

    void startFrameset(int[] colValues, int[] colTypes, int[] rowValues, int[] rowTypes) {
        DocFramesetInfo f = new DocFramesetInfo(colValues, colTypes, rowValues, rowTypes);
        if (!this.framesetStack.empty()) {
            DocFramesetInfo parent = (DocFramesetInfo)this.framesetStack.peek();
            parent.addFrame(f);
        } else {
            this.mainFrameset = f;
        }
        this.framesetStack.push(f);
    }

    void finishFrameset() {
        if (!this.framesetStack.empty()) {
            this.framesetStack.pop();
        }
        if (this.framesetStack.empty()) {
            this.backHistory.removeAllElements();
            this.flagDocWithFrames = true;
            this.removeKeyListener(this);
            this.removeAll();
            this.setLayout(null);
            this.scrollHC.setVisible(false);
            this.scrollVC.setVisible(false);
            this.doc.setVisible(false);
        }
    }

    void addFrame(String src, String name, int mw, int mh, int scroll) {
        if (!this.framesetStack.empty()) {
            try {
                DocFramesetInfo f = (DocFramesetInfo)this.framesetStack.peek();
                URL url = new URL(this.getDocumentBase(), src);
                DocFrameInfo df = new DocFrameInfo(url, name);
                if (mw >= 0 || mh >= 0) {
                    if (mw < 0) {
                        mw = 0;
                    }
                    if (mh < 0) {
                        mh = 0;
                    }
                    df.setMargins(mw, mh);
                }
                if (scroll > 0) {
                    df.setScrolling(scroll);
                }
                f.addFrame(df);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    public void setHorizAdjuster(Adjustable sh) {
        block3: {
            if (this.scrollType != 0 && this.scrollType != 1) break block3;
            sh.setMaximum(0);
            sh.setVisibleAmount(0);
            sh.setMinimum(0);
            sh.setValue(0);
            sh.addAdjustmentListener(this);
            if (this.scrollH != null) {
                int x = this.scrollH.getValue();
                this.remove(this.scrollHC);
                if (this.scrollV != null) {
                    this.doc.scrollTo(x, this.scrollV.getValue());
                }
            }
            this.scrollH = sh;
            this.scrollHC = (Component)((Object)sh);
            this.add("South", this.scrollHC);
            if (this.scrollType != 1) {
                this.scrollHC.setVisible(false);
            }
        }
    }

    public void setVertAdjuster(Adjustable sv) {
        int y = 0;
        if (this.scrollType == 0 || this.scrollType == 1) {
            sv.setMaximum(0);
            sv.setVisibleAmount(0);
            sv.setMinimum(0);
            sv.setValue(0);
            sv.addAdjustmentListener(this);
            if (this.scrollV != null) {
                y = this.scrollV.getValue();
                this.remove(this.scrollVC);
                if (this.scrollH != null) {
                    this.doc.scrollTo(this.scrollH.getValue(), y);
                }
            }
            this.scrollV = sv;
            this.scrollVC = (Component)((Object)sv);
            this.add("East", this.scrollVC);
        }
    }

    public synchronized void adjustmentValueChanged(AdjustmentEvent e) {
        Adjustable adj = e.getAdjustable();
        int val = e.getValue();
        adj.setValue(val);
        this.doc.scrollTo(this.scrollH.getValue(), this.scrollV.getValue());
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.requestFocus();
        ((Browser)this.getParent()).mousePressed(e);
    }

    public void mouseClicked(MouseEvent e) {
        ((Browser)this.getParent()).mouseClicked(e);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public String getSelectedText(MouseEvent e) {
        String text = null;
        if (this.doc != null) {
            text = this.doc.getSelectedText(e);
        }
        return text;
    }

    public void mouseOverLinkMoved(MouseOverLinkEvent e) {
    }

    public void mouseOverLinkClicked(MouseOverLinkEvent e) {
        this.gotoLocation(e.getLink(), e.getLinkTargetFrame(), e.getOutputString());
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        Point p = this.doc.getScrollPosition();
        switch (code) {
            case 39: {
                if (!this.scrollHC.isVisible()) break;
                this.scrollTo(p.x + this.scrollH.getUnitIncrement(), p.y);
                break;
            }
            case 37: {
                if (!this.scrollHC.isVisible()) break;
                this.scrollTo(p.x - this.scrollH.getUnitIncrement(), p.y);
                break;
            }
            case 40: {
                if (!this.scrollVC.isVisible()) break;
                this.scrollTo(p.x, p.y + this.scrollV.getUnitIncrement());
                break;
            }
            case 38: {
                if (!this.scrollVC.isVisible()) break;
                this.scrollTo(p.x, p.y - this.scrollV.getUnitIncrement());
                break;
            }
            case 32: 
            case 34: {
                if (!this.scrollVC.isVisible()) break;
                this.scrollTo(p.x, p.y + this.scrollV.getBlockIncrement());
                break;
            }
            case 33: {
                if (!this.scrollVC.isVisible()) break;
                this.scrollTo(p.x, p.y - this.scrollV.getBlockIncrement());
            }
        }
    }

    public boolean isFocusTraversable() {
        return !this.flagDocWithFrames;
    }

    public void addNotify() {
        super.addNotify();
        this.requestFocus();
    }

    public void addMouseOverLinkListener(MouseOverLinkListener l) {
        if (!this.mouseOverLinkListeners.contains(l)) {
            this.mouseOverLinkListeners.addElement(l);
        }
    }

    public void removeMouseOverLinkListener(MouseOverLinkListener l) {
        if (this.mouseOverLinkListeners.contains(l)) {
            this.mouseOverLinkListeners.removeElement(l);
        }
    }

    void fireMouseOverLinkMovedEvent(MouseOverLinkEvent e) {
        int n = this.mouseOverLinkListeners.size();
        for (int i = 0; i < n; ++i) {
            MouseOverLinkListener l = (MouseOverLinkListener)this.mouseOverLinkListeners.elementAt(i);
            l.mouseOverLinkMoved(e);
        }
    }

    void fireMouseOverLinkClickedEvent(MouseOverLinkEvent e) {
        int n = this.mouseOverLinkListeners.size();
        for (int i = 0; i < n; ++i) {
            MouseOverLinkListener l = (MouseOverLinkListener)this.mouseOverLinkListeners.elementAt(i);
            l.mouseOverLinkClicked(e);
        }
    }

    public void setProportionalFont(Font font) {
        defaultFontInfo = new FontInfo(font, defaultFontInfo.getFixFont());
        this.doc.setFontInfo(defaultFontInfo);
    }

    public Font getProportionalFont() {
        return defaultFontInfo.getPropFont();
    }

    public void setFixedFont(Font font) {
        defaultFontInfo = new FontInfo(defaultFontInfo.getPropFont(), font);
        this.doc.setFontInfo(defaultFontInfo);
    }

    public Font getFixedFont() {
        return defaultFontInfo.getFixFont();
    }

    public void stopLoading() {
        if (this.flagDocWithFrames) {
            return;
        }
        this.doc.stopLoading();
    }

    public void setDocumentBase(URL url) {
        if (this.flagDocWithFrames) {
            return;
        }
        this.doc.setDocumentBase(url);
    }

    public URL getDocumentBase() {
        return this.doc.getDocumentBase();
    }

    public void showDocument() {
        if (this.flagDocWithFrames) {
            this.mainFrameset.showDocument(this);
        } else {
            this.doc.showDocument();
        }
        this.fireDocumentCustomizers();
        this.validate();
    }

    public void hideDocument() {
        if (this.flagDocWithFrames) {
            this.mainFrameset.hideDocument();
        } else {
            this.doc.hideDocument();
        }
    }

    public void htmlStart() {
        if (this.flagDocWithFrames) {
            return;
        }
        this.doc.htmlStart();
    }

    public void htmlAppend(String str) {
        if (this.flagDocWithFrames) {
            return;
        }
        this.doc.htmlAppend(str);
    }

    public void htmlAppend(InputStream stream) {
        if (this.flagDocWithFrames) {
            return;
        }
        this.doc.htmlAppend(stream);
    }

    public void parseHTMLString(String str) {
        if (this.flagDocWithFrames) {
            return;
        }
        this.doc.parseHTMLString(str);
    }

    public void parseHTMLStream(InputStream stream) {
        if (this.flagDocWithFrames) {
            return;
        }
        this.doc.parseHTMLStream(stream);
    }

    public Dimension getPreferredSize() {
        Dimension current = this.getSize();
        return current.equals(zero) ? super.getPreferredSize() : current;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void doLayout() {
        this.setLayoutDone(false);
        super.doLayout();
        if (this.flagDocWithFrames) {
            this.mainFrameset.doLayout(0, 0, this.getSize().width, this.getSize().height);
        }
    }

    public boolean isParsingDone() {
        return this.doc.isParsingDone();
    }

    public boolean isLayoutDone() {
        return this.layoutDone;
    }

    private void setLayoutDone(boolean done) {
        this.layoutDone = done;
    }

    void firstDocumentDimension() {
        this.repaint_flag = true;
        Dimension dv = this.doc.visSize();
        if (this.scrollH != null) {
            this.scrollH.setUnitIncrement(20);
            this.scrollH.setBlockIncrement(dv.width);
        }
        if (this.scrollV != null) {
            this.scrollV.setUnitIncrement(20);
            this.scrollV.setBlockIncrement(dv.height);
        }
    }

    void updateDocumentDimension(int doc_width, int doc_height) {
        if (this.update_counter > 0) {
            --this.update_counter;
            return;
        }
        this.update_counter = 100;
        Dimension dv = this.doc.visSize();
        Point pos = this.doc.getScrollPosition();
        if (this.scrollH != null) {
            this.scrollH.setValue(pos.x);
            this.scrollH.setVisibleAmount(dv.width);
            this.scrollH.setMinimum(0);
            this.scrollH.setMaximum(doc_width);
        }
        if (this.scrollV != null) {
            this.scrollV.setValue(pos.y);
            this.scrollV.setVisibleAmount(dv.height);
            this.scrollV.setMinimum(0);
            this.scrollV.setMaximum(doc_height);
        }
        if (doc_height >= pos.y + dv.height && this.repaint_flag) {
            this.repaint_flag = false;
            this.doc.repaint();
        }
    }

    void finalDocumentDimension(boolean afterLayout) {
        Dimension dd = this.doc.docSize();
        Dimension dv = this.doc.visSize();
        boolean h_flag = false;
        boolean v_flag = false;
        if (this.scrollType == 0) {
            if (dd.width <= dv.width) {
                if (this.scrollHC.isVisible()) {
                    this.scrollH.setValue(0);
                    this.scrollHC.setVisible(false);
                    dv.height += this.scrollHC.getSize().height;
                    h_flag = true;
                }
            } else if (!this.scrollHC.isVisible()) {
                this.scrollHC.setVisible(true);
                dv.height -= this.scrollHC.getSize().height;
                h_flag = true;
            }
            if (dd.height <= dv.height) {
                if (this.scrollVC.isVisible()) {
                    this.scrollV.setValue(0);
                    this.scrollVC.setVisible(false);
                    dv.width += this.scrollVC.getSize().width;
                    v_flag = true;
                }
            } else if (!this.scrollVC.isVisible()) {
                this.scrollVC.setVisible(true);
                dv.width -= this.scrollVC.getSize().width;
                v_flag = true;
            }
        }
        if (this.scrollH != null) {
            this.scrollH.setValue(this.doc.getScrollPosition().x);
            this.scrollH.setVisibleAmount(dv.width);
            this.scrollH.setMinimum(0);
            this.scrollH.setMaximum(dd.width);
        }
        if (this.scrollV != null) {
            this.scrollV.setValue(this.doc.getScrollPosition().y);
            this.scrollV.setVisibleAmount(dv.height);
            this.scrollV.setMinimum(0);
            this.scrollV.setMaximum(dd.height);
        }
        if (h_flag || v_flag) {
            this.doLayout();
        }
        Point ds = this.doc.getScrollPosition();
        if (h_flag && this.scrollHC.isVisible()) {
            this.scrollH.setValue(ds.x);
            this.scrollH.setVisibleAmount(dv.width);
            this.scrollH.setMinimum(0);
            this.scrollH.setMaximum(dd.width);
            this.scrollH.setUnitIncrement(20);
            this.scrollH.setBlockIncrement(dv.width);
        }
        if (this.waitForRef != null) {
            Point p = this.doc.getAnchorPosition(this.waitForRef);
            if (p != null && this.scrollVC.isVisible()) {
                this.scrollV.setValue(p.y);
            }
            this.waitForRef = null;
        }
        if ((this.scrollType == 0 || this.scrollType == 1) && (afterLayout && this.repaint_flag || v_flag || h_flag || ds.x != this.scrollH.getValue() || ds.y != this.scrollV.getValue())) {
            this.doc.scrollJumpTo(this.scrollH.getValue(), this.scrollV.getValue());
        }
        Document document = this;
        synchronized (document) {
            try {
                this.setLayoutDone(true);
                this.notifyAll();
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                throw throwable;
            }
        }
    }

    public void scrollTo(int x, int y) {
        if (this.flagDocWithFrames) {
            return;
        }
        if (this.scrollHC.isVisible()) {
            this.scrollH.setValue(x);
        }
        if (this.scrollVC.isVisible()) {
            this.scrollV.setValue(y);
        }
        this.doc.scrollTo(this.scrollH.getValue(), this.scrollV.getValue());
    }

    public void gotoLocation(URL url, String targetFrame) {
        this.gotoLocation(url, targetFrame, null, true);
    }

    public void gotoLocation(URL url, String targetFrame, String outputString) {
        this.gotoLocation(url, targetFrame, outputString, true);
    }

    private void gotoLocation(URL url, String targetFrame, String outputString, boolean flagUpdateHistory) {
        if (targetFrame == null) {
            targetFrame = this.getFrameName();
        }
        if (targetFrame.equals("_self")) {
            targetFrame = this.getFrameName();
        } else if (targetFrame.equals("_parent")) {
            targetFrame = "_self";
        }
        if (this.flagDocWithFrames) {
            DocFrameInfo df = this.mainFrameset.findDocFrame(targetFrame);
            if (df != null) {
                if (this.backHistory.size() == 0 && this.fwdHistory.empty()) {
                    this.backHistory.push(new HistoryEntry(df.getFrameSrc(), targetFrame));
                }
                df.setFrameSrc(url, outputString);
                df.showDocument(this);
                df.doLayout();
                if (flagUpdateHistory) {
                    if (!this.fwdHistory.empty()) {
                        this.fwdHistory.removeAllElements();
                    }
                    this.backHistory.push(new HistoryEntry(url, targetFrame));
                }
            } else if (this.getParentDocument() != null) {
                this.getParentDocument().setReferer(this.getDocumentBase());
                this.getParentDocument().gotoLocation(url, targetFrame, outputString);
            } else if (this.getBrowserContext() != null) {
                this.getBrowserContext().setReferer(this.getDocumentBase());
                this.getBrowserContext().gotoLocation(url, targetFrame, outputString);
            }
        } else {
            URL u = this.doc.getDocumentBase();
            if (targetFrame == this.getFrameName() && u.getProtocol().equals(url.getProtocol()) && u.getHost().equals(url.getHost()) && u.getPort() == url.getPort() && u.getFile().equals(url.getFile()) && outputString == null) {
                this.doc.setDocumentBase(url);
                Point p = this.doc.getAnchorPosition(url);
                if (p != null) {
                    this.scrollTo(p.x, p.y);
                    if (flagUpdateHistory) {
                        if (!this.fwdHistory.empty()) {
                            this.fwdHistory.removeAllElements();
                        }
                        this.backHistory.push(new HistoryEntry(url, p));
                    }
                }
            } else if (this.getParentDocument() != null) {
                this.getParentDocument().setReferer(this.getDocumentBase());
                this.getParentDocument().gotoLocation(url, targetFrame, outputString);
            } else if (this.getBrowserContext() != null) {
                this.getBrowserContext().setReferer(this.getDocumentBase());
                this.getBrowserContext().gotoLocation(url, targetFrame, outputString);
            }
        }
    }

    void updateTitle(String str) {
        BrowserContext bc;
        if (this.getParentDocument() == null && (bc = this.getBrowserContext()) != null) {
            bc.updateTitle(str);
        }
    }

    void updateCurrentURL() {
        BrowserContext bc;
        if (this.getParentDocument() == null && (bc = this.getBrowserContext()) != null) {
            bc.updateCurrentURL();
        }
    }

    private Document getParentDocument() {
        for (Container c = this.getParent(); c != null; c = c.getParent()) {
            if (!(c instanceof Document)) continue;
            return (Document)c;
        }
        return null;
    }

    public void setReferer(URL ref) {
        this.referer = ref;
    }

    public URL getReferer() {
        return this.referer;
    }

    public void printDoc(PrintJob pj) {
        DocumentTracker dt = new DocumentTracker();
        dt.addDocument(this);
        try {
            dt.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Dimension docSz = this.doc.docSize();
        Rectangle page = new Rectangle(pj.getPageDimension());
        Rectangle clipPage = new Rectangle(page);
        page.height -= 100;
        int numPages = 1 + docSz.height / page.height;
        for (int p = 0; p < numPages; ++p) {
            Graphics thisPage = pj.getGraphics();
            thisPage.setClip(clipPage);
            thisPage.translate(0, -p * page.height);
            System.out.println(String.valueOf(String.valueOf(String.valueOf("printing page ").concat(String.valueOf(p + 1))).concat(String.valueOf(" of "))).concat(String.valueOf(numPages)));
            this.doc.printAll(thisPage);
            thisPage.dispose();
        }
        System.out.println("printing completed");
    }

    BrowserContext getBrowserContext() {
        for (Container c = this.getParent(); c != null; c = c.getParent()) {
            if (!(c instanceof BrowserContext)) continue;
            return (BrowserContext)((Object)c);
        }
        return null;
    }

    public void setMarginWidth(int m) {
        this.marginWidth = m;
    }

    public int getMarginWidth() {
        return this.marginWidth;
    }

    public void setMarginHeight(int m) {
        this.marginHeight = m;
    }

    public int getMarginHeight() {
        return this.marginHeight;
    }

    public void writeExternal(ObjectOutput out) {
        try {
            System.out.println("Serializing Document...");
            out.writeObject(this.doc);
        }
        catch (IOException ioe) {
            System.err.println("Document: cannot serialize properties");
            System.err.println(String.valueOf("          ").concat(String.valueOf(ioe.getMessage())));
        }
    }

    public void readExternal(ObjectInput in) {
        try {
            System.out.println("DeSerializing Document...");
            this.remove(this.doc);
            this.doc = (DocContainer)in.readObject();
            this.doc.setParentDocument(this);
            this.add("Center", this.doc);
            this.doc.htmlStart();
        }
        catch (Exception ioe) {
            System.err.println("Document: cannot read serialized properties");
            System.err.println(String.valueOf("          ").concat(String.valueOf(ioe.getMessage())));
        }
    }

    public Adjustable getHScrollbar() {
        return this.scrollH;
    }

    public Adjustable getVScrollbar() {
        return this.scrollV;
    }

    static {
        try {
            System.setSecurityManager(new BrowserSecurityManager());
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        boolean allowed = true;
        try {
            SecurityManager sec = System.getSecurityManager();
            if (sec != null) {
                sec.checkPropertyAccess("http.agent");
            }
        }
        catch (SecurityException se) {
            allowed = false;
        }
        if (allowed) {
            try {
                Properties props = new Properties(System.getProperties());
                String agentName = props.getProperty("http.agent", String.valueOf(String.valueOf("ICE Browser ").concat(String.valueOf(Browser.theVersion))).concat(String.valueOf(" (Java)")));
                ((Hashtable)props).put("http.agent", agentName);
                System.setProperties(props);
            }
            catch (SecurityException se) {
                System.err.println(String.valueOf(String.valueOf(String.valueOf("RELAX - if you got a SecurityException here its because you're running inside another tool\n     It doesn't matter, I just tried to set the http agent\n     name to ICE Browser ").concat(String.valueOf(Browser.theVersion))).concat(String.valueOf(" (Java)\n"))).concat(String.valueOf("     Thats all")));
            }
        }
        documentCustomizerList = new Vector();
        defaultFontInfo = new FontInfo();
    }
}

