/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.MsgBox;
import innoval.mailer.SelectAccount;
import innoval.mailer.jstreet;
import java.awt.CheckboxMenuItem;
import java.awt.Frame;
import java.awt.Menu;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;

public class AccountIndex {
    private File file;
    private File indexDir;
    private jstreet parent;

    AccountIndex(jstreet parent, String dir, String name) {
        this.parent = parent;
        this.indexDir = new File(dir);
        this.file = new File(dir, name);
    }

    public boolean exists() {
        return this.file.exists();
    }

    public void add(String text) {
        int index = -1;
        String[] recs = new String[]{};
        try {
            if (this.file.exists()) {
                BufferedReader in = new BufferedReader(new FileReader(this.file));
                recs = this.ReadAllLines(in);
                in.close();
            }
            BufferedWriter out = new BufferedWriter(new FileWriter(this.file));
            for (int i = 0; i < recs.length; ++i) {
                if (index == -1 && recs[i].trim().length() > 0 && recs[i].charAt(0) == '~') {
                    out.write(String.valueOf(text).concat(String.valueOf("\n")));
                    index = i;
                    continue;
                }
                out.write(String.valueOf(recs[i]).concat(String.valueOf("\n")));
            }
            if (index == -1) {
                index = recs.length;
                out.write(String.valueOf(text).concat(String.valueOf("\n")));
            }
            out.close();
        }
        catch (IOException e) {
            MsgBox msgBox = new MsgBox(this.parent, String.valueOf("Error").concat(String.valueOf(e)));
        }
    }

    public void delete(String account) {
        String[] recs = new String[]{};
        try {
            int i;
            if (this.file.exists()) {
                BufferedReader in = new BufferedReader(new FileReader(this.file));
                recs = this.ReadAllLines(in);
                in.close();
            }
            for (i = 0; i < recs.length; ++i) {
                if (account.compareTo(recs[i]) != 0) continue;
                if (recs[i].indexOf(File.separator) < 0) {
                    AccountIndex.deleteFiles(new File(String.valueOf(String.valueOf(this.indexDir).concat(String.valueOf(File.separator))).concat(String.valueOf(jstreet.MAILDATA)), recs[i]));
                } else {
                    this.deleteSettings(recs[i]);
                }
                recs[i] = new String(String.valueOf("~").concat(String.valueOf(recs[i])));
            }
            BufferedWriter out = new BufferedWriter(new FileWriter(this.file));
            for (i = 0; i < recs.length; ++i) {
                out.write(String.valueOf(recs[i]).concat(String.valueOf("\n")));
            }
            out.close();
        }
        catch (IOException e) {
            MsgBox msgBox = new MsgBox(this.parent, String.valueOf("Error").concat(String.valueOf(e)));
        }
    }

    public void deleteSettings(String dir) {
        File file = new File(dir, jstreet.PROFILENAME);
        if (file.exists()) {
            file.delete();
        }
    }

    public String[] ReadAllLines(BufferedReader in) {
        String text = null;
        String[] recs = new String[]{};
        int lines = 0;
        try {
            in.mark(102400);
            do {
                if ((text = in.readLine()) == null) continue;
                ++lines;
            } while (text != null);
            in.reset();
            recs = new String[lines];
            for (int i = 0; i < lines; ++i) {
                recs[i] = in.readLine();
            }
        }
        catch (IOException e) {
            MsgBox msgBox = new MsgBox(this.parent, String.valueOf("Error").concat(String.valueOf(e)));
        }
        return recs;
    }

    public void addAccounts(Menu menuAccount, String account) {
        block5: {
            String[] recs = new String[]{};
            try {
                if (this.file.exists()) {
                    BufferedReader in = new BufferedReader(new FileReader(this.file));
                    recs = this.ReadAllLines(in);
                    in.close();
                }
                if (recs.length <= 0) break block5;
                for (int i = 0; i < recs.length; ++i) {
                    if (recs[i].trim().length() <= 0 || recs[i].charAt(0) == '~' || !this.checkAccount(recs[i])) continue;
                    CheckboxMenuItem item = new CheckboxMenuItem(recs[i]);
                    item.setActionCommand(String.valueOf("Account: ").concat(String.valueOf(i)));
                    item.addItemListener(this.parent);
                    if (account.toLowerCase().compareTo(recs[i].toLowerCase()) == 0) {
                        item.setState(true);
                    }
                    menuAccount.add(item);
                }
            }
            catch (IOException e) {
                MsgBox msgBox = new MsgBox(this.parent, String.valueOf("Error").concat(String.valueOf(e)));
            }
        }
    }

    private boolean checkAccount(String text) {
        boolean ret_code = false;
        File dir = null;
        dir = text.length() > 1 && text.charAt(1) == ':' ? new File(text) : new File(this.parent.getAllAccountDir(), text);
        ret_code = dir.exists();
        return ret_code;
    }

    public boolean exists(String account) {
        boolean ret_code;
        block5: {
            File setfile;
            File dir;
            block4: {
                ret_code = false;
                String[] recs = new String[]{};
                try {
                    if (this.file.exists()) {
                        BufferedReader in = new BufferedReader(new FileReader(this.file));
                        recs = this.ReadAllLines(in);
                        in.close();
                    }
                    if (recs.length <= 0) break block4;
                    for (int i = 0; i < recs.length; ++i) {
                        if (recs[i].trim().length() <= 0 || recs[i].charAt(0) == '~' || account.toLowerCase().compareTo(recs[i].toLowerCase()) != 0) continue;
                        ret_code = this.validAccount(recs[i]);
                        break;
                    }
                }
                catch (IOException e) {
                    MsgBox msgBox = new MsgBox(this.parent, String.valueOf("Error").concat(String.valueOf(e)));
                }
            }
            if (ret_code || !(dir = new File(account)).exists() || !dir.isDirectory() || !(setfile = new File(dir, jstreet.PROFILENAME)).exists()) break block5;
            ret_code = true;
        }
        return ret_code;
    }

    public boolean validAccount(String account) {
        boolean ret_code = false;
        File path = null;
        path = account.indexOf(File.separator) >= 0 ? new File(account) : new File(this.parent.getAllAccountDir(), account);
        if (path.exists()) {
            ret_code = true;
        }
        return ret_code;
    }

    public String get(int index) {
        String[] recs = new String[]{};
        String text = new String("");
        try {
            if (this.file.exists()) {
                BufferedReader in = new BufferedReader(new FileReader(this.file));
                recs = this.ReadAllLines(in);
                in.close();
            }
            if (index < recs.length) {
                text = new String(recs[index]);
            }
        }
        catch (IOException e) {
            MsgBox msgBox = new MsgBox(this.parent, String.valueOf("Error").concat(String.valueOf(e)));
        }
        return text;
    }

    public static boolean deleteFiles(File dir) {
        boolean ret_code;
        block2: {
            ret_code = true;
            String[] names = new String[]{};
            names = dir.list();
            if (names != null) {
                File file;
                for (int i = 0; i < names.length && (ret_code = (file = new File(dir, names[i])).isDirectory() ? AccountIndex.deleteFiles(file) : file.delete()); ++i) {
                }
            }
            if (!ret_code) break block2;
            ret_code = dir.delete();
        }
        return ret_code;
    }

    public String select(Frame frame) {
        return this.select(frame, false);
    }

    public String select(Frame frame, boolean force) {
        String account = new String("");
        SelectAccount selectaccount = new SelectAccount(frame, this, this.file, new File(this.indexDir, jstreet.MAILDATA).getAbsolutePath(), force);
        selectaccount.show();
        if (selectaccount.ret_code) {
            account = selectaccount.getAccount();
            if (selectaccount.newaccount) {
                this.add(account);
            }
        }
        return account;
    }

    public Vector getAccounts() {
        Vector<String> vector;
        block4: {
            vector = new Vector<String>();
            String[] recs = new String[]{};
            try {
                if (this.file.exists()) {
                    BufferedReader in = new BufferedReader(new FileReader(this.file));
                    recs = this.ReadAllLines(in);
                    in.close();
                }
                if (recs.length <= 0) break block4;
                for (int i = 0; i < recs.length; ++i) {
                    if (recs[i].trim().length() <= 0 || recs[i].charAt(0) == '~') continue;
                    vector.addElement(recs[i]);
                }
            }
            catch (IOException e) {
                MsgBox msgBox = new MsgBox(this.parent, String.valueOf("Error").concat(String.valueOf(e)));
            }
        }
        return vector;
    }
}

