/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.AddrBook;
import innoval.mailer.AddressBook;
import innoval.mailer.jstreet;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;

public class AddrBookSettings
extends Dialog
implements KeyListener,
ActionListener {
    private Frame frame;
    private AddrBook addrbook;
    private AddressBook book;
    private Button okButton;
    private Button cancelButton;
    private boolean ret_code = false;
    private TextField booknickText;
    private TextField domainText;
    private Checkbox firstwordButton;
    private Checkbox lastwordButton;
    private CheckboxGroup sortGroup;

    AddrBookSettings(Frame frame, AddrBook addrbook, AddressBook book) {
        super(frame, "Address Book Settings", true);
        this.addrbook = addrbook;
        this.book = book;
        this.setupDialog();
    }

    public void setupDialog() {
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{5, 20, 5, 20, 20, 5, 20, 15, 20, 5};
        int[] columnWidths = new int[]{5, 60, 5, 60, 5, 150, 5};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        Label label = new Label("Book Nickname", 2);
        this.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 1;
        con.gridwidth = 3;
        grid.setConstraints(label, con);
        this.booknickText = new TextField(this.book.getBookNickname());
        this.add(this.booknickText);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 1;
        grid.setConstraints(this.booknickText, con);
        label = new Label("Name Sorting", 2);
        this.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 3;
        con.gridwidth = 3;
        grid.setConstraints(label, con);
        this.sortGroup = new CheckboxGroup();
        this.firstwordButton = new Checkbox("First Word", this.sortGroup, false);
        this.add(this.firstwordButton);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 3;
        grid.setConstraints(this.firstwordButton, con);
        this.lastwordButton = new Checkbox("Last Word", this.sortGroup, false);
        this.add(this.lastwordButton);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 4;
        grid.setConstraints(this.lastwordButton, con);
        if (this.book.getSortStyle() == 0) {
            this.firstwordButton.setState(true);
        } else {
            this.lastwordButton.setState(true);
        }
        label = new Label("Default Domain", 2);
        this.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 6;
        con.gridwidth = 3;
        grid.setConstraints(label, con);
        String domain = this.book.getBookDomain();
        if (!domain.startsWith("@")) {
            domain = new String(String.valueOf('@').concat(String.valueOf(domain)));
        }
        this.domainText = new TextField(domain);
        this.add(this.domainText);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 6;
        grid.setConstraints(this.domainText, con);
        this.okButton = new Button("OK");
        this.okButton.addActionListener(this);
        this.okButton.addKeyListener(this);
        this.add(this.okButton);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 8;
        grid.setConstraints(this.okButton, con);
        this.cancelButton = new Button("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.addKeyListener(this);
        this.add(this.cancelButton);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 8;
        grid.setConstraints(this.cancelButton, con);
        this.setLayout(grid);
        this.pack();
        jstreet.centerDialog(this, this.frame);
        this.setResizable(false);
        this.enableEvents(64L);
    }

    public boolean getReturn() {
        return this.ret_code;
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            Button evt = this.okButton;
            if (e.getSource() == this.cancelButton) {
                evt = this.cancelButton;
            }
            ActionEvent ae = new ActionEvent(evt, 1001, "");
            this.actionPerformed(ae);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.book.setBookNickname(this.booknickText.getText());
            this.book.setBookDomain(this.domainText.getText());
            if (this.firstwordButton.getState()) {
                this.book.setSortStyle(0);
            } else {
                this.book.setSortStyle(1);
            }
            this.ret_code = true;
            this.book.save();
            this.addrbook.requestFocus();
            this.dispose();
        } else if (e.getSource() == this.cancelButton) {
            this.addrbook.requestFocus();
            this.dispose();
        }
    }

    public void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 201) {
            this.addrbook.requestFocus();
            this.dispose();
        } else {
            super.processWindowEvent(evt);
        }
    }
}

