/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.AddrBook;
import innoval.mailer.Address;
import innoval.mailer.AddressGroup;
import innoval.mailer.AddressNickname;
import innoval.mailer.AddressSort;
import innoval.mailer.GroupSort;
import innoval.mailer.MsgBox;
import innoval.mailer.Profile;
import innoval.mailer.SendItem;
import innoval.mailer.SortVector;
import innoval.mailer.jstreet;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;

public class AddressBook {
    private Frame frame;
    private jstreet Jstreet;
    private boolean isPublic;
    private File file;
    private int sortStyle;
    private int sortType;
    private Vector addrVector;
    private Vector nickVector;
    private Vector groupnickVector;
    private Vector groupVector;
    private String name;
    private String folderName;
    private String booknickname;
    private String bookdomain;

    public AddressBook(Frame frame, String name, File file, Vector addrVector) {
        this.frame = frame;
        this.file = file;
        this.name = name;
        this.booknickname = name;
        this.bookdomain = new String("");
        this.folderName = new String("");
        this.addrVector = addrVector;
        this.groupVector = null;
    }

    AddressBook(jstreet Jstreet, File file, boolean isPublic) {
        this.Jstreet = Jstreet;
        this.file = file;
        this.isPublic = isPublic;
        this.init();
    }

    AddressBook(Frame frame, jstreet Jstreet, File file) {
        this.frame = frame;
        this.Jstreet = Jstreet;
        this.file = file;
        this.init();
    }

    public static AddressBook defaultAddressBook(jstreet parent, Profile profile) {
        AddressBook addrbook = null;
        String file = profile.ReadString(AddrBook.SAVENAME, AddrBook.LASTBOOK, "");
        if (file.length() > 0) {
            File tfile;
            if (file.indexOf(58) < 0) {
                file = new String(String.valueOf(parent.getSystemDir()).concat(String.valueOf(file)));
            }
            if ((tfile = new File(file)).exists()) {
                addrbook = new AddressBook((Frame)parent, parent, new File(file));
            }
        }
        if (addrbook != null) {
            addrbook.read();
        }
        return addrbook;
    }

    public boolean exists() {
        boolean ret_code = false;
        if (this.file != null) {
            ret_code = this.file.exists();
        }
        return ret_code;
    }

    private void init() {
        this.name = new String(this.file.getName());
        this.name = new String(this.name.substring(0, this.name.indexOf(46)));
        this.sortStyle = 0;
        this.sortType = 0;
        this.booknickname = new String("");
        this.bookdomain = new String("");
        this.addrVector = new Vector();
        this.groupVector = new Vector();
        this.nickVector = new Vector();
        this.groupnickVector = new Vector();
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    public void setPublic(boolean val) {
        this.isPublic = val;
    }

    public String getFileName() {
        return this.file.getAbsolutePath();
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        String text = null;
        text = this.isPublic ? new String(String.valueOf(this.name).concat(String.valueOf(" [Public]"))) : new String(String.valueOf(this.name).concat(String.valueOf(" [Private]")));
        return text;
    }

    public int getSortStyle() {
        return this.sortStyle;
    }

    public void setSortStyle(int sortStyle) {
        this.sortStyle = sortStyle;
    }

    public int getSortType() {
        return this.sortType;
    }

    public void setSortType(int sortType) {
        this.sortType = sortType;
        this.save();
    }

    public String getBookNickname() {
        return this.booknickname;
    }

    public void setBookNickname(String booknickname) {
        this.booknickname = new String(booknickname);
    }

    public String getBookDomain() {
        return this.bookdomain;
    }

    public void setBookDomain(String bookdomain) {
        if (!bookdomain.startsWith("@")) {
            bookdomain = new String(String.valueOf("@").concat(String.valueOf(bookdomain)));
        }
        this.bookdomain = new String(bookdomain);
    }

    public Address getAddress(int n) {
        Address address = null;
        if (n >= 0 && n < this.addrVector.size()) {
            address = (Address)this.addrVector.elementAt(n);
        }
        return address;
    }

    public String getNickname(int n) {
        String text = "";
        if (n >= 0 && n < this.nickVector.size()) {
            text = (String)this.nickVector.elementAt(n);
        }
        return text;
    }

    public int addressSize() {
        return this.addrVector.size();
    }

    public boolean removeAddress(Address addr) {
        boolean ret_code = false;
        if (this.addrVector.size() > 0) {
            ret_code = true;
            this.nickVector.removeElement(addr.nickname.toUpperCase().trim());
            int ind = this.addrVector.indexOf(addr);
            this.addrVector.removeElement(addr);
            if (ind >= 0 && ind < this.addrVector.size()) {
                for (int i = ind; i < this.addrVector.size(); ++i) {
                    --((Address)this.addrVector.elementAt((int)i)).listindex;
                }
            }
        }
        return ret_code;
    }

    public void addAddress(Address address) {
        this.addrVector.addElement(address);
        this.nickVector.addElement(address.nickname.toUpperCase().trim());
    }

    public void sortAddresses(int style) {
        SortVector sortvector = new SortVector(this.addrVector, new AddressSort(style, this.sortStyle));
        Address addr = null;
        this.nickVector.removeAllElements();
        for (int i = 0; i < this.addrVector.size(); ++i) {
            addr = (Address)this.addrVector.elementAt(i);
            this.nickVector.addElement(addr.nickname.toUpperCase().trim());
        }
    }

    public int addressIndexOf(Address addr) {
        return this.addrVector.indexOf(addr);
    }

    public int nickIndexOf(String check) {
        return this.nickVector.indexOf(check);
    }

    public void updateNickname(String old, String val) {
        int ind;
        if (this.nickVector.size() > 0 && (ind = this.nickVector.indexOf(old.toUpperCase().trim())) >= 0) {
            this.nickVector.setElementAt(val.toUpperCase().trim(), ind);
        }
    }

    public void changeGroupNickname(String old, String val) {
        AddressGroup group = null;
        old = new String(old.toUpperCase().trim());
        val = new String(val.toUpperCase().trim());
        for (int i = 0; i < this.groupVector.size(); ++i) {
            group = (AddressGroup)this.groupVector.elementAt(i);
            group.changeGroupNickname(old, val);
        }
    }

    public AddressGroup getGroup(int n) {
        AddressGroup group = null;
        if (n >= 0 && n < this.groupVector.size()) {
            group = (AddressGroup)this.groupVector.elementAt(n);
        }
        return group;
    }

    public int groupSize() {
        return this.groupVector.size();
    }

    public boolean removeGroup(AddressGroup group) {
        boolean ret_code = false;
        if (this.groupVector.size() > 0) {
            ret_code = true;
            String nick = group.getNickname().toUpperCase().trim();
            this.groupnickVector.removeElement(nick);
            int ind = this.groupVector.indexOf(group);
            this.groupVector.removeElement(group);
            if (ind >= 0 && ind < this.addrVector.size()) {
                for (int i = ind; i < this.groupVector.size(); ++i) {
                    ((AddressGroup)this.groupVector.elementAt(i)).decListIndex();
                }
            }
        }
        return ret_code;
    }

    public void addGroup(AddressGroup group) {
        this.groupVector.addElement(group);
        this.groupnickVector.addElement(group.getNickname().toUpperCase().trim());
    }

    public void updateGroupNickname(int ind, String val) {
        if (ind >= 0 && ind < this.groupnickVector.size()) {
            this.groupnickVector.setElementAt(val.toUpperCase().trim(), ind);
        }
    }

    public void sortGroups() {
        SortVector sortvector = new SortVector(this.groupVector, new GroupSort());
    }

    public boolean read() {
        boolean ret_code = true;
        BufferedReader in = null;
        String buffer = null;
        this.init();
        try {
            if (this.file.exists()) {
                in = new BufferedReader(new FileReader(this.file));
                buffer = in.readLine();
                if (buffer != null && buffer.indexOf(AddrBook.ADDRBOOKMARKER) > 0) {
                    ret_code = this.readLocalBook(in);
                }
                in.close();
            }
        }
        catch (IOException e) {
            MsgBox box = new MsgBox(this.frame, String.valueOf("Address book error: ").concat(String.valueOf(e)));
            ret_code = false;
        }
        return ret_code;
    }

    public boolean readLocalBook(BufferedReader in) throws IOException {
        String buffer;
        boolean ret_code = true;
        boolean table = false;
        boolean groups = false;
        Address addr = null;
        AddressGroup group = null;
        int cnt = 0;
        do {
            if ((buffer = in.readLine()) == null) continue;
            if (!table && !groups && buffer.startsWith("<P><B>")) {
                if ((buffer = new String(buffer.substring(6))).startsWith("NICKNAME:</B> ")) {
                    this.booknickname = new String(buffer.substring(14));
                    continue;
                }
                if (buffer.startsWith("DOMAIN:</B> ")) {
                    this.bookdomain = new String(buffer.substring(12));
                    continue;
                }
                if (buffer.startsWith("SORTSTYLE:</B> ")) {
                    this.sortStyle = Integer.valueOf(buffer.substring(15));
                    continue;
                }
                if (!buffer.startsWith("SORTTYPE:</B> ")) continue;
                this.sortType = Integer.valueOf(buffer.substring(14));
                continue;
            }
            if (buffer.startsWith("<TABLE ")) {
                table = true;
                continue;
            }
            if (buffer.startsWith("</TABLE>")) {
                table = false;
                groups = true;
                continue;
            }
            if (table && buffer.startsWith("<TR VALIGN")) {
                addr = new Address();
                cnt = 0;
                continue;
            }
            if (table && addr != null && buffer.startsWith("<TD>")) {
                this.parseAddressLine(buffer, addr, cnt++);
                continue;
            }
            if (table && addr != null && buffer.startsWith("</TR>")) {
                this.addAddress(addr);
                addr = null;
                continue;
            }
            if (groups && buffer.startsWith("<P><B>")) {
                group = new AddressGroup(buffer);
                if (group.getName().length() > 0) {
                    this.addGroup(group);
                    continue;
                }
                group = null;
                continue;
            }
            if (!groups || group == null || !buffer.startsWith("<LI>")) continue;
            group.add(buffer.substring(4).trim());
        } while (buffer != null);
        return ret_code;
    }

    public void parseAddressLine(String buffer, Address addr, int num) {
        int spot = 0;
        if ((buffer = new String(buffer.substring(4))).startsWith("<B>")) {
            buffer = new String(buffer.substring(3));
        }
        if ((spot = buffer.indexOf("</B>")) < 0) {
            spot = buffer.indexOf("</TD>");
        }
        if (spot >= 0) {
            buffer = new String(buffer.substring(0, spot));
        }
        switch (num) {
            case 0: {
                addr.nickname = new String(buffer);
                break;
            }
            case 1: {
                addr.email = new String(buffer);
                break;
            }
            case 2: {
                addr.fullname = new String(buffer);
                break;
            }
            case 3: {
                addr.groups = new String(buffer);
                break;
            }
            case 4: {
                addr.alert = new String(buffer);
                break;
            }
            case 5: {
                addr.folder = new String(buffer);
                break;
            }
            case 6: {
                addr.notes = new String(AddressBook.removeBreaks(buffer));
                break;
            }
            case 7: {
                addr.title = new String(buffer);
                break;
            }
            case 8: {
                addr.org = new String(buffer);
                break;
            }
            case 9: {
                addr.postal = new String(AddressBook.removeBreaks(buffer));
                break;
            }
            case 10: {
                addr.phone = new String(buffer);
                break;
            }
            case 11: {
                addr.fax = new String(buffer);
                break;
            }
            case 12: {
                addr.shortlist = Boolean.valueOf(buffer);
            }
        }
    }

    public static String removeBreaks(String ttext) {
        String text = new String(ttext);
        int spot = 0;
        do {
            if ((spot = text.indexOf("<BR>")) < 0) continue;
            text = new String(String.valueOf(String.valueOf(text.substring(0, spot)).concat(String.valueOf("\n"))).concat(String.valueOf(text.substring(spot + 4))));
        } while (spot >= 0);
        return text;
    }

    public boolean save() {
        boolean ret_code = true;
        BufferedWriter out = null;
        Address addr = null;
        AddressGroup group = null;
        int i = 0;
        if (this.file != null) {
            try {
                out = new BufferedWriter(new FileWriter(this.file));
                out.write(String.valueOf(String.valueOf("<HTML><!-- ").concat(String.valueOf(AddrBook.ADDRBOOKMARKER))).concat(String.valueOf(" -->\n")));
                out.write("<HEAD><TITLE>J Street Address Book</TITLE></HEAD><BODY>\n");
                out.write(String.valueOf(String.valueOf("<P><B>NICKNAME:</B> ").concat(String.valueOf(this.booknickname))).concat(String.valueOf("\n")));
                out.write(String.valueOf(String.valueOf("<P><B>DOMAIN:</B> ").concat(String.valueOf(this.bookdomain))).concat(String.valueOf("\n")));
                out.write(String.valueOf(String.valueOf("<P><B>SORTSTYLE:</B> ").concat(String.valueOf(this.sortStyle))).concat(String.valueOf("\n")));
                out.write(String.valueOf(String.valueOf("<P><B>SORTTYPE:</B> ").concat(String.valueOf(this.sortType))).concat(String.valueOf("\n")));
                out.write("<TABLE BORDER=1 CELLPADDING=4>\n");
                out.write("<TH>Nickname</TH>\n");
                out.write("<TH>Email Address</TH>\n");
                out.write("<TH>Full Name</TH>\n");
                out.write("<TH>Groups</TH>\n");
                out.write("<TH>Alert</TH>\n");
                out.write("<TH>Folder</TH>\n");
                out.write("<TH>Notes</TH>\n");
                out.write("<TH>Title</TH>\n");
                out.write("<TH>Organization</TH>\n");
                out.write("<TH>Postal Address</TH>\n");
                out.write("<TH>Phone Number</TH>\n");
                out.write("<TH>Fax Number</TH>\n");
                out.write("<TH>Short List</TH>\n");
                if (this.addrVector != null) {
                    for (i = 0; i < this.addrVector.size(); ++i) {
                        addr = (Address)this.addrVector.elementAt(i);
                        if (addr == null) continue;
                        this.writeAddressRecord(out, addr);
                    }
                }
                out.write("</TABLE>\n");
                if (this.groupVector != null) {
                    for (i = 0; i < this.groupVector.size(); ++i) {
                        group = (AddressGroup)this.groupVector.elementAt(i);
                        if (group == null) continue;
                        this.writeAddressGroup(out, group);
                    }
                }
                out.write("</BODY></HTML>\n");
                out.close();
            }
            catch (IOException e) {
                MsgBox box = new MsgBox(this.frame, String.valueOf("Address book error: ").concat(String.valueOf(e)));
                ret_code = false;
            }
        } else {
            MsgBox box = new MsgBox(this.frame, "Error: No name has been given to this address book.");
            ret_code = false;
        }
        return ret_code;
    }

    public void writeAddressRecord(BufferedWriter out, Address addr) throws IOException {
        out.write("<TR VALIGN=TOP>\n");
        out.write(String.valueOf(String.valueOf("<TD><B>").concat(String.valueOf(addr.nickname))).concat(String.valueOf("</B></TD>\n")));
        out.write(String.valueOf(String.valueOf("<TD>").concat(String.valueOf(addr.email))).concat(String.valueOf("</TD>\n")));
        out.write(String.valueOf(String.valueOf("<TD>").concat(String.valueOf(addr.fullname))).concat(String.valueOf("</TD>\n")));
        out.write(String.valueOf(String.valueOf("<TD>").concat(String.valueOf(addr.groups))).concat(String.valueOf("</TD>\n")));
        out.write(String.valueOf(String.valueOf("<TD>").concat(String.valueOf(addr.alert))).concat(String.valueOf("</TD>\n")));
        out.write(String.valueOf(String.valueOf("<TD>").concat(String.valueOf(addr.folder))).concat(String.valueOf("</TD>\n")));
        out.write(String.valueOf(String.valueOf("<TD>").concat(String.valueOf(AddressBook.addBreaks(addr.notes)))).concat(String.valueOf("</TD>\n")));
        out.write(String.valueOf(String.valueOf("<TD>").concat(String.valueOf(addr.title))).concat(String.valueOf("</TD>\n")));
        out.write(String.valueOf(String.valueOf("<TD>").concat(String.valueOf(addr.org))).concat(String.valueOf("</TD>\n")));
        out.write(String.valueOf(String.valueOf("<TD>").concat(String.valueOf(AddressBook.addBreaks(addr.postal)))).concat(String.valueOf("</TD>\n")));
        out.write(String.valueOf(String.valueOf("<TD>").concat(String.valueOf(addr.phone))).concat(String.valueOf("</TD>\n")));
        out.write(String.valueOf(String.valueOf("<TD>").concat(String.valueOf(addr.fax))).concat(String.valueOf("</TD>\n")));
        out.write(String.valueOf(String.valueOf("<TD>").concat(String.valueOf(addr.shortlist))).concat(String.valueOf("</TD>\n")));
        out.write("</TR>\n");
    }

    public void writeAddressGroup(BufferedWriter out, AddressGroup group) throws IOException {
        String val = "";
        if (group.getShortlist()) {
            val = new String("shortlist");
        }
        out.write(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("<P><B>").concat(String.valueOf(group.getName()))).concat(String.valueOf("</B> ["))).concat(String.valueOf(group.getNickname()))).concat(String.valueOf("] "))).concat(String.valueOf(val))).concat(String.valueOf("\n<UL>\n")));
        for (int i = 0; i < group.size(); ++i) {
            out.write(String.valueOf(String.valueOf("<LI>").concat(String.valueOf(group.get(i)))).concat(String.valueOf("\n")));
        }
        out.write("</UL>\n");
    }

    public static String addBreaks(String ttext) {
        String text = "";
        int spot = 0;
        if (ttext != null) {
            text = new String(ttext);
        }
        do {
            if ((spot = text.indexOf(10)) < 0) continue;
            text = text.length() > spot + 1 ? new String(String.valueOf(String.valueOf(text.substring(0, spot)).concat(String.valueOf("<BR>"))).concat(String.valueOf(text.substring(spot + 1)))) : new String(String.valueOf(text.substring(0, spot)).concat(String.valueOf("<BR>")));
        } while (spot >= 0);
        return text;
    }

    public String formatAddress(Address addr) {
        boolean news = false;
        String text = "";
        String email = "";
        email = new String(addr.email);
        news = SendItem.isNewsCategory(email);
        if (!news && email.indexOf(64) < 0) {
            email = new String(String.valueOf(email).concat(String.valueOf(this.bookdomain)));
        }
        text = !news && addr.fullname.length() > 0 ? (addr.fullname.trim().charAt(0) != '\"' && (addr.fullname.indexOf(46) >= 0 || addr.fullname.indexOf(44) >= 0) ? new String(String.valueOf(String.valueOf(String.valueOf(String.valueOf("\"").concat(String.valueOf(addr.fullname))).concat(String.valueOf("\" <"))).concat(String.valueOf(email))).concat(String.valueOf('>'))) : new String(String.valueOf(String.valueOf(String.valueOf(addr.fullname).concat(String.valueOf(" <"))).concat(String.valueOf(email))).concat(String.valueOf('>')))) : new String(email);
        return text;
    }

    public Address lookupTheNickname(String nick) {
        int ind = this.nickIndexOf(nick.toUpperCase().trim());
        Address addr = null;
        if (ind >= 0) {
            addr = this.getAddress(ind);
        }
        return addr;
    }

    public AddressGroup lookupGroupNickname(String nick) {
        int ind = this.groupnickVector.indexOf(nick.toUpperCase().trim());
        AddressGroup group = null;
        if (ind >= 0) {
            group = this.getGroup(ind);
        }
        return group;
    }

    public boolean duplicateNickname(String nick) {
        boolean ret_code = false;
        String text = nick.toUpperCase().trim();
        if (this.nickVector.indexOf(text) >= 0 || this.groupnickVector.indexOf(text) >= 0) {
            ret_code = true;
        }
        return ret_code;
    }

    public static AddressNickname lookupNickname(jstreet Jstreet, AddressBook cur, String nick) {
        AddressNickname ret = new AddressNickname(nick, "");
        Address addr = null;
        AddressGroup group = null;
        AddressBook tbook = null;
        AddressBook book = null;
        if (cur != null) {
            cur.setFolderName(null);
            addr = cur.lookupTheNickname(nick);
            if (addr == null) {
                group = cur.lookupGroupNickname(nick);
                if (group == null && cur.getBookNickname().equalsIgnoreCase(nick)) {
                    tbook = cur;
                }
            } else {
                nick = new String(cur.formatAddress(addr));
            }
            if (group != null) {
                book = cur;
            }
        }
        if (addr == null && group == null && tbook == null) {
            Vector bvector = new Vector();
            int i = 0;
            AddrBook.loadAddressBookVector(bvector, Jstreet);
            while (addr == null && group == null && tbook == null && i < bvector.size()) {
                book = null;
                book = (AddressBook)bvector.elementAt(i++);
                if (cur != null && book.getFileName().equalsIgnoreCase(cur.getFileName())) continue;
                book.setFrame(Jstreet);
                book.read();
                addr = book.lookupTheNickname(nick);
                if (addr == null) {
                    group = book.lookupGroupNickname(nick);
                    if (group != null || !book.getBookNickname().equalsIgnoreCase(nick)) continue;
                    tbook = book;
                    continue;
                }
                nick = new String(book.formatAddress(addr));
            }
        }
        if (addr != null) {
            if (cur != null) {
                cur.setFolderName(addr.folder);
            }
            ret.folder = new String(addr.folder);
            ret.name = new String(nick);
        } else if (group != null) {
            nick = new String("");
            for (int i = 0; i < group.size(); ++i) {
                String address = book.resolveNickname(group.get(i));
                if (address == null) continue;
                nick = nick.length() > 0 ? new String(String.valueOf(String.valueOf(nick).concat(String.valueOf(","))).concat(String.valueOf(address))) : new String(address);
            }
            ret.name = new String(nick);
        } else if (tbook != null) {
            nick = new String("");
            for (int i = 0; i < tbook.addressSize(); ++i) {
                String address = new String(tbook.formatAddress(tbook.getAddress(i)));
                if (address == null) continue;
                nick = nick.length() > 0 ? new String(String.valueOf(String.valueOf(nick).concat(String.valueOf(","))).concat(String.valueOf(address))) : new String(address);
            }
            ret.name = new String(nick);
        }
        return ret;
    }

    public void setFolderName(String folderName) {
        this.folderName = folderName == null ? null : new String(folderName);
    }

    public String getFolderName() {
        return this.folderName;
    }

    public String resolveNickname(String nick) {
        String check = new String(nick.toUpperCase().trim());
        String val = null;
        int ind = this.nickIndexOf(check);
        if (ind >= 0 && ind < this.addressSize()) {
            Address addr = this.getAddress(ind);
            val = new String(this.formatAddress(addr));
        }
        return val;
    }

    public boolean checkNickname(String text) {
        boolean ret_code = false;
        ret_code = this.duplicateNickname(text);
        return ret_code;
    }

    public boolean addAddress(String nick, String email, String name, String org, boolean shortlist) {
        boolean ret_code = true;
        Address addr = new Address();
        addr.nickname = new String(nick);
        addr.email = new String(email);
        addr.fullname = new String(name);
        addr.org = new String(org);
        addr.shortlist = shortlist;
        this.addAddress(addr);
        ret_code = this.save();
        return ret_code;
    }
}

