/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.FolderIndex;
import innoval.mailer.FolderIndexItem;
import innoval.mailer.GenPopName;
import innoval.mailer.MsgBox;
import innoval.mailer.PopFilter;
import innoval.mailer.Profile;
import innoval.mailer.jstreet;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import jclass.bwt.JCOutlinerFolderNode;

public class FolderItem
extends JCOutlinerFolderNode {
    static final String SAVENAME = new String("FolderSettings");
    static final String SAVETITLE = new String("Title");
    static final String CURRENTMONTH = new String("<Month>");
    private long index;
    private boolean remote;
    private boolean trash;
    private boolean outbox;
    private boolean inbox;
    private boolean current;
    private boolean virtual;
    private boolean active;
    private String title;
    private File path;
    private jstreet parent;
    public FolderIndex indexfile;
    private FolderItem firstChild;
    private FolderItem next;
    private Profile settings;

    FolderItem(jstreet parent, String dir, String name) {
        super(name);
        this.remote = false;
        this.active = false;
        this.trash = false;
        this.outbox = false;
        this.inbox = false;
        this.current = false;
        this.setLabel(name);
        this.title = new String(name);
        this.path = new File(dir, name);
        this.indexfile = new FolderIndex(parent, this.path.getAbsolutePath());
        if (dir.length() <= 0 || this.path.exists()) {
            // empty if block
        }
        this.parent = parent;
        this.checkForRemote();
    }

    FolderItem(jstreet parent, String dir, String name, FolderItem node) {
        super(name, node);
        this.remote = false;
        this.active = false;
        this.trash = false;
        this.outbox = false;
        this.inbox = false;
        this.current = false;
        this.setLabel(name);
        this.title = new String(name);
        this.path = new File(dir, name);
        this.indexfile = new FolderIndex(parent, this.path.getAbsolutePath());
        if (this.path.exists()) {
            // empty if block
        }
        this.parent = parent;
        this.checkForRemote();
    }

    FolderItem(jstreet parent, File dir, String name, FolderItem node) {
        super(name, node);
        this.setLabel(name);
        this.remote = false;
        this.trash = false;
        this.outbox = false;
        this.inbox = false;
        this.current = false;
        this.path = dir;
        this.indexfile = new FolderIndex(parent, this.path.getAbsolutePath());
        if (this.path.exists()) {
            // empty if block
        }
        this.parent = parent;
        this.title = new String(name);
        this.checkForRemote();
    }

    public File getDir() {
        return this.path;
    }

    public void setVirtual(boolean virtual) {
        this.virtual = virtual;
    }

    public boolean getVirtual() {
        return this.virtual;
    }

    public void deleteSettings() {
        File file = new File(this.path, this.parent.getFolderSettingsName());
        if (file.exists()) {
            file.delete();
        }
    }

    public void checkForRemote() {
        if (!this.path.getAbsolutePath().toLowerCase().startsWith(this.parent.getAccountDir().toLowerCase())) {
            this.setRemote(true);
        }
    }

    public String getName() {
        String text = this.title;
        if (text == null) {
            text = (String)this.getLabel();
        }
        if (text == null) {
            text = new String("");
        }
        return text;
    }

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean val) {
        this.active = val;
    }

    public boolean isCurrent() {
        return this.current;
    }

    public void setCurrent(boolean val) {
        this.current = val;
    }

    public boolean isTrash() {
        return this.trash;
    }

    public void setTrash(boolean val) {
        this.trash = val;
    }

    public boolean isOutbox() {
        return this.outbox;
    }

    public void setOutbox(boolean val) {
        this.outbox = val;
    }

    public boolean isInbox() {
        return this.inbox;
    }

    public void setInbox(boolean val) {
        this.inbox = val;
    }

    public boolean isSpecial() {
        boolean ret_code = false;
        if (this.trash || this.outbox || this.inbox) {
            ret_code = true;
        }
        return ret_code;
    }

    public boolean checkSpecial(File file) {
        boolean ret_code = false;
        String name = file.getName().trim();
        if (name.equalsIgnoreCase(jstreet.INBOX) || name.equalsIgnoreCase(jstreet.OUTBOX) || name.equalsIgnoreCase(jstreet.TRASHBOX)) {
            ret_code = true;
        }
        return ret_code;
    }

    public File getIndex() {
        return this.indexfile.getIndex();
    }

    public FolderIndex getFolderIndex() {
        return this.indexfile;
    }

    public int titleLength() {
        return this.title.length();
    }

    public void setTitle(String text) {
        this.title = new String(text);
    }

    public String getTitle() {
        return this.title;
    }

    public void setPath(String text) {
        this.path = new File(text);
    }

    public File getPath() {
        return this.path;
    }

    public void setIndex(long ind) {
        this.index = ind;
    }

    public boolean copyMessage(String pfile, String dir, FolderIndexItem item) {
        return this.copyMessage(pfile, dir, item, false);
    }

    public boolean copyMessage(String pfile, String dir, FolderIndexItem item, boolean updatelist) {
        boolean ret_code = true;
        CharArrayWriter buffer = new CharArrayWriter(2048);
        File file = new File(dir, pfile);
        FolderIndexItem val = null;
        if (dir.compareTo(this.path.getAbsolutePath()) != 0) {
            File popfile = new File(new GenPopName(this.path.getAbsolutePath()).getName());
            if (!FolderItem.CopyFile(this.parent, file, popfile)) {
                ret_code = false;
            } else {
                if (item != null) {
                    val = item.copy();
                    val.setPopName(popfile.getName().substring(0, 12));
                    this.indexfile.appendToIndexFile(val);
                } else {
                    this.indexfile.appendToIndexFile(popfile);
                }
                if (this.isCurrent() && updatelist) {
                    if (val == null) {
                        this.parent.notelist.AddMessage(popfile);
                    } else {
                        this.parent.notelist.AddMessage(val);
                    }
                }
            }
        }
        return ret_code;
    }

    public static boolean CopyFile(Frame parent, File source, File target) {
        return FolderItem.CopyFile(parent, source, target, false);
    }

    public static boolean CopyFile(Frame parent, File source, File target, boolean stripcr) {
        boolean ret_code = true;
        char[] text = new char[10240];
        int len = 10240;
        int read = 0;
        int bytes = 0;
        long left = 0L;
        try {
            BufferedReader in = new BufferedReader(new FileReader(source.getAbsolutePath()));
            BufferedWriter out = new BufferedWriter(new FileWriter(target.getAbsolutePath()));
            while ((long)read < source.length()) {
                left = source.length() - (long)read;
                if (left < (long)len) {
                    len = (int)left;
                }
                bytes = in.read(text, 0, len);
                read += bytes;
                if (stripcr) {
                    bytes = FolderItem.stripCR(text, bytes);
                }
                out.write(text, 0, bytes);
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            MsgBox msgbox = new MsgBox(parent, String.valueOf("Error").concat(String.valueOf(e)));
            ret_code = false;
        }
        return ret_code;
    }

    public static int stripCR(char[] text, int len) {
        int cnt = 0;
        for (int i = 0; i < len; ++i) {
            if (text[i] == '\r') continue;
            text[cnt++] = text[i];
        }
        return cnt;
    }

    public void setFirstChild(FolderItem child) {
        this.firstChild = child;
    }

    public FolderItem getFirstChild() {
        return this.firstChild;
    }

    public void setNext(FolderItem next) {
        this.next = next;
    }

    public FolderItem getNext() {
        return this.next;
    }

    public void UpdateList() {
        this.parent.notelist.refreshList();
    }

    public boolean isRemote() {
        return this.remote;
    }

    public void setRemote(boolean val) {
        this.remote = val;
    }

    public boolean delete() {
        return this.deleteFiles(this.path);
    }

    public boolean deleteFiles(File dir) {
        boolean ret_code;
        block1: {
            File file;
            ret_code = true;
            String[] names = new String[]{};
            names = dir.list();
            for (int i = 0; i < names.length && (ret_code = (file = new File(dir, names[i])).isDirectory() ? this.deleteFiles(file) : file.delete()); ++i) {
            }
            if (!ret_code || this.checkSpecial(dir)) break block1;
            ret_code = dir.delete();
        }
        return ret_code;
    }

    public int countMessages() {
        String[] names = new String[]{};
        names = this.path.list(new PopFilter());
        return names.length;
    }
}

