/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mail.Imap4;
import innoval.mail.Imap4Message;
import innoval.mailer.Compose;
import innoval.mailer.ImapMailbox;
import innoval.mailer.ImapMailboxCheck;
import innoval.mailer.ImapMsgThread;
import innoval.mailer.MsgBox;
import innoval.mailer.NoteList;
import innoval.mailer.NotesLabel;
import innoval.mailer.PreviewImapMail;
import innoval.mailer.SendItem;
import innoval.mailer.SortData;
import innoval.mailer.jstreet;
import java.awt.Label;
import java.awt.PopupMenu;
import java.awt.SystemColor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import jclass.bwt.JCMultiColumnList;
import jclass.util.JCSortInterface;
import jclass.util.JCUtilConverter;
import jclass.util.JCVector;

public class ImapList
extends JCMultiColumnList
implements MouseListener {
    static final String COL_WIDTHS = new String("ImapColumnWidths");
    private ImapMailbox mailbox = null;
    private Imap4 imap = null;
    public ImapMsgThread loadthread = null;
    private PreviewImapMail parent = null;
    private int currentMsg = -1;
    private boolean spacebar = false;
    private PopupMenu messagePopup = null;
    private Vector msgVector = new Vector();

    ImapList(PreviewImapMail parent) {
        this.parent = parent;
        this.setBackground(SystemColor.control);
        this.setColumnWidths();
        this.setColumnButtons(JCUtilConverter.toStringList(" ,Msg,Subject,From,To,Date Sent,Date Received,Bytes"));
        this.setColumnAlignment(1, 5);
        this.setColumnAlignment(7, 5);
        this.setSpacing(2);
        this.setNumColumns(8);
        this.setRowHeight(20);
        this.setAllowMultipleSelections(true);
        this.getViewport().addMouseListener(this);
    }

    public void setColumnWidths() {
        String text = this.parent.getFrameParent().getProfile().ReadString(jstreet.DEFAULT, COL_WIDTHS, "");
        if (text.length() == 0) {
            text = new String("20,50,200,100,100,200,200,50");
        }
        super.setColumnWidths(JCUtilConverter.toIntList(text, ','));
    }

    public void saveColumnWidths() {
        int[] col = this.getColumnWidths();
        String text = new String("");
        for (int i = 0; i < col.length; ++i) {
            text = i == 0 ? new String(String.valueOf(text).concat(String.valueOf(col[i]))) : new String(String.valueOf(String.valueOf(text).concat(String.valueOf(","))).concat(String.valueOf(col[i])));
        }
        this.parent.getFrameParent().getProfile().WriteString(jstreet.DEFAULT, COL_WIDTHS, text, true);
    }

    public void setImap4(Imap4 imap) {
        this.imap = imap;
    }

    public void setMessagePopup(PopupMenu messagePopup) {
        this.messagePopup = messagePopup;
    }

    public void setMailbox(ImapMailbox mailbox) {
        this.mailbox = mailbox;
    }

    public void sortByColumn(int column, JCSortInterface sort_if, int direction) {
        Object[] obj = this.getSelectedObjects();
        JCVector vector = this.getItems();
        int sort_type = 0;
        switch (column) {
            case 1: {
                sort_type = 3;
                break;
            }
            case 2: {
                sort_type = 2;
                break;
            }
            case 3: 
            case 4: {
                sort_type = 1;
                break;
            }
            case 5: 
            case 6: {
                sort_type = 4;
                break;
            }
            case 7: {
                sort_type = 3;
            }
        }
        SortData sort = new SortData(vector, column, sort_type);
        if (direction == 1) {
            NoteList.reverseVector(vector);
        }
        this.setItems(vector);
        this.currentMsg = -1;
        if (obj != null && obj.length > 0) {
            int min = vector.size() - 1;
            int spot = 0;
            for (int i = 0; i < obj.length; ++i) {
                spot = vector.indexOf(obj[i]);
                if (spot < min) {
                    min = spot;
                }
                this.select(spot);
            }
            this.makeVisible(min);
        }
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 32) {
            this.spacebar = true;
        }
        super.keyPressed(e);
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() != 38 && e.getKeyCode() != 40 && e.getKeyCode() == 32) {
            this.spacebar = false;
        }
        super.keyReleased(e);
    }

    public void keyTyped(KeyEvent e) {
        super.keyTyped(e);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        int i;
        if (e.getModifiers() == 4 && (i = this.calcItem(e.getY())) < this.countItems()) {
            if (!this.isSelected(i)) {
                this.deSelectAll();
                this.select(i);
                this.displayMessage();
            }
            if (this.messagePopup != null) {
                this.messagePopup.show(this, e.getX(), e.getY());
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        int[] sel;
        if (e.getModifiers() == 16 && (sel = this.getSelectedIndexes()) != null) {
            if (!this.spacebar && sel.length == 1) {
                if (sel[0] != this.currentMsg) {
                    this.displayMessage();
                }
            } else {
                this.parent.clearMessage();
                this.currentMsg = -1;
            }
        }
    }

    public void removeMessages(Label text, NotesLabel notes) {
        this.mailbox.removeMessages(this);
        this.loadMessages(text, notes);
    }

    public void clearCurrentMsg() {
        this.currentMsg = -1;
    }

    public void displayMessage() {
        int ind = this.getSelectedIndex();
        if (ind != this.currentMsg) {
            this.parent.displayMessage(this.getMessage(ind));
            this.currentMsg = ind;
        }
    }

    public void updateMessages(NotesLabel notes) {
        int msgs = this.countItems();
        if (msgs > 0) {
            notes.setText(msgs);
        } else {
            notes.setText("");
        }
    }

    public boolean copyMessages(int[] sel, ImapMailbox nbox) {
        if (this.mailbox != null) {
            return this.mailbox.copyMessages(this, sel, nbox);
        }
        return false;
    }

    public int selected() {
        int[] sel = this.getSelectedIndexes();
        int val = 0;
        if (sel != null) {
            val = sel.length;
        }
        return val;
    }

    public void removeItem(int val) {
        if (val >= 0 && val < this.msgVector.size()) {
            this.msgVector.removeElementAt(val);
        }
        this.deleteItem(val);
    }

    public Imap4Message getMessage(int val) {
        Imap4Message msg = null;
        JCVector vector = this.getItems();
        if (val >= 0 && val < vector.size()) {
            JCVector element = (JCVector)vector.elementAt(val);
            msg = (Imap4Message)element.lastElement();
        }
        return msg;
    }

    public Imap4Message getSelectedMessage() {
        int num = this.getSelectedIndex();
        if (num >= 0) {
            return this.getMessage(num);
        }
        return null;
    }

    public int calcItem(int y) {
        int height;
        int item = this.getTopRow();
        int base = height = this.getRowHeight();
        while (y > base) {
            base += height;
            ++item;
        }
        return item;
    }

    public void close() {
        if (this.loadthread != null) {
            this.loadthread.stop();
            this.loadthread = null;
        }
        this.saveColumnWidths();
    }

    public void deSelectAll() {
        int[] index = this.getSelectedIndexes();
        if (index != null) {
            for (int i = 0; i < index.length; ++i) {
                this.deselect(index[i]);
            }
        }
    }

    public void load(ImapMailbox mailbox, Label text, NotesLabel notes) {
        if (this.mailbox != null) {
            this.mailbox.close(this);
        }
        this.mailbox = mailbox;
        if (this.loadthread != null) {
            this.loadthread.stop();
        }
        this.loadthread = new ImapMsgThread(this, text, notes);
        this.loadthread.start();
    }

    public void loadMessages(Label text, NotesLabel notes) {
        JCVector msg = null;
        text.setText("Reading the list of messages...");
        this.currentMsg = -1;
        if (this.countItems() > 0) {
            this.clear();
        }
        this.msgVector.removeAllElements();
        if (this.mailbox.open(this)) {
            int msgs = this.mailbox.getMessageCount();
            int index = 0;
            Imap4Message message = null;
            notes.setText(msgs);
            ImapMailboxCheck check = new ImapMailboxCheck(MsgBox.findFrame(this), this.mailbox);
            int[] sel = check.getMessages();
            if (sel != null && sel.length > 0) {
                for (int i = 0; i < sel.length; ++i) {
                    index = sel[i];
                    text.setText(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Reading message [").concat(String.valueOf(index))).concat(String.valueOf(" of "))).concat(String.valueOf(msgs))).concat(String.valueOf("]...")));
                    message = this.mailbox.getMessage(this, index);
                    msg = new JCVector();
                    msg.addElement("");
                    msg.addElement(String.valueOf("").concat(String.valueOf(index)));
                    msg.addElement(message.getSubject());
                    msg.addElement(message.getFrom());
                    msg.addElement(message.getTo());
                    msg.addElement(message.getDate());
                    msg.addElement(message.getReceivedDate());
                    msg.addElement(this.stringSize(message.getSize()));
                    msg.addElement(message);
                    this.addItem(msg);
                    this.msgVector.addElement(msg);
                }
                text.setText("Messages have been loaded.");
            } else {
                text.setText("No messages loaded.");
            }
        } else {
            text.setText("Folder was not opened successfully.");
        }
        ((PreviewImapMail)MsgBox.findFrame(this)).enableMenu(true);
    }

    private String stringDate(Date date) {
        String text = "";
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int hr = cal.get(10);
        if (cal.get(9) == 1 && hr < 12) {
            hr += 12;
        }
        text = new String(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(SendItem.findWeekDay(cal.get(7))).concat(String.valueOf(", "))).concat(String.valueOf(Compose.Pad(cal.get(5))))).concat(String.valueOf(" "))).concat(String.valueOf(Compose.findMonth(cal.get(2) + 1)))).concat(String.valueOf(" "))).concat(String.valueOf(cal.get(1)))).concat(String.valueOf(" "))).concat(String.valueOf(Compose.Pad(hr)))).concat(String.valueOf(":"))).concat(String.valueOf(Compose.Pad(cal.get(12))))).concat(String.valueOf(":"))).concat(String.valueOf(Compose.Pad(cal.get(13))))).concat(String.valueOf(" "))).concat(String.valueOf(cal.getTimeZone().getID())));
        return text;
    }

    private String stringSize(int bytes) {
        String text = "";
        int spot = 0;
        if (bytes < 0) {
            text = new String("unknown");
        } else if (bytes < 1024) {
            text = new String(String.valueOf("").concat(String.valueOf(bytes)));
        } else if (bytes <= 524288) {
            double val = (double)bytes / (double)1024;
            text = new String(String.valueOf("").concat(String.valueOf(val)));
            spot = text.indexOf(46);
            text = new String(String.valueOf(text.substring(0, spot + 2)).concat(String.valueOf("K")));
        } else {
            double val = (double)bytes / (double)0x100000;
            text = new String(String.valueOf("").concat(String.valueOf(val)));
            spot = text.indexOf(46);
            text = new String(String.valueOf(text.substring(0, spot + 3)).concat(String.valueOf("Meg")));
        }
        return text;
    }
}

