/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.ui;

import java.awt.Button;
import java.awt.Component;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Panel;
import sunw.hotjava.misc.Globals;
import sunw.hotjava.ui.ConfirmDialogPanel;
import sunw.hotjava.ui.MultiLineLabel;
import sunw.hotjava.ui.UserDialog;
import sunw.hotjava.ui.UserImageLabel;

public class ConfirmDialog
extends UserDialog {
    protected Button[] buttons;
    protected String prompt;
    MultiLineLabel promptLabel;
    public static final int NO = 0;
    public static final int YES = 1;
    private int answer;

    public ConfirmDialog(String string, Frame frame) {
        this(string, frame, 2, true);
    }

    public ConfirmDialog(String string, Frame frame, int n) {
        this(string, frame, n, true);
    }

    public ConfirmDialog(String string, Frame frame, int n, boolean bl) {
        super(string, frame, bl);
        this.init(n);
    }

    public int getAnswer() {
        return this.answer;
    }

    public void setPrompt(String string) {
        this.prompt = string;
        this.promptLabel.setLabel(this.prompt);
    }

    public boolean gotFocus(Event event, Object object) {
        this.buttons[0].requestFocus();
        return true;
    }

    private void init(int n) {
        Object object;
        this.answer = 0;
        ConfirmDialogPanel confirmDialogPanel = new ConfirmDialogPanel();
        this.add("Center", confirmDialogPanel);
        String string = System.getProperty("imagelabel.confirm." + this.getName());
        if (string != null && (object = new UserImageLabel("confirm." + this.getName())) != null) {
            confirmDialogPanel.add("West", (Component)object);
        }
        this.prompt = Globals.localProps.handleGetString("confirm." + this.getName() + ".prompt", "Which do you want to do?");
        this.promptLabel = new MultiLineLabel(this.prompt);
        confirmDialogPanel.add("Center", this.promptLabel);
        this.initButtons(n);
        this.addButtons(confirmDialogPanel);
        object = Globals.localProps.handleGetString("confirm." + this.getName() + ".title", "Confirm Dialog");
        this.setTitle((String)object);
        this.pack();
        this.centerOnScreen();
    }

    private void initButtons(int n) {
        if (n == 2) {
            this.buttons = new Button[2];
            this.buttons[0] = new Button(Globals.localProps.handleGetString("confirm." + this.getName() + ".button.no", "No"));
            this.buttons[1] = new Button(Globals.localProps.handleGetString("confirm." + this.getName() + ".button.yes", "Yes"));
            return;
        }
        this.buttons = new Button[n];
        int n2 = 0;
        while (n2 < n) {
            this.buttons[n2] = new Button(Globals.localProps.handleGetString("confirm." + this.getName() + ".button." + n2, "Choice" + n2));
            ++n2;
        }
    }

    private void addButtons(Panel panel) {
        Panel panel2 = new Panel();
        panel2.setLayout(new FlowLayout(1, 15, 15));
        int n = 0;
        while (n < this.buttons.length) {
            panel2.add(this.buttons[n]);
            ++n;
        }
        panel.add("South", panel2);
    }

    public boolean action(Event event, Object object) {
        int n = 0;
        while (n < this.buttons.length) {
            if (event.target == this.buttons[n]) {
                this.answer = n;
                ((Component)this).hide();
                return true;
            }
            ++n;
        }
        ((Component)this).hide();
        return super.action(event, object);
    }
}

