extproc perl5 -x
#!perl

# send a reminder to folks on a bounce list

# Brent Chapman                                   Great Circle Associates
# Brent@GreatCircle.COM                           1057 West Dana Street
# +1 415 962 0841                                 Mountain View, CA  94041

# $Source: /sources/cvsrepos/majordomo/bounce-remind,v $
# $Revision: 1.3.6.1 $
# $Date: 1994/12/26 23:42:20 $
# $Author: rouilj $
# $State: Exp $
#
# $Locker:  $
#

# Read and execute the .cf file
$cf = $ENV{"MAJORDOMO_CF"} || "d:/majordomo/bin/majordomo.cf";
if ($ARGV[0] eq "-C") {
    $cf = $ARGV[1];
    shift(@ARGV);
    shift(@ARGV);
}
if (! -r $cf) {
    die("$cf not readable; stopped");
}
eval(`type "$cf"`)  || die 'eval of majordomo.cf failed';

# Go to the home directory specified by the .cf file
chdir("$homedir");

# All these should be in the standard PERL library
unshift(@INC, $homedir);

open(MSG, "| sendmail bounces@$whereami") ||
    die("open(MSG, \"| sendmail bounces@$whereami\"): $!\nStopped");

print MSG <<EOF;
To: Bounces@$whereami
From: nobody@$whereami
Subject: Bouncing email from mailing lists at $whereami
Reply-To: $whoami

Your address has been moved to Bounces@$whereami
from some other mailing list at $whereami
because email to you was bouncing.

Here are the addresses currently on Bounces@$whereami
so that you can see which of your addresses is among them.
The comment for each address shows the date it was moved,
and the first list it was removed from.  If you were on
multiple lists here, you may have been removed from them
as well, but only the first list you were removed from
will show up in the comment below.

EOF

open(LIST, "$listdir/bounces") 
    || die("Can't read $listdir/bounces: $!; aborting");

while (<LIST>) {
    print MSG "\t$_";
}

close(LIST);

print MSG <<EOF;

If the problem has been fixed, you can get off of
Bounces and back on to the other list by sending the
following to $whoami:

    subscribe your_list
    unsubscribe bounces

To subscribe or unsubscribe an address other than where you're
sending the command from, append the other address to the end
of the "subscribe" or "unsubscribe" command (for example,
"subscribe your_list foo\@bar.com").

You'll need to access the mailing list archives if you want to catch
up on whatever you missed while you were off the main list.

If you don't want to keep getting these reminders every day, but
don't want to resubscribe to the list, send just the "unsubscribe"
command shown above.

If you need to contact a human being regarding this, send a message
to $whoami_owner.
EOF

close(MSG);

exit 0;
