/* 
* catbat.c
*
* (c) Paul Vixie <paul@vix.com>
* 
* Ported to OS/2 and hacked to be useful for UUPC/Extended and IBM sendmail 
* by Jochen Friedrich <jochen@audio.ruessel.sub.org>.
* Please send bug reports for this port to me, not to the original author.
*
*/ 

/* catbat - concatenating batcher
 * vix 19mar91 [written]
 * JOF 07okt94 [ported to OS/2]
 */

/* purpose: chdir to the directory named on the command line, create a new
 *          numbered file which does not exist, append stdin to it and close.
 */

#include <errno.h>
#include <stdio.h>
#include <io.h>
#include <fcntl.h>
#include <direct.h>
#include <share.h>
#include <sys\stat.h>
#include "sysexits.h"

#define STDIN 0
#define FMODE S_IREAD | S_IWRITE
#define MAXPATHLEN 1024

main(argc, argv)
	int argc;
	char *argv[];
{
	extern void catbat();

	if (argc != 2) {
		(void) fprintf(stderr, "usage:  %s batchdir\n", argv[0]);
		(void) exit(EX_USAGE);
	}

	if (chdir(argv[1]) < 0) {
		(void) fprintf(stderr, "%s:  chdir ", argv[0]);
		(void) perror(argv[1]);
		(void) exit(EX_UNAVAILABLE);
	}

	if (argv[1][1] == ':') {
		if (_chdrive(toupper(argv[1][0])-'A'+1) <0) {
			(void) fprintf(stderr, "%s:  chdrive ", argv[0]);
			(void) perror(argv[1]);
			(void) exit(EX_UNAVAILABLE);
		}
	}
	(void) catbat();
	(void) exit(0);
}

void
catbat()
{
	int	f = 0, fd;
	char	n[MAXPATHLEN];
	unsigned char	buf[BUFSIZ];

	while (++f) {
		(void) sprintf(n, "%d", f);
		fd = sopen(n, O_WRONLY|O_CREAT|O_EXCL|O_BINARY, SH_DENYRW, FMODE);
		if (fd >= 0) {
			register x;

			while ((x = read(STDIN, buf, BUFSIZ)) > 0) {
				(void) write(fd, buf, x);
			}
			close(fd);
			return;
		}
	}
}
