IMPLEMENTATION MODULE SUOptions;

        (********************************************************)
        (*                                                      *)
        (*       'Options' page in Weasel set-up utility        *)
        (*                                                      *)
        (*  Programmer:         P. Moylan                       *)
        (*  Started:            21 June 1999                    *)
        (*  Last edited:        2 September 1999                *)
        (*  Status:             OK                              *)
        (*                                                      *)
        (********************************************************)

FROM SYSTEM IMPORT LOC;

IMPORT OS2, Strings;

FROM LowLevel IMPORT
    (* proc *)  EVAL;

FROM TaskControl IMPORT
    (* proc *)  CreateTask;

FROM Keyboard IMPORT
    (* proc *)  StuffKeyboardBuffer;

FROM Windows IMPORT
    (* type *)  Window, Colour, FrameType, DividerType,
    (* proc *)  OpenWindowHidden, CloseWindow, WriteString, WriteLn,
                WriteChar, SetCursor, SetActivePage, GetKey, GetScreenSize;

FROM InetUtilities IMPORT
    (* proc *)  INIGet, INIGetString, INIPut;

FROM ScreenEditor IMPORT
    (* type *)  Structure,
    (* proc *)  StringField, Combine,
                ScreenEdit, DeleteStructure;

FROM MultiScreen IMPORT
    (* type *)  ScreenGroup, VirtualScreen,
    (* proc *)  CreateScreenGroup, CreateVirtualScreen, MapToVirtualScreen;

FROM Names IMPORT
    (* type *)  FilenameString, HostName;

FROM SetupINI IMPORT
    (* proc *)  OurINIHandle;

(************************************************************************)

VAR
    (* Number of display rows on screen.  *)

    ScreenRows: CARDINAL;

    (* Post-reception filter. *)

    FilterProg: FilenameString;

    (* Forward relay host. *)

    ForwardRelayHost: HostName;

(************************************************************************)
(*                        INI FILE EDITING                              *)
(************************************************************************)

PROCEDURE LoadINIData;

    (* Loads setup parameters from "weasel.ini". *)

    VAR hini: OS2.HINI;

    (****************************************************************)

    PROCEDURE GetStringItem (name: ARRAY OF CHAR;
                         VAR (*OUT*) variable: ARRAY OF CHAR): BOOLEAN;

        BEGIN
            RETURN INIGetString (hini, "$SYS", name, variable);
        END GetStringItem;

    (****************************************************************)

    BEGIN
        FilterProg := "";
        ForwardRelayHost := "";
        hini := OurINIHandle();
        IF hini <> OS2.NULLHANDLE THEN
            EVAL (GetStringItem ("FilterProg", FilterProg));
            EVAL (GetStringItem ("ForwardRelay", ForwardRelayHost));
        END (*IF*);
    END LoadINIData;

(********************************************************************)

PROCEDURE StoreINIData;

    (* Writes data back to the INI file. *)

    VAR hini: OS2.HINI;

    (****************************************************************)

    PROCEDURE PutItem (name: ARRAY OF CHAR;  VAR (*OUT*) variable: ARRAY OF LOC);

        BEGIN
            INIPut (hini, "$SYS", name, variable);
        END PutItem;

    (****************************************************************)

    CONST Nul = CHR(0);
    VAR j: CARDINAL;

    BEGIN
        WHILE FilterProg[0] = ' ' DO
            Strings.Delete (FilterProg, 0, 1);
        END (*WHILE*);
        j := Strings.Length (FilterProg);
        LOOP
            IF j = 0 THEN EXIT(*LOOP*) END(*IF*);
            DEC (j);
            IF FilterProg[j] <> ' ' THEN EXIT(*LOOP*) END(*IF*);
            FilterProg[j] := Nul;
        END (*LOOP*);
        WHILE ForwardRelayHost[0] = ' ' DO
            Strings.Delete (ForwardRelayHost, 0, 1);
        END (*WHILE*);
        j := Strings.Length (ForwardRelayHost);
        LOOP
            IF j = 0 THEN EXIT(*LOOP*) END(*IF*);
            DEC (j);
            IF ForwardRelayHost[j] <> ' ' THEN EXIT(*LOOP*) END(*IF*);
            ForwardRelayHost[j] := Nul;
        END (*LOOP*);
        hini := OurINIHandle();
        IF hini <> OS2.NULLHANDLE THEN
            PutItem ("FilterProg", FilterProg);
            PutItem ("ForwardRelay", ForwardRelayHost);
        END (*IF*);
    END StoreINIData;

(************************************************************************)

PROCEDURE EditParameters (OurPage: VirtualScreen);

    VAR w: Window;
        R: Structure;
        abort: BOOLEAN;  ch: CHAR;

    (********************************************************************)

    BEGIN
        OpenWindowHidden (w, white, blue, 2, ScreenRows - 2,
                                                  0, 79, noframe, nodivider);
        MapToVirtualScreen (w, OurPage);
        LoadINIData;

        SetCursor (w, 9, 2);  WriteString (w, "Filter for incoming mail");
        SetCursor (w, 10, 2);  WriteChar (w, '[');
        SetCursor (w, 10, 68);  WriteChar (w, ']');
        SetCursor (w, 12, 2);  WriteString (w, "Relay host for forwarding mail");
        SetCursor (w, 13, 2);  WriteChar (w, '[');
        SetCursor (w, 13, 68);  WriteChar (w, ']');

        R := StringField (FilterProg, 10, 3, 65);
        Combine (R, StringField (ForwardRelayHost, 13, 3, 65));

        SetCursor (w, 1, 32);
        LOOP
            ScreenEdit (w, R, abort);
            IF abort THEN EXIT(*LOOP*) END(*IF*);

            (* Consume the character that took us off the edge. *)

            ch := GetKey (w);
            IF ch = CHR(0) THEN
                EVAL (GetKey (w));
            END (*IF*);

        END (*LOOP*);

        DeleteStructure (R);
        StoreINIData;
        CloseWindow (w);

    END EditParameters;

(************************************************************************)
(*                              MAIN PROGRAM                            *)
(************************************************************************)

PROCEDURE OptionEditor;

    CONST Esc = CHR(1BH);

    VAR w0, bottombar: Window;
        OurGroup: ScreenGroup;
        OurPage: VirtualScreen;

    BEGIN
        OurGroup := CreateScreenGroup (1);
        OurPage := CreateVirtualScreen (OurGroup);
        OpenWindowHidden (bottombar, yellow, red, ScreenRows-1, ScreenRows-1, 0, 79, noframe, nodivider);
        WriteString (bottombar, " Esc exit");
        SetCursor (bottombar, 0, 55);
        WriteString (bottombar, "F4,F5 previous/next page");
        MapToVirtualScreen (bottombar, OurPage);

        OpenWindowHidden (w0, yellow, red, 0, 1, 0, 79, noframe, nodivider);
        MapToVirtualScreen (w0, OurPage);
        WriteString (w0, "  OPTIONS");
        WriteLn (w0);
        WriteString (w0, "   Leave these blank if you don't use them");

        EditParameters (OurPage);
        CloseWindow (w0);
        CloseWindow (bottombar);
        SetActivePage (0);
        StuffKeyboardBuffer (CHR(27));

    END OptionEditor;

(************************************************************************)

VAR dummy: CARDINAL;

BEGIN
    GetScreenSize (ScreenRows, dummy);
    LoadINIData;
    CreateTask (OptionEditor, 2, "Option editor");
FINALLY
    StoreINIData;
END SUOptions.

