MODULE WCTest;

        (********************************************************)
        (*                                                      *)
        (*             Test of the WildCard module              *)
        (*                                                      *)
        (*  Programmer:         P. Moylan                       *)
        (*  Started:            10 June 1999                    *)
        (*  Last edited:        21 June 1999                    *)
        (*  Status:             Apparently working              *)
        (*                                                      *)
        (********************************************************)

FROM STextIO IMPORT
    (* proc *)  WriteString, WriteLn;

FROM Names IMPORT
    (* type *)  HostName;

FROM WildCard IMPORT
    (* proc *)  WildMatch;

(************************************************************************)
(*                       COMPARISON PROCEDURES                          *)
(************************************************************************)

PROCEDURE OldNameMatch (VAR (*IN*) template, second: HostName): BOOLEAN;

    (* Returns TRUE if template and second are equal, with the extra    *)
    (* rules:                                                           *)
    (*   1. Character case is not significant.                          *)
    (*   2. A '.' as the initial character in template means that we    *)
    (*      will return TRUE if template matches the tail of second.    *)
    (* Special case: if template = "." then it matches anything.        *)

    VAR j1, j2: CARDINAL;

    BEGIN
        j1 := LENGTH (template);
        j2 := LENGTH (second);

        (* Check the "match anything" special case. *)

        IF (j1 = 0) OR ((j1 = 1) AND (template[0] = '.')) THEN
            RETURN TRUE;
        END (*IF*);

        (* Now the general case.  We check from the tail of the strings *)
        (* so as to pick up tail matches more easily.                   *)

        LOOP
            IF j1 = 0 THEN
                RETURN j2 = 0;
            ELSIF j2 = 0 THEN
                RETURN (j1 = 1) AND (template[0] = '.');
            ELSE
                DEC (j1);  DEC (j2);
                IF (j1 = 0) AND (template[0] = '.') THEN
                    RETURN second[j2] = '.';
                ELSIF CAP(template[j1]) <> CAP(second[j2]) THEN
                    RETURN FALSE;
                END (*IF*);
            END (*IF*);
        END (*LOOP*);

    END OldNameMatch;

(************************************************************************)

PROCEDURE NameMatch (VAR (*IN*) input, template: HostName): BOOLEAN;

    (* Returns TRUE if input matches template under either the old      *)
    (* rules (initial '.' is wild) or the new rules ('*' is wild).      *)

    BEGIN
        RETURN OldNameMatch(template, input) OR WildMatch(input, template);
    END NameMatch;

(************************************************************************)
(*                          TEST CODE                                   *)
(************************************************************************)

PROCEDURE TestPair (input, template: HostName);

    BEGIN
        WriteString (input);
        IF NameMatch (input, template) THEN
            WriteString (" matches ");
        ELSE
            WriteString (" doesn't match ");
        END (*IF*);
        WriteString ("template ");  WriteString (template);
        WriteLn;
    END TestPair;

(************************************************************************)

PROCEDURE RunTheTest;

    BEGIN
        WriteString ("Testing wildcard matches");  WriteLn;
        TestPair ("a", "*a");
        TestPair ("a", "A");
        TestPair ("a", "b*");
        TestPair ("a", "*");
        TestPair ("ab", "*b*");
        TestPair ("a", "**");
        TestPair ("a", "**b");
        TestPair ("xyabuvdefabcmmdefmmm", "**abc*def*");
    END RunTheTest;

(************************************************************************)
(*                            MAIN PROGRAM                              *)
(************************************************************************)

BEGIN
    RunTheTest;
END WCTest.

