/*
 * Decompiled with CFR 0.152.
 */
package net.ibm.malamut.newsmail;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Vector;
import net.ibm.malamut.newsmail.Basis;
import net.ibm.malamut.newsmail.GenericConnectionServer;
import net.ibm.malamut.newsmail.Tools;
import net.ibm.malamut.newsmail.ui.Shell;

public abstract class GenericServer
extends Thread {
    protected ServerSocket listener = null;
    protected Basis basis;
    protected boolean doFinalize = true;
    protected Object readyMonitor = new Object();
    protected boolean ready = false;
    protected boolean ok = false;
    protected Object continueMonitor = new Object();
    protected boolean doContinue = true;
    protected Vector runningServers = new Vector();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void finalize() throws Throwable {
        if (this.doFinalize) {
            try {
                this.basis.relax();
            }
            catch (IOException iOException) {
            }
        }
        super.finalize();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean initSucceeded() {
        Object object = this.readyMonitor;
        synchronized (object) {
            try {
                while (!this.ready) {
                    this.readyMonitor.wait();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            return this.ok;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            Object object;
            try {
                object = this.readyMonitor;
                synchronized (object) {
                    this.ready = true;
                    this.ok = true;
                    this.readyMonitor.notifyAll();
                }
                this.serve();
            }
            catch (Exception exception) {
                Object object2 = this.continueMonitor;
                synchronized (object2) {
                    if (this.doContinue) {
                        Shell.error("Starting Server", "Couldn't establish connection, shutting down", exception);
                    }
                }
            }
            object = this.readyMonitor;
            synchronized (object) {
                this.ready = true;
                this.ok = false;
                this.readyMonitor.notifyAll();
                return;
            }
        }
        catch (Throwable throwable) {
            Tools.log("Internal error in GenericServer.run():", throwable);
        }
    }

    public abstract void serve() throws IOException, SocketException;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown() {
        Enumeration enumeration;
        block14: {
            enumeration = this.continueMonitor;
            synchronized (enumeration) {
                this.doContinue = false;
                try {
                    this.listener.close();
                }
                catch (IOException iOException) {
                }
            }
            enumeration = this.readyMonitor;
            synchronized (enumeration) {
                while (true) {
                    while (true) {
                        if (!this.ready || !this.ok) {
                            break block14;
                        }
                        try {
                            this.readyMonitor.wait();
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                    break;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        enumeration = this.runningServers.elements();
        while (enumeration.hasMoreElements()) {
            GenericConnectionServer genericConnectionServer = (GenericConnectionServer)enumeration.nextElement();
            if (!genericConnectionServer.alive()) continue;
            Tools.log("\r\nAborting connection from " + genericConnectionServer.origin() + "...");
            genericConnectionServer.abort();
        }
    }

    public GenericServer() throws IOException {
        this.basis = new Basis();
    }

    public GenericServer(String string) throws IOException {
        this.basis = new Basis(string);
    }

    public GenericServer(Basis basis) {
        this.basis = basis;
        this.doFinalize = false;
    }
}

