/*
 * Decompiled with CFR 0.152.
 */
package net.ibm.malamut.newsmail;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.SimpleTimeZone;
import java.util.Vector;
import net.ibm.malamut.newsmail.ArticleData;
import net.ibm.malamut.newsmail.GroupData;
import net.ibm.malamut.newsmail.MailDataReader;
import net.ibm.malamut.newsmail.MailDataRepository;
import net.ibm.malamut.newsmail.MailDataWriter;
import net.ibm.malamut.newsmail.NNTPConnectionInfo;
import net.ibm.malamut.newsmail.RFCAnalyzer;
import net.ibm.malamut.newsmail.Tools;
import net.ibm.malamut.newsmail.connections.ServerConnection;

public final class NNTPCommand {
    public static final int UNKNOWN = 0;
    public static final int QUIT = 1;
    public static final int ARTICLE = 2;
    public static final int HEAD = 3;
    public static final int BODY = 4;
    public static final int STAT = 5;
    public static final int GROUP = 6;
    public static final int HELP = 7;
    public static final int IHAVE = 8;
    public static final int SLAVE = 9;
    public static final int LAST = 10;
    public static final int LIST = 11;
    public static final int NEWGROUPS = 12;
    public static final int NEWNEWS = 13;
    public static final int NEXT = 14;
    public static final int POST = 15;
    public static final int XHDR = 20;
    public static final int XOVER = 21;
    public static final int LIST_ACTIVE = 30;
    public static final int LIST_ACTIVE_TIMES = 31;
    public static final int LIST_DISTRIBUTIONS = 32;
    public static final int LIST_DISTRIB_PATS = 33;
    public static final int LIST_NEWSGROUPS = 34;
    public static final int LIST_OVERVIEW_FMT = 35;
    public static final int LIST_SUBSCRIPTIONS = 36;
    private static final int NOOP = 99;
    private NNTPConnectionInfo ci;
    private ServerConnection conn;
    private String contents;
    private int code = 0;
    private boolean error = false;
    private String msgid = null;
    private long articleNumber = -1L;
    private boolean useInternalArticlePointer = false;
    private String group = null;
    private Date date = null;
    private String header = null;
    private long start = -1L;
    private long stop = -1L;

    public final int code() {
        return this.code;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void execute() throws IOException {
        block81: {
            if (this.code == 0) {
                this.error = true;
            }
            if (this.error) {
                this.conn.writeAnswer(501, "I did not recognize this command.");
                return;
            }
            var1_1 = 0L;
            switch (this.code) {
                case 99: {
                    return;
                }
                case 1: {
                    this.conn.writeAnswer(205, "Goodbye! Please do visit us again!");
                    return;
                }
                case 7: {
                    this.conn.writeAnswer(100, "A very short help follows.");
                    var3_2 = new BufferedReader(new StringReader("This server implements the NNTP standard (consult RFC977 for details).\r\n" + "Exceptions:\r\n" + "\tThe command NEWNEWS is not implemented.\r\n" + "\tThe command NEWGROUPS does not accept a list of distribution groups.\r\n" + "\tNon-standard commands XHDR, XOVER and LIST OVERVIEW.FMT are implemented."));
                    this.conn.writeText(var3_2);
                    var3_2.close();
                    return;
                }
                case 9: {
                    this.conn.writeAnswer(202, "Slave status noted (but it doesn't make any difference on this server).");
                    return;
                }
                case 11: {
                    this.conn.writeAnswer(215, "A list of available newsgroups follows.");
                    var4_3 = this.ci.basis.groups().groups();
                    this.conn.startLongText();
                    var5_7 = 0;
                    while (true) {
                        if (var5_7 >= var4_3.size()) {
                            this.conn.writeTextEnd();
                            return;
                        }
                        var6_19 = (String)var4_3.elementAt(var5_7);
                        var7_29 = this.ci.basis.getGroupData(var6_19);
                        this.conn.writeTextLine(var6_19 + " " + var7_29.lastArticle + " " + var7_29.firstArticle + (var7_29.mayWrite != false ? " y" : " n"));
                        ++var5_7;
                    }
                }
                case 10: {
                    if (this.ci.currentGroup == null) {
                        this.conn.writeAnswer(412, "You must select a newsgroup first.");
                        return;
                    }
                    var5_8 = this.ci.basis.getGroupData(this.ci.currentGroup);
                    if (this.ci.currentArticle == -1L) {
                        this.conn.writeAnswer(420, "No article has been selected so far in this group.");
                        return;
                    }
                    if (var5_8.firstArticle == this.ci.currentArticle) {
                        this.conn.writeAnswer(422, "The first available article is already selected.");
                        return;
                    }
                    var6_20 = var5_8.firstArticle;
                    var8_37 = var5_8.articles.keys();
                    while (true) {
                        if (!var8_37.hasMoreElements()) {
                            var8_37 = (String)var5_8.articles.get(new Long(var6_20));
                            this.conn.writeAnswer(223, var6_20 + " <" + (String)var8_37 + "> " + "article ready - retrieve text seperately.");
                            this.ci.currentArticle = var6_20;
                            return;
                        }
                        var9_45 = (Long)var8_37.nextElement();
                        if (var9_45 <= var6_20 || var9_45 >= this.ci.currentArticle) continue;
                        var6_20 = var9_45;
                    }
                }
                case 14: {
                    if (this.ci.currentGroup == null) {
                        this.conn.writeAnswer(412, "You must select a newsgroup first.");
                        return;
                    }
                    var5_9 = this.ci.basis.getGroupData(this.ci.currentGroup);
                    if (this.ci.currentArticle == -1L) {
                        this.conn.writeAnswer(420, "No article has been selected so far in this group.");
                        return;
                    }
                    if (var5_9.lastArticle == this.ci.currentArticle) {
                        this.conn.writeAnswer(422, "The last available article is already selected.");
                        return;
                    }
                    var6_21 = var5_9.lastArticle;
                    var8_38 = var5_9.articles.keys();
                    while (true) {
                        if (!var8_38.hasMoreElements()) {
                            var8_38 = (String)var5_9.articles.get(new Long(var6_21));
                            this.conn.writeAnswer(223, var6_21 + " <" + (String)var8_38 + "> " + "article ready - retrieve text seperately.");
                            this.ci.currentArticle = var6_21;
                            return;
                        }
                        var9_46 = (Long)var8_38.nextElement();
                        if (var9_46 >= var6_21 || var9_46 <= this.ci.currentArticle) continue;
                        var6_21 = var9_46;
                    }
                }
                case 6: {
                    if (this.ci.basis.existsNewsgroup(this.group)) {
                        var5_10 = this.ci.basis.getGroupData(this.group);
                        this.conn.writeAnswer(211, var5_10.articles.size() + " " + var5_10.firstArticle + " " + var5_10.lastArticle + " " + this.group + " group selected.");
                        this.ci.currentGroup = this.group;
                        if (var5_10.firstArticle > var5_10.lastArticle) return;
                        this.ci.currentArticle = var5_10.firstArticle;
                        return;
                    }
                    this.conn.writeAnswer(411, "Group '" + this.group + "' not available. Sorry.");
                    return;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    if (this.msgid == null) ** GOTO lbl99
                    var5_11 = 1L;
                    if (this.ci.currentGroup == null || !this.ci.basis.getGroupData((String)this.ci.currentGroup).articles.contains(this.msgid)) break block81;
                    var7_30 = this.ci.basis.getGroupData(this.ci.currentGroup);
                    var8_39 = var7_30.articles.keys();
                    if (true) ** GOTO lbl337
lbl99:
                    // 1 sources

                    if (this.articleNumber != -1L) {
                        if (this.ci.currentGroup == null) {
                            this.conn.writeAnswer(412, "Please select a newsgroup first.");
                            return;
                        }
                        var5_12 = this.ci.basis.getGroupData(this.ci.currentGroup);
                        if (var5_12.articles.containsKey(new Long(this.articleNumber))) {
                            var6_22 = (String)var5_12.articles.get(new Long(this.articleNumber));
                            this.executeArticleCommand(this.articleNumber, var6_22);
                            return;
                        }
                        this.conn.writeAnswer(423, "There's no such article number in this group.");
                        return;
                    }
                    if (this.ci.currentGroup == null) {
                        this.conn.writeAnswer(412, "Please select a newsgroup first.");
                        return;
                    }
                    var5_13 = this.ci.basis.getGroupData(this.ci.currentGroup);
                    if (this.ci.currentArticle != -1L) {
                        var6_23 = (String)var5_13.articles.get(new Long(this.ci.currentArticle));
                        this.executeArticleCommand(this.ci.currentArticle, var6_23);
                        return;
                    }
                    this.conn.writeAnswer(420, "Please select an article first.");
                    return;
                }
                case 12: {
                    this.conn.writeAnswer(231, "A list of newly available newsgroups follows.");
                    var4_4 = this.ci.basis.groups().groups();
                    this.conn.startLongText();
                    var5_14 = 0;
                    while (true) {
                        if (var5_14 >= var4_4.size()) {
                            this.conn.writeTextEnd();
                            return;
                        }
                        var6_24 = (String)var4_4.elementAt(var5_14);
                        var7_31 = this.ci.basis.getGroupData(var6_24);
                        if (this.date.before(var7_31.added)) {
                            this.conn.writeTextLine(var6_24 + " " + var7_31.lastArticle + " " + var7_31.firstArticle + (var7_31.mayWrite != false ? " y" : " n"));
                        }
                        ++var5_14;
                    }
                }
                case 15: {
                    if (!this.ci.writeAllowed) {
                        this.conn.writeAnswer(440, "Posting is not allowed on this connection.");
                        return;
                    }
                    this.conn.writeAnswer(340, "Please send your article now. End with <cr><lf>.<cr><lf>.");
                    var1_1 = this.ci.basis.getNextArticleFile();
                    var5_15 = new ArticleData();
                    var5_15.file = var1_1;
                    var5_15.received = Calendar.getInstance().getTime();
                    var6_25 = new MailDataWriter(this.ci.basis.repository(), var1_1);
                    var7_32 = var6_25.getWriter();
                    try {
                        this.conn.getText(var7_32);
                        var6_25.close();
                        var8_40 = this.ci.basis.getGroupsForArticle(var1_1);
                        var9_48 = this.ci.basis.getMsgId(var1_1, true, true);
                        if (this.ci.basis.existsMsgid(var9_48)) {
                            this.ci.basis.repository().delete(var1_1);
                            this.conn.writeAnswer(240, "We already had that article.");
                            return;
                        }
                        var10_50 = false;
                        var11_52 = "Xref: " + Tools.getLocalHostName() + " ";
                        var12_54 = 0;
                        while (true) {
                            if (var12_54 >= var8_40.size()) {
                                if (var10_50) break;
                                throw new IOException("Article does not belong to a known newsgroup.");
                            }
                            var13_56 = (String)var8_40.elementAt(var12_54);
                            var14_57 = this.ci.basis.getGroupData(var13_56);
                            if (var14_57 != null) {
                                this.ci.basis.groups().sync().startWrite();
                                ++var14_57.lastArticle;
                                var14_57.articles.put(new Long(var14_57.lastArticle), var9_48);
                                this.ci.basis.groups().sync().endWrite();
                                var10_50 = true;
                                var11_52 = var11_52 + var13_56 + ":" + var14_57.lastArticle;
                            }
                            ++var12_54;
                        }
                        this.ci.basis.changeXrefLine(var5_15.file, var11_52);
                        this.ci.basis.addMsgid(var9_48, var5_15);
                        this.ci.basis.addToOutnews(var9_48, null);
                        this.ci.basis.addToReplyPath(var1_1);
                        this.conn.writeAnswer(240, "Article successfully posted.");
                        return;
                    }
                    catch (IOException var8_41) {
                        Tools.log("Posting from remote server failed. Reason:", var8_41);
                        this.ci.basis.repository().delete(var1_1);
                        this.conn.writeAnswer(441, "Posting failed. Sorry.");
                        return;
                    }
                }
                case 8: {
                    if (!this.ci.writeAllowed) {
                        this.conn.writeAnswer(435, "You don't have permission to write.");
                        return;
                    }
                    if (this.ci.basis.existsMsgid(this.msgid)) {
                        this.conn.writeAnswer(435, "We already have this article.");
                        return;
                    }
                    this.conn.writeAnswer(335, "Please send the article. End with <cr><lf>.<cr><lf>.");
                    var5_16 = new ArticleData();
                    var5_16.file = var1_1 = this.ci.basis.getNextArticleFile();
                    var5_16.received = Calendar.getInstance().getTime();
                    var6_26 = new MailDataWriter(this.ci.basis.repository(), var1_1);
                    try {
                        this.conn.getText(var6_26.getWriter());
                        var6_26.close();
                    }
                    catch (IOException var7_33) {
                        this.ci.basis.repository().delete(var1_1);
                        this.conn.writeAnswer(436, "Something went wrong during transfer - please try again.");
                    }
                    var7_34 = this.ci.basis.getGroupsForArticle(var1_1);
                    var8_42 = false;
                    var9_49 = "Xref: " + Tools.getLocalHostName() + " ";
                    var10_51 = 0;
                    while (true) {
                        if (var10_51 >= var7_34.size()) {
                            if (!var8_42) {
                                this.ci.basis.repository().delete(var1_1);
                                this.conn.writeAnswer(437, "We don't want that article - please don't try again.");
                            }
                            this.ci.basis.changeXrefLine(var5_16.file, var9_49);
                            this.ci.basis.addMsgid(this.msgid, var5_16);
                            this.ci.basis.addToOutnews(this.msgid, null);
                            this.ci.basis.addToReplyPath(var1_1);
                            this.conn.writeAnswer(235, "Article successfully transferred.");
                            return;
                        }
                        var11_53 = (String)var7_34.elementAt(var10_51);
                        var12_55 = this.ci.basis.getGroupData(var11_53);
                        if (var12_55 != null) {
                            this.ci.basis.groups().sync().startWrite();
                            ++var12_55.lastArticle;
                            var12_55.articles.put(new Long(var12_55.lastArticle), this.msgid);
                            this.ci.basis.groups().sync().startWrite();
                            var8_42 = true;
                            var9_49 = var9_49 + var11_53 + ":" + var12_55.lastArticle;
                        }
                        ++var10_51;
                    }
                }
                case 13: {
                    this.conn.writeAnswer(503, "We do not support the NEWNEWS command. Sorry.");
                    return;
                }
                case 30: {
                    this.conn.writeAnswer(503, "We do not support the LIST ACTIVE command. Sorry.");
                    return;
                }
                case 31: {
                    this.conn.writeAnswer(503, "We do not support the LIST ACTIVE.TIMES command. Sorry.");
                    return;
                }
                case 32: {
                    this.conn.writeAnswer(503, "We do not support the LIST DISTRIBUTIONS command. Sorry.");
                    return;
                }
                case 33: {
                    this.conn.writeAnswer(503, "We do not support the LIST DISTRIB.PATS command. Sorry.");
                    return;
                }
                case 34: {
                    this.conn.writeAnswer(503, "We do not support the LIST NEWSGROUPS command. Sorry.");
                    return;
                }
                case 35: {
                    this.conn.writeAnswer(215, "Format for XOVER follows.");
                    this.conn.startLongText();
                    this.conn.writeTextLine("Subject:");
                    this.conn.writeTextLine("From:");
                    this.conn.writeTextLine("Date:");
                    this.conn.writeTextLine("Message-ID:");
                    this.conn.writeTextLine("References:");
                    this.conn.writeTextLine("Bytes:");
                    this.conn.writeTextLine("Lines:");
                    this.conn.writeTextLine("Xref:full");
                    this.conn.writeTextEnd();
                    return;
                }
                case 36: {
                    this.conn.writeAnswer(503, "We do not support the LIST SUBSCRIPTIONS command. Sorry.");
                    return;
                }
                case 21: {
                    if (this.ci.currentGroup == null) {
                        this.conn.writeAnswer(412, "You must select a newsgroup first.");
                        return;
                    }
                    var5_17 = this.ci.basis.getGroupData(this.ci.currentGroup);
                    var6_27 = var5_17.articles;
                    var4_5 = new Vector<Long>();
                    if (this.start == -1L) {
                        if (this.ci.currentArticle == -1L) {
                            this.conn.writeAnswer(420, "Please select an article first.");
                            return;
                        }
                        this.stop = this.start = this.ci.currentArticle;
                    } else if (this.stop == -1L) {
                        this.stop = var5_17.lastArticle;
                    }
                    var8_43 = this.start;
                    while (true) {
                        if (var8_43 > this.stop) {
                            if (var4_5.size() <= 0) break;
                            this.conn.writeAnswer(224, "Overview information follows.");
                            this.executeXoverCommand(var4_5, var5_17);
                            this.conn.writeTextEnd();
                            return;
                        }
                        var7_35 = new Long(var8_43);
                        if (var6_27.containsKey(var7_35)) {
                            var4_5.addElement(var7_35);
                        }
                        ++var8_43;
                    }
                    this.conn.writeAnswer(420, "No such articles found.");
                    return;
                }
                case 20: {
                    if (this.msgid != null) {
                        this.conn.writeAnswer(503, "We do not support the XHDR command with <msgid> parameter. Sorry.");
                        return;
                    }
                    if (this.ci.currentGroup == null) {
                        this.conn.writeAnswer(412, "You must select a newsgroup first.");
                        return;
                    }
                    var5_18 = this.ci.basis.getGroupData(this.ci.currentGroup);
                    var6_28 = var5_18.articles;
                    var4_6 = new Vector<Long>();
                    if (this.start == -1L) {
                        if (this.ci.currentArticle == -1L) {
                            this.conn.writeAnswer(420, "Please select an article first.");
                            return;
                        }
                        this.stop = this.start = this.ci.currentArticle;
                    } else if (this.stop == -1L) {
                        this.stop = var5_18.lastArticle;
                    }
                    var8_44 = this.start;
                    while (true) {
                        if (var8_44 > this.stop) {
                            if (var4_6.size() <= 0) break;
                            this.conn.writeAnswer(221, "Header information follows.");
                            this.executeXhdrCommand(var4_6, var5_18);
                            this.conn.writeTextEnd();
                            return;
                        }
                        var7_36 = new Long(var8_44);
                        if (var6_28.containsKey(var7_36)) {
                            var4_6.addElement(var7_36);
                        }
                        ++var8_44;
                    }
                    this.conn.writeAnswer(420, "No such articles found.");
                    return;
                }
                default: {
                    return;
                }
            }
            do {
                if (!var7_30.articles.get(var9_47 = (Long)var8_39.nextElement()).equals(this.msgid)) continue;
                var5_11 = var9_47;
                break;
lbl337:
                // 2 sources

            } while (var8_39.hasMoreElements());
        }
        if (this.ci.basis.existsMsgid(this.msgid)) {
            this.executeArticleCommand(var5_11, this.msgid);
            return;
        }
        this.conn.writeAnswer(430, "No such article found. Sorry.");
    }

    private final void executeArticleCommand(long l, String string) throws IOException {
        if (this.code == 5) {
            this.conn.writeAnswer(223, l + " <" + string + "> article found - request text seperately.");
        } else {
            MailDataReader mailDataReader = new MailDataReader(this.ci.basis.repository(), this.ci.basis.getFileFromMsgid(string));
            BufferedReader bufferedReader = mailDataReader.getReader();
            switch (this.code) {
                case 2: {
                    this.conn.writeAnswer(220, l + " <" + string + "> article found - text follows.");
                    this.conn.writeText(bufferedReader);
                    break;
                }
                case 3: {
                    this.conn.writeAnswer(221, l + " <" + string + "> article found - head follows.");
                    String string2 = bufferedReader.readLine();
                    if (string2 == null) {
                        string2 = "";
                    }
                    this.conn.startLongText();
                    while (!string2.equals("")) {
                        this.conn.writeTextLine(string2);
                        string2 = bufferedReader.readLine();
                        if (string2 != null) continue;
                        string2 = "";
                    }
                    this.conn.writeTextEnd();
                    break;
                }
                case 4: {
                    this.conn.writeAnswer(222, l + " <" + string + "> article found - body follows.");
                    String string3 = bufferedReader.readLine();
                    if (string3 == null) {
                        string3 = "";
                    }
                    while (!string3.equals("")) {
                        string3 = bufferedReader.readLine();
                        if (string3 != null) continue;
                        string3 = "";
                    }
                    this.conn.writeText(bufferedReader);
                    break;
                }
            }
            mailDataReader.close();
        }
    }

    private final void executeXhdrCommand(Vector vector, GroupData groupData) throws IOException {
        int n = vector.size();
        this.conn.startLongText();
        int n2 = 0;
        while (n2 < n) {
            Long l = (Long)vector.elementAt(n2);
            String string = (String)groupData.articles.get(l);
            Hashtable hashtable = RFCAnalyzer.analyzeRFC(this.ci.basis, this.ci.basis.getFileFromMsgid(string));
            if (hashtable.containsKey(this.header)) {
                Object v = hashtable.get(this.header);
                Vector vector2 = null;
                if (v instanceof Vector) {
                    vector2 = (Vector)v;
                } else {
                    vector2 = new Vector();
                    vector2.addElement(v);
                }
                String string2 = l.toString() + " " + vector2.elementAt(0).toString();
                int n3 = 1;
                while (n3 < vector2.size()) {
                    string2 = string2 + " " + vector2.elementAt(n3).toString();
                    ++n3;
                }
                this.conn.writePureLine(string2);
            }
            ++n2;
        }
        this.conn.endLongText();
    }

    private final void executeXoverCommand(Vector vector, GroupData groupData) throws IOException {
        int n = vector.size();
        MailDataRepository mailDataRepository = this.ci.basis.repository();
        this.conn.startLongText();
        int n2 = 0;
        while (n2 < n) {
            Long l = (Long)vector.elementAt(n2);
            String string = (String)groupData.articles.get(l);
            long l2 = this.ci.basis.getFileFromMsgid(string);
            Hashtable hashtable = RFCAnalyzer.analyzeRFC(this.ci.basis, l2);
            String string2 = l.toString() + "\t";
            string2 = string2 + this.headerToXoverLine(hashtable.get("subject")) + "\t";
            string2 = string2 + this.headerToXoverLine(hashtable.get("from")) + "\t";
            string2 = string2 + this.headerToXoverLine(hashtable.get("date")) + "\t";
            string2 = string2 + this.headerToXoverLine(hashtable.get("message-id")) + "\t";
            string2 = string2 + this.headerToXoverLine(hashtable.get("references")) + "\t";
            string2 = string2 + new Long(mailDataRepository.size(l2)).toString() + "\t";
            string2 = string2 + this.headerToXoverLine(hashtable.get("lines")) + "\t";
            string2 = string2 + "Xref: " + this.headerToXoverLine(hashtable.get("xref"));
            this.conn.writePureLine(string2);
            ++n2;
        }
        this.conn.endLongText();
    }

    private final String headerToXoverLine(Object object) {
        int n;
        Serializable serializable;
        if (object == null) {
            return "";
        }
        if (object instanceof Vector) {
            serializable = (Vector)object;
            String string = ((Vector)serializable).elementAt(0).toString();
            int n2 = 1;
            while (n2 < ((Vector)serializable).size()) {
                string = string + " " + ((Vector)serializable).elementAt(n2).toString();
                ++n2;
            }
            object = string;
        }
        if (!(object instanceof String)) {
            return "";
        }
        serializable = new StringBuffer((String)object);
        while ((n = ((StringBuffer)serializable).toString().indexOf(9)) != -1) {
            ((StringBuffer)serializable).setCharAt(n, ' ');
        }
        while ((n = ((StringBuffer)serializable).toString().indexOf(10)) != -1) {
            ((StringBuffer)serializable).setCharAt(n, ' ');
        }
        while ((n = ((StringBuffer)serializable).toString().indexOf(13)) != -1) {
            ((StringBuffer)serializable).setCharAt(n, ' ');
        }
        return ((StringBuffer)serializable).toString().trim();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NNTPCommand(String string, ServerConnection serverConnection, NNTPConnectionInfo nNTPConnectionInfo) {
        this.ci = nNTPConnectionInfo;
        this.conn = serverConnection;
        this.contents = string;
        if (string == null) {
            this.code = 1;
            return;
        }
        if ((string = string.trim()).equals("")) {
            this.code = 99;
            return;
        }
        int n = string.indexOf(32);
        String string2 = null;
        String string3 = null;
        if (n == -1) {
            string2 = string.toUpperCase();
        } else {
            string2 = string.substring(0, n).toUpperCase();
            string3 = string.substring(n + 1);
        }
        this.code = string2.equals("QUIT") ? 1 : (string2.equals("ARTICLE") ? 2 : (string2.equals("HEAD") ? 3 : (string2.equals("BODY") ? 4 : (string2.equals("STAT") ? 5 : (string2.equals("GROUP") ? 6 : (string2.equals("HELP") ? 7 : (string2.equals("IHAVE") ? 8 : (string2.equals("SLAVE") ? 9 : (string2.equals("LAST") ? 10 : (string2.equals("LIST") ? 11 : (string2.equals("NEWGROUPS") ? 12 : (string2.equals("NEWNEWS") ? 13 : (string2.equals("NEXT") ? 14 : (string2.equals("POST") ? 15 : (string2.equals("XOVER") ? 21 : (string2.equals("XHDR") ? 20 : 0))))))))))))))));
        switch (this.code) {
            case 0: {
                this.error = true;
                return;
            }
            case 1: 
            case 7: 
            case 9: 
            case 10: 
            case 14: 
            case 15: {
                if (string3 == null) return;
                this.error = true;
                return;
            }
            case 20: {
                if (string3 == null) {
                    this.error = true;
                    return;
                }
                string3 = string3.trim();
                String string4 = null;
                int n2 = string3.indexOf(32);
                if (n2 != -1) {
                    this.header = string3.substring(0, n2);
                    string4 = string3.substring(n2).trim();
                    if (string4.equals("")) {
                        string4 = null;
                    }
                } else {
                    this.header = string3;
                }
                this.header = this.header.toLowerCase();
                if (string4 == null) {
                    this.start = -1L;
                    this.stop = -1L;
                    this.msgid = null;
                    return;
                }
                if (string4.charAt(0) == '<') {
                    if (string4.charAt(string4.length() - 1) != '>') {
                        this.error = true;
                        return;
                    }
                    this.start = -1L;
                    this.stop = -1L;
                    this.msgid = string4.substring(1, string4.length() - 1);
                    return;
                }
                this.msgid = null;
                n2 = string4.indexOf(45);
                if (n2 == -1) {
                    try {
                        this.stop = this.start = Long.parseLong(string4);
                        return;
                    }
                    catch (Exception exception) {
                        this.error = true;
                        return;
                    }
                }
                String string5 = string4.substring(0, n2).trim();
                try {
                    this.start = Long.parseLong(string5);
                }
                catch (Exception exception) {
                    this.error = true;
                    return;
                }
                string4 = string4.substring(n2 + 1).trim();
                if (string4.equals("")) {
                    string4 = null;
                }
                if (string4 == null) {
                    this.stop = -1L;
                    return;
                }
                try {
                    this.stop = Long.parseLong(string4);
                    return;
                }
                catch (Exception exception) {
                    this.error = true;
                    return;
                }
            }
            case 21: {
                if (string3 == null) {
                    this.start = -1L;
                    this.stop = -1L;
                    return;
                }
                String string6 = string3.trim();
                int n3 = string6.indexOf(45);
                if (n3 == -1) {
                    try {
                        this.stop = this.start = Long.parseLong(string6);
                        return;
                    }
                    catch (Exception exception) {
                        this.error = true;
                        return;
                    }
                }
                String string7 = string6.substring(0, n3).trim();
                try {
                    this.start = Long.parseLong(string7);
                }
                catch (Exception exception) {
                    this.error = true;
                    return;
                }
                string6 = string6.substring(n3 + 1).trim();
                if (string6.equals("")) {
                    string6 = null;
                }
                if (string6 == null) {
                    this.stop = -1L;
                    return;
                }
                try {
                    this.stop = Long.parseLong(string6);
                    return;
                }
                catch (Exception exception) {
                    this.error = true;
                    return;
                }
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (string3 == null) {
                    this.useInternalArticlePointer = true;
                    return;
                }
                if ((string3 = string3.trim()).charAt(0) == '<') {
                    if (string3.charAt(string3.length() - 1) == '>' && string3.indexOf(32) == -1) {
                        this.msgid = string3.substring(1, string3.length() - 1);
                        return;
                    }
                    this.error = true;
                    return;
                }
                if (string3.indexOf(32) != -1) {
                    this.error = true;
                }
                try {
                    this.articleNumber = Long.parseLong(string3);
                    return;
                }
                catch (Exception exception) {
                    this.error = true;
                    return;
                }
            }
            case 6: {
                if (string3 == null) {
                    this.error = true;
                    return;
                }
                if ((string3 = string3.trim()).indexOf(32) != -1) {
                    this.error = true;
                    return;
                }
                this.group = string3;
                return;
            }
            case 8: {
                if (string3 == null) {
                    this.error = true;
                    return;
                }
                if ((string3 = string3.trim()).indexOf(32) == -1 && string3.charAt(0) == '<' && string3.charAt(string3.length() - 1) == '>') {
                    this.group = string3.substring(1, string3.length() - 1);
                    return;
                }
                this.error = true;
                return;
            }
            case 12: {
                if (string3 == null) {
                    this.error = true;
                    return;
                }
                int n4 = (string3 = string3.trim()).indexOf(32);
                if (n4 != 6) {
                    this.error = true;
                    return;
                }
                String string8 = string3.substring(0, n4);
                if ((n4 = (string3 = string3.substring(n4 + 1)).indexOf(32)) == -1) {
                    n4 = 6;
                }
                if (n4 != 6) {
                    this.error = true;
                    return;
                }
                String string9 = string3.substring(0, n4);
                string3 = string3.length() == 6 ? "" : string3.substring(n4 + 1).trim();
                int n5 = Integer.valueOf(string8.substring(0, 2));
                n5 = n5 < 50 ? (n5 += 2000) : (n5 += 1900);
                int n6 = Integer.valueOf(string8.substring(2, 4));
                int n7 = Integer.valueOf(string8.substring(4, 6));
                int n8 = Integer.valueOf(string9.substring(0, 2));
                int n9 = Integer.valueOf(string9.substring(2, 4));
                int n10 = Integer.valueOf(string9.substring(4, 6));
                GregorianCalendar gregorianCalendar = null;
                if (string3.equals("")) {
                    gregorianCalendar = new GregorianCalendar(n5, n6, n7, n8, n9, n10);
                } else if (string3.toUpperCase().equals("[GMT]")) {
                    gregorianCalendar = new GregorianCalendar(new SimpleTimeZone(0, "GMT"));
                    gregorianCalendar.set(n5, n6, n7, n8, n9, n10);
                } else {
                    this.error = true;
                }
                this.date = gregorianCalendar.getTime();
                return;
            }
            case 13: {
                return;
            }
            case 11: {
                String string10;
                if (string3 == null) return;
                int n11 = (string3 = string3.trim()).indexOf(32);
                if (n11 != -1) {
                    string10 = string3.substring(0, n11);
                    if ((string3 = string3.substring(n11).trim()).equals("")) {
                        string3 = null;
                    }
                } else {
                    string10 = string3;
                    string3 = null;
                }
                string10 = string10.toUpperCase();
                if (string10.equals("ACTIVE")) {
                    this.code = 30;
                    return;
                }
                if (string10.equals("ACTIVE.TIMES")) {
                    this.code = 31;
                    return;
                }
                if (string10.equals("DISTRIBUTIONS")) {
                    this.code = 32;
                    return;
                }
                if (string10.equals("DISTRIB.PATS")) {
                    this.code = 33;
                    return;
                }
                if (string10.equals("NEWSGROUPS")) {
                    this.code = 34;
                    return;
                }
                if (string10.equals("OVERVIEW.FMT")) {
                    this.code = 35;
                    return;
                }
                if (string10.equals("SUBSCRIPTIONS")) {
                    this.code = 36;
                    return;
                }
                this.code = 0;
                return;
            }
        }
    }
}

