/*
 * Decompiled with CFR 0.152.
 */
package net.ibm.malamut.newsmail;

import java.io.IOException;
import java.net.Socket;
import net.ibm.malamut.newsmail.Basis;
import net.ibm.malamut.newsmail.GenericConnectionServer;
import net.ibm.malamut.newsmail.NNTPCommand;
import net.ibm.malamut.newsmail.NNTPConnectionInfo;
import net.ibm.malamut.newsmail.Tools;
import net.ibm.malamut.newsmail.connections.ServerConnection;

public final class NNTPConnectionServer
extends GenericConnectionServer {
    private boolean canWrite = true;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void abort() {
        try {
            this.conn.writePanikAnswer(400, Tools.getLocalHostName() + " Service shutting down, sorry.");
        }
        catch (IOException iOException) {
        }
        this.conn.close();
        this.alive = false;
    }

    public final void serve(ServerConnection serverConnection) throws IOException {
        NNTPConnectionInfo nNTPConnectionInfo = new NNTPConnectionInfo();
        nNTPConnectionInfo.basis = this.basis;
        nNTPConnectionInfo.writeAllowed = this.canWrite;
        if (this.canWrite) {
            serverConnection.writeAnswer(200, Tools.getLocalHostName() + " Kroni's Newsserver welcomes you - Posting allowed");
        } else {
            serverConnection.writeAnswer(201, Tools.getLocalHostName() + " Kroni's Newsserver welcomes you - You have read only access");
        }
        while (this.alive) {
            NNTPCommand nNTPCommand = new NNTPCommand(serverConnection.readCommand(), serverConnection, nNTPConnectionInfo);
            nNTPCommand.execute();
            if (nNTPCommand.code() != 1) continue;
            this.alive = false;
        }
    }

    public NNTPConnectionServer(Socket socket, Basis basis) {
        super(socket, basis);
    }
}

