/*
 * Decompiled with CFR 0.152.
 */
package net.ibm.malamut.newsmail;

import java.util.Vector;
import net.ibm.malamut.newsmail.Basis;
import net.ibm.malamut.newsmail.Tools;
import net.ibm.malamut.newsmail.version.CommonConstants;

public final class WriteSynchronizer {
    private Basis basis;
    private Object lock = new Object();
    private Vector waiting = new Vector();
    private int writing = 0;
    private Thread writingThread = null;
    private Vector readers = new Vector();
    private int timeout = CommonConstants.debugL ? 30000 : 300000;

    private final void deadlockWarning() {
        Tools.log("Possible deadlock detected! Current stack:", new Throwable());
    }

    public final void endRead() {
        Object object = this.lock;
        synchronized (object) {
            Thread thread = Thread.currentThread();
            this.readers.removeElement(thread);
            this.lock.notifyAll();
        }
    }

    public final void endWrite() {
        Object object = this.lock;
        synchronized (object) {
            --this.writing;
            if (this.writing == 0) {
                this.writingThread = null;
            }
            this.lock.notifyAll();
        }
    }

    private final boolean otherReaders(Thread thread) {
        int n = 0;
        while (n < this.readers.size()) {
            if (thread != this.readers.elementAt(n)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void startRead() {
        var1_1 = this.lock;
        synchronized (var1_1) {
            var3_2 = Thread.currentThread();
            if (this.writing <= 0 || this.writingThread == var3_2) {
                this.readers.addElement(var3_2);
lbl7:
                // 2 sources

                return;
            }
            this.waiting.addElement(var3_2);
            var4_3 = System.currentTimeMillis();
            if (true) ** GOTO lbl22
            do {
                try {
                    this.lock.wait(this.timeout);
                }
                catch (InterruptedException var6_4) {
                }
                if (System.currentTimeMillis() - var4_3 <= (long)this.timeout) continue;
                this.deadlockWarning();
lbl22:
                // 3 sources

            } while (this.writing > 0 || this.waiting.elementAt(0) != var3_2);
            this.waiting.removeElementAt(0);
            this.readers.addElement(var3_2);
            this.lock.notifyAll();
            ** continue;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void startWrite() {
        Object object = this.lock;
        synchronized (object) {
            Thread thread = Thread.currentThread();
            if (this.writingThread == thread) {
                ++this.writing;
            } else if (this.writing == 0 && !this.otherReaders(thread)) {
                this.writingThread = thread;
                this.writing = 1;
            } else {
                this.waiting.addElement(thread);
                long l = System.currentTimeMillis();
                while (true) {
                    if (this.writing <= 0 && !this.otherReaders(thread) && this.waiting.elementAt(0) == thread) {
                        this.waiting.removeElementAt(0);
                        this.writing = 1;
                        this.writingThread = thread;
                        this.lock.notifyAll();
                        break;
                    }
                    try {
                        this.lock.wait(this.timeout);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    if (System.currentTimeMillis() - l <= (long)this.timeout) continue;
                    this.deadlockWarning();
                }
            }
            return;
        }
    }

    public WriteSynchronizer(Basis basis) {
        this.basis = basis;
    }
}

