/*
 * Decompiled with CFR 0.152.
 */
package net.ibm.malamut.newsmail.connections;

import java.io.IOException;
import java.util.Hashtable;
import net.ibm.malamut.newsmail.Basis;
import net.ibm.malamut.newsmail.ConnectionData;
import net.ibm.malamut.newsmail.connections.AbstractConnection;
import net.ibm.malamut.newsmail.connections.NNTPDownloadConnectionThread;

public class NNTPDownloadConnection
extends AbstractConnection {
    private boolean writeAllowed;
    private String[] currentGroup;
    private long[] currentArticle;
    private NNTPDownloadConnectionThread[] dct;
    private String group = "";
    private String error = null;
    private Object lock = new Object();
    private int previousFreeThread = 0;

    private final String checkAnswer(int n, int n2) throws IOException {
        String string = this.thread[n].getLine();
        if (!string.startsWith(new Integer(n2).toString())) {
            throw new IOException(string);
        }
        return string;
    }

    private final boolean checkAnswer(int n, int n2, int n3) throws IOException {
        String string = this.thread[n].getLine();
        if (string.startsWith(new Integer(n2).toString())) {
            return true;
        }
        if (string.startsWith(new Integer(n3).toString())) {
            return false;
        }
        throw new IOException(string);
    }

    protected void doCancel(int n, int n2) throws IOException {
        this.thread[n2].cancel();
        this.doClose(n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doClose(int n) throws IOException {
        this.thread[n].prepareForClosing();
        try {
            this.thread[n].writeCommand("quit");
            this.thread[n].getLine();
            this.dct[n].close();
        }
        catch (IOException iOException) {
        }
        this.thread[n].close();
    }

    protected void doLogin(int n) throws IOException {
        this.writeAllowed = this.checkAnswer(n, 200, 201);
    }

    public void finish() throws IOException {
        int n = 0;
        while (n < this.dct.length) {
            this.dct[n].finish();
            this.currentGroup[n] = null;
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getArticle(long l) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            while (true) {
                int n;
                if ((n = this.getFreeThread()) != -1) {
                    if (!this.group.equals(this.currentGroup[n])) {
                        this.currentGroup[n] = this.group;
                        this.thread[n].writeCommand("group " + this.group);
                        this.checkAnswer(n, 211);
                    }
                    this.currentArticle[n] = l;
                    this.dct[n].readMail(l);
                    return;
                }
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    private final int getFreeThread() throws IOException {
        int n = this.previousFreeThread + 1;
        while (n < this.dct.length) {
            if (this.dct[n].ready()) {
                this.previousFreeThread = n;
                return n;
            }
            ++n;
        }
        n = 0;
        while (n <= this.previousFreeThread) {
            if (this.dct[n].ready()) {
                this.previousFreeThread = n;
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Hashtable getUnfinishedArticles() {
        Hashtable<String, Long> hashtable = new Hashtable<String, Long>();
        int n = 0;
        while (n < this.currentGroup.length) {
            String string = this.currentGroup[n];
            if (string != null) {
                long l = this.currentArticle[n];
                Long l2 = new Long(l);
                Long l3 = (Long)hashtable.get(string);
                if (l3 == null) {
                    hashtable.put(string, l2);
                } else if (l3 > l) {
                    hashtable.put(string, l2);
                }
            }
            ++n;
        }
        return hashtable;
    }

    public void jumpGroup(String string) {
        Object object = this.lock;
        synchronized (object) {
            this.group = string;
        }
    }

    public NNTPDownloadConnection(ConnectionData connectionData, Basis basis, String string, int n, int n2, int n3) {
        super(string, 119, n, n2, n3);
        this.currentGroup = new String[n3];
        this.currentArticle = new long[n3];
        this.dct = new NNTPDownloadConnectionThread[n3];
        int n4 = 0;
        while (n4 < n3) {
            this.dct[n4] = new NNTPDownloadConnectionThread(connectionData, basis, this.lock, string, this.thread[n4]);
            ++n4;
        }
    }
}

