/*
 * Decompiled with CFR 0.152.
 */
package net.ibm.malamut.newsmail.connections;

import java.io.IOException;
import java.util.Calendar;
import java.util.Vector;
import net.ibm.malamut.newsmail.ArticleData;
import net.ibm.malamut.newsmail.Basis;
import net.ibm.malamut.newsmail.ConnectionData;
import net.ibm.malamut.newsmail.GenericAnswer;
import net.ibm.malamut.newsmail.GroupData;
import net.ibm.malamut.newsmail.MailDataWriter;
import net.ibm.malamut.newsmail.NNTPAnswer;
import net.ibm.malamut.newsmail.Tools;
import net.ibm.malamut.newsmail.connections.ConnectionThread;

public class NNTPDownloadConnectionThread
extends Thread {
    private String newsserver;
    private Object lock;
    private ConnectionThread th;
    private boolean keepOn = true;
    private long mail = 0L;
    private String error = null;
    private boolean waiting = false;
    private Basis basis;
    private ConnectionData cd;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.keepOn = false;
            this.lock.notifyAll();
        }
        try {
            this.join();
            return;
        }
        catch (InterruptedException interruptedException) {
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void finish() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.error != null) {
                throw new IOException(this.error);
            }
            while (true) {
                if (!this.waiting && this.mail == -1L) {
                    if (this.error == null) return;
                    throw new IOException(this.error);
                }
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readMail(long l) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.waiting = true;
            while (true) {
                if (this.ready()) {
                    this.mail = l;
                    this.waiting = false;
                    this.lock.notifyAll();
                    return;
                }
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.error != null) {
                throw new IOException(this.error);
            }
            boolean bl = this.mail == -1L;
            Object var2_3 = null;
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void retrieveFromServer(long l) throws IOException {
        this.th.writeCommand("stat " + l);
        boolean bl = true;
        GenericAnswer genericAnswer = null;
        while (true) {
            if (!bl) {
                if (genericAnswer.code() == 223) break;
                return;
            }
            genericAnswer = new NNTPAnswer(this.th.getLine());
            if (!genericAnswer.good()) {
                throw new IOException("An error occurred reading article No. " + l);
            }
            if (genericAnswer.ignoreMe()) continue;
            bl = false;
        }
        if (this.basis.existsMsgid(((NNTPAnswer)genericAnswer).msgid())) return;
        ArticleData articleData = new ArticleData();
        articleData.file = this.basis.getNextArticleFile();
        articleData.received = Calendar.getInstance().getTime();
        this.th.writeCommand("article " + l);
        bl = true;
        while (true) {
            if (!bl) {
                if (genericAnswer.code() == 220) break;
                return;
            }
            genericAnswer = new NNTPAnswer(this.th.getLine());
            if (!genericAnswer.good()) {
                throw new IOException("An error occurred reading article No. " + l);
            }
            if (genericAnswer.ignoreMe()) continue;
            bl = false;
        }
        MailDataWriter mailDataWriter = new MailDataWriter(this.basis.repository(), articleData.file);
        try {
            this.th.getText(mailDataWriter.getWriter());
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            mailDataWriter.close();
            throw throwable;
        }
        mailDataWriter.close();
        Vector vector = this.basis.getGroupsForArticle(articleData.file);
        if (vector.size() == 0) {
            throw new IOException("Article No. " + l + " is corrupt!");
        }
        String string = "Xref: " + Tools.getLocalHostName() + " ";
        int n = 0;
        while (true) {
            if (n >= vector.size()) {
                this.basis.changeXrefLine(articleData.file, string);
                this.basis.addMsgid(((NNTPAnswer)genericAnswer).msgid(), articleData);
                this.basis.addToOutnews(this.newsserver, ((NNTPAnswer)genericAnswer).msgid());
                ++this.cd.receivedArticles;
                return;
            }
            String string2 = (String)vector.elementAt(n);
            GroupData groupData = this.basis.getGroupData(string2);
            if (groupData != null) {
                this.basis.groups().sync().startWrite();
                ++groupData.lastArticle;
                groupData.articles.put(new Long(groupData.lastArticle), ((NNTPAnswer)genericAnswer).msgid());
                this.basis.groups().sync().endWrite();
                string = string + string2 + ":" + groupData.lastArticle;
            }
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (true) lbl-1000:
            // 3 sources

            {
                var1_1 = this.lock;
                synchronized (var1_1) {
                    if (!this.keepOn) {
                        return;
                    }
                    this.mail = -1L;
                    this.lock.notifyAll();
                    while (true) {
                        if (this.mail != -1L || !this.keepOn) {
                            if (this.keepOn) break;
                            return;
                        }
                        try {
                            this.lock.wait();
                        }
                        catch (InterruptedException var3_5) {
                        }
                    }
                }
                try {
                    this.retrieveFromServer(this.mail);
                    continue;
                }
                catch (IOException var1_2) {
                    var2_4 = this.lock;
                    synchronized (var2_4) {
                        this.error = var1_2.getMessage();
                        this.lock.notifyAll();
                        continue;
                    }
                }
                break;
            }
        }
        catch (Throwable var1_3) {
            Tools.log("Internal error in NNTPDownloadConnection.run():", var1_3);
            return;
        }
        {
            ** while (true)
        }
    }

    public NNTPDownloadConnectionThread(ConnectionData connectionData, Basis basis, Object object, String string, ConnectionThread connectionThread) {
        this.cd = connectionData;
        this.newsserver = string;
        this.basis = basis;
        this.lock = object;
        this.th = connectionThread;
        this.start();
    }
}

