/*
 * Decompiled with CFR 0.152.
 */
package net.ibm.malamut.newsmail.connections;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Vector;
import net.ibm.malamut.newsmail.Basis;
import net.ibm.malamut.newsmail.MailDataWriter;
import net.ibm.malamut.newsmail.connections.AbstractConnection;
import net.ibm.malamut.newsmail.connections.ConnectionThread;
import net.ibm.malamut.newsmail.ui.ProgressBarPanel;

public class POPConnection
extends AbstractConnection {
    private int SCANNED = 10;
    private String user;
    private String pass;
    private long mailboxSize;
    private int numberOfMails;
    private Vector mailSizes;
    private Vector ids = null;
    private Vector skip;
    private ConnectionThread th;
    private boolean breakPossible = false;

    public boolean breakPossible() {
        return this.breakPossible;
    }

    private final void checkAnswer() throws IOException {
        String string = this.th.getLine();
        if (!string.startsWith("+OK")) {
            throw new IOException(string);
        }
    }

    public void deleteMail(int n, ProgressBarPanel progressBarPanel) throws IOException {
        progressBarPanel.setText("Removing mail No." + (n + 1) + " from remote server...");
        progressBarPanel.setArea(0, 2);
        progressBarPanel.setValue(1);
        this.th.writeCommand("DELE " + (n + 1));
        this.th.getLine();
        progressBarPanel.setValue(2);
    }

    protected void doCancel(int n, int n2) throws IOException {
        this.th.cancel();
        this.doClose(n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doClose(int n) throws IOException {
        this.th.prepareForClosing();
        try {
            this.th.writeCommand("quit");
            this.th.getLine();
        }
        catch (IOException iOException) {
        }
        this.th.close();
    }

    protected void doLogin(int n) throws IOException {
        this.checkAnswer();
        this.th.writeCommand("USER " + this.user);
        this.checkAnswer();
        this.th.writeCommand("PASS " + this.pass);
        this.checkAnswer();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getMail(int n, long l, ProgressBarPanel progressBarPanel, String string, Basis basis) throws IOException {
        try {
            Object e = this.ids.elementAt(n);
            if (this.skip.contains(e)) {
                return 0;
            }
            this.skip.addElement(e);
        }
        catch (Throwable throwable) {
        }
        long l2 = (Long)this.mailSizes.elementAt(n);
        progressBarPanel.setText("Receiving mail No." + (n + 1) + " (" + l2 + " Bytes)...");
        progressBarPanel.setArea(0, (int)(l2 + 1L));
        progressBarPanel.setValue(1);
        this.th.writeCommand("RETR " + (n + 1));
        this.checkAnswer();
        MailDataWriter mailDataWriter = new MailDataWriter(basis.repository(), l);
        if (string != null) {
            mailDataWriter.getWriter().write("X-ZC-EMP: " + string + "\r\n");
        }
        this.th.getText(mailDataWriter.getWriter(), progressBarPanel, (int)l2);
        mailDataWriter.close();
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getMail(int n, ProgressBarPanel progressBarPanel, String string, Basis basis) throws IOException {
        try {
            Object e = this.ids.elementAt(n);
            if (this.skip.contains(e)) {
                return 0;
            }
            this.skip.addElement(e);
        }
        catch (Throwable throwable) {
        }
        long l = (Long)this.mailSizes.elementAt(n);
        progressBarPanel.setText("Receiving mail No." + (n + 1) + " (" + l + " Bytes)...");
        progressBarPanel.setArea(0, (int)(l + 1L));
        progressBarPanel.setValue(1);
        this.th.writeCommand("RETR " + (n + 1));
        this.checkAnswer();
        long l2 = basis.getNextArticleFile();
        MailDataWriter mailDataWriter = new MailDataWriter(basis.repository(), l2);
        if (string != null) {
            mailDataWriter.getWriter().write("X-ZC-EMP: " + string + "\r\n");
        }
        this.th.getText(mailDataWriter.getWriter(), progressBarPanel, (int)l);
        mailDataWriter.close();
        return l2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int scanMailbox() throws IOException {
        int n;
        this.th.writeCommand("LIST");
        this.checkAnswer();
        StringWriter stringWriter = new StringWriter();
        BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
        this.th.getText(bufferedWriter);
        bufferedWriter.close();
        stringWriter.close();
        BufferedReader bufferedReader = new BufferedReader(new StringReader(stringWriter.toString()));
        String string = bufferedReader.readLine();
        this.mailSizes = new Vector();
        this.mailboxSize = 0L;
        while (string != null) {
            n = string.indexOf(32);
            if (n == -1) {
                throw new IOException("Received illegal input on LIST command");
            }
            try {
                Long l = new Long(string.substring(n + 1));
                this.mailSizes.addElement(l);
                this.mailboxSize += l.longValue();
            }
            catch (Exception exception) {
                throw new IOException("Received illegal input on LIST command");
            }
            string = bufferedReader.readLine();
        }
        this.numberOfMails = this.mailSizes.size();
        this.th.writeCommand("UIDL");
        try {
            this.checkAnswer();
        }
        catch (IOException iOException) {
            if (!iOException.getMessage().startsWith("-ERR")) {
                throw iOException;
            }
            return this.numberOfMails;
        }
        this.breakPossible = true;
        stringWriter = new StringWriter();
        bufferedWriter = new BufferedWriter(stringWriter);
        this.th.getText(bufferedWriter);
        bufferedWriter.close();
        stringWriter.close();
        bufferedReader = new BufferedReader(new StringReader(stringWriter.toString()));
        string = bufferedReader.readLine();
        this.ids = new Vector();
        while (string != null) {
            n = string.indexOf(32);
            if (n == -1) {
                throw new IOException("Received illegal input on UIDL command");
            }
            this.ids.addElement(string.substring(n + 1));
            string = bufferedReader.readLine();
        }
        return this.numberOfMails;
    }

    public POPConnection(String string, int n, int n2, String string2, String string3) {
        super(string, 110, n, n2);
        this.user = string2;
        this.pass = string3;
        this.skip = new Vector();
        this.th = this.thread[0];
    }

    public POPConnection(String string, int n, int n2, String string2, String string3, POPConnection pOPConnection) {
        super(string, 110, n, n2);
        this.user = string2;
        this.pass = string3;
        this.skip = pOPConnection == null ? new Vector() : pOPConnection.skip;
        this.th = this.thread[0];
    }
}

