/*
 * Decompiled with CFR 0.152.
 */
package net.ibm.malamut.newsmail.database;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import net.ibm.malamut.newsmail.Basis;
import net.ibm.malamut.newsmail.POPUserData;
import net.ibm.malamut.newsmail.Tools;
import net.ibm.malamut.newsmail.WriteSynchronizer;
import net.ibm.malamut.newsmail.database.GenericTable;

public class PopUserBase
extends GenericTable {
    Vector multiple = null;

    public String address(String string) {
        POPUserData pOPUserData = this.get(string);
        if (pOPUserData != null) {
            return pOPUserData.email;
        }
        return null;
    }

    public void addUser(String string, POPUserData pOPUserData) {
        if (this.multiple == null) {
            this.put(string, pOPUserData);
        } else {
            Tools.log("Internal error: addUser called on multiple server PopUserBase.");
        }
    }

    public boolean exists(String string) {
        this.sync.startRead();
        boolean bl = this.data.containsKey(string);
        this.sync.endRead();
        return bl;
    }

    public void fillTextFields(String string, JTextField jTextField, JPasswordField jPasswordField, JPasswordField jPasswordField2, JTextField jTextField2) {
        POPUserData pOPUserData = this.get(string);
        if (pOPUserData != null) {
            ((JTextComponent)jPasswordField).setText(pOPUserData.localPass);
            jTextField.setText(pOPUserData.remoteName);
            ((JTextComponent)jPasswordField2).setText(pOPUserData.remotePass);
            if (pOPUserData.email != null) {
                jTextField2.setText(pOPUserData.email);
            }
        }
    }

    private final POPUserData get(String string) {
        Object object = super.get(string);
        if (object == null) {
            return null;
        }
        if (object instanceof POPUserData) {
            return (POPUserData)object;
        }
        this.error();
        return null;
    }

    public String localPassword(String string) {
        String string2 = null;
        this.sync.startRead();
        POPUserData pOPUserData = this.get(string);
        if (pOPUserData != null) {
            string2 = pOPUserData.localPass;
        }
        this.sync.endRead();
        return string2;
    }

    public String remoteName(String string) {
        POPUserData pOPUserData = this.get(string);
        if (pOPUserData != null) {
            return pOPUserData.remoteName;
        }
        return null;
    }

    public String remotePass(String string) {
        POPUserData pOPUserData = this.get(string);
        if (pOPUserData != null) {
            return pOPUserData.remotePass;
        }
        return null;
    }

    public void remove(String string) {
        this.sync.startWrite();
        this.data.remove(string);
        if (this.multiple != null) {
            int n = 0;
            while (n < this.multiple.size()) {
                ((PopUserBase)this.multiple.elementAt((int)n)).data.remove(string);
                ++n;
            }
        }
        this.sync.endWrite();
    }

    public boolean removeFromRemoteFor(String string) {
        POPUserData pOPUserData = this.get(string);
        if (pOPUserData != null) {
            return pOPUserData.removeFromServer;
        }
        return false;
    }

    public PopUserBase uniteWith(PopUserBase popUserBase) {
        Object k;
        if (popUserBase == null) {
            return this;
        }
        if (this.multiple == null) {
            this.multiple = new Vector();
            this.multiple.addElement(this);
        }
        if (popUserBase.multiple == null) {
            this.multiple.addElement(popUserBase);
        } else {
            int n = 0;
            while (n < popUserBase.multiple.size()) {
                this.multiple.addElement(popUserBase.multiple.elementAt(n));
                ++n;
            }
        }
        Hashtable hashtable = new Hashtable();
        this.sync.startRead();
        Enumeration enumeration = this.data.keys();
        while (enumeration.hasMoreElements()) {
            k = enumeration.nextElement();
            hashtable.put(k, this.data.get(k));
        }
        enumeration = popUserBase.data.keys();
        while (enumeration.hasMoreElements()) {
            k = enumeration.nextElement();
            hashtable.put(k, popUserBase.data.get(k));
        }
        popUserBase.sync.endRead();
        return new PopUserBase(this.basis, hashtable, "PopUser-several", this.sync);
    }

    public Vector users() {
        Vector vector = new Vector(this.data.size());
        this.sync.startRead();
        Enumeration enumeration = this.data.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (k instanceof String) {
                vector.addElement(k);
                continue;
            }
            this.error();
        }
        this.sync.endRead();
        return vector;
    }

    public Hashtable usersAsHashtable() {
        int n = this.data.size();
        Hashtable hashtable = n > 0 ? new Hashtable(n) : new Hashtable();
        Object object = new Object();
        this.sync.startRead();
        Enumeration enumeration = this.data.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (k instanceof String) {
                hashtable.put(k, object);
                continue;
            }
            this.error();
        }
        this.sync.endRead();
        return hashtable;
    }

    public Vector usersForAddress(String string) {
        String string2 = string.toLowerCase().trim();
        Vector vector = new Vector();
        this.sync.startRead();
        Enumeration enumeration = this.data.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            POPUserData pOPUserData = (POPUserData)this.data.get(k);
            if (!string2.startsWith(pOPUserData.email.toLowerCase())) continue;
            vector.addElement(k);
        }
        this.sync.endRead();
        return vector;
    }

    public PopUserBase(Basis basis, Hashtable hashtable, String string, WriteSynchronizer writeSynchronizer) {
        super(basis, hashtable, string, writeSynchronizer);
    }
}

