/*
 * Decompiled with CFR 0.152.
 */
package net.ibm.malamut.newsmail.ui;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import net.ibm.malamut.newsmail.OptionsData;
import net.ibm.malamut.newsmail.WindowData;
import net.ibm.malamut.newsmail.ui.CenterBox;
import net.ibm.malamut.newsmail.ui.LabeledField;
import net.ibm.malamut.newsmail.ui.LocalNewsserverAdminListener;
import net.ibm.malamut.newsmail.ui.LocalNewsserverAdminPanel;
import net.ibm.malamut.newsmail.ui.OptionsListener;
import net.ibm.malamut.newsmail.ui.OptionsPanelFocusListener;
import net.ibm.malamut.newsmail.ui.Shell;
import net.ibm.malamut.newsmail.ui.WindowDataDefaultInterface;
import net.ibm.malamut.newsmail.ui.WindowDataDialog;

public final class OptionsPanel
extends JPanel {
    private Shell shell;
    private JDialog dialog;
    private JPanel database;
    private JPanel tcpip;
    private JPanel newsserver;
    private JPanel appearance;
    private JPanel locales;
    private JPanel superuser;
    private JTextField dataDir;
    private JTextField mrFileSize;
    private JTextField nameCfgFile;
    private JTextField readerThreads;
    private JTextField retries;
    private JTextField timeout;
    private JTextField failureAllowed;
    private JTextField superuserAddress;
    private JTextField connectionTimeout;
    private JTextField serverTimeout;
    private JPasswordField superuserPassword;
    private JButton chooseCfgFile;
    private JButton ok;
    private JButton newsserverGroupAdmin;
    private JCheckBox sendToAll;
    private JCheckBox forwardToAll;
    private JCheckBox saveWinPos;
    private JCheckBox removeWinPos;
    private JCheckBox doBackup;
    private JRadioButton defaultCp850Font;
    private JRadioButton defaultIsoFont;
    private OptionsData data;
    private JComboBox defaultIsoFontChooser;
    private final String separator = System.getProperty("file.separator");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void action() throws RemoteException {
        File file = new File(this.dataDir.getText());
        this.data.dataDir = file.getAbsolutePath();
        if (!this.data.dataDir.endsWith(this.separator)) {
            this.data.dataDir = this.data.dataDir + this.separator;
        }
        this.data.configFileName = this.nameCfgFile.getText();
        this.data.sendToAll = this.sendToAll.isSelected();
        this.data.forwardToAll = this.forwardToAll.isSelected();
        this.data.saveWindowPos = this.saveWinPos.isSelected();
        this.data.deleteWindowPos = this.removeWinPos.isSelected();
        this.data.doBackup = this.doBackup.isSelected();
        this.data.readThreads = this.readInt(this.data.readThreads, this.readerThreads, "Invalid number of reader threads");
        this.data.retries = this.readInt(this.data.retries, this.retries, "Invalid number of retries");
        this.data.timeout = this.readInt(this.data.timeout, this.timeout, "Invalid transmission timeout value");
        this.data.serverTimeout = this.readInt(this.data.serverTimeout, this.serverTimeout, "Invalid server timeout value");
        this.data.connectionTimeout = this.readInt(this.data.connectionTimeout, this.connectionTimeout, "Invalid connection timeout value");
        this.data.failureAllowed = this.readInt(this.data.failureAllowed, this.failureAllowed, "Invalid maximum sum of transmission errors");
        this.data.maxRepositoryFileSize = 1024 * this.readInt(this.data.maxRepositoryFileSize / 1024, this.mrFileSize, "Invalid repository file size granularity");
        this.data.defaultFont = this.defaultCp850Font.isSelected() ? 0 : this.defaultIsoFontChooser.getSelectedIndex() + 1;
        this.shell.basis().setOptions(this.data);
        try {
            this.shell.basis().writeConfigFile();
        }
        catch (IOException iOException) {
            Shell.error("Save Options", "An I/O error occurred", iOException);
        }
        this.dialog.dispose();
    }

    public final void adminLocalNewsserver() throws RemoteException {
        WindowData windowData = this.shell.basis().getWindowData("ADMINLOCALNNTPSERVER");
        WindowDataDialog windowDataDialog = new WindowDataDialog((Frame)this.shell.frame(), "Admin local newsserver", windowData, new WindowDataDefaultInterface());
        windowDataDialog.setDefaultCloseOperation(2);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        ((JComponent)windowDataDialog.getContentPane()).setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        LocalNewsserverAdminPanel localNewsserverAdminPanel = new LocalNewsserverAdminPanel(windowDataDialog, this.shell.basis().groups());
        LocalNewsserverAdminListener localNewsserverAdminListener = new LocalNewsserverAdminListener(localNewsserverAdminPanel);
        jPanel.add(localNewsserverAdminPanel);
        jPanel.add(Box.createVerticalStrut(8));
        JButton jButton = new JButton("Ok");
        jPanel.add(Shell.getOkCancelPanel(localNewsserverAdminListener, jButton));
        windowDataDialog.getContentPane().add("Center", jPanel);
        windowDataDialog.getRootPane().setDefaultButton(jButton);
        if (windowData.size.width == 0) {
            windowDataDialog.pack();
        }
        windowDataDialog.show();
    }

    public final void close() {
        this.dialog.dispose();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final int readInt(int n, JTextField jTextField, String string) {
        try {
            return Integer.parseInt(jTextField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            Shell.error("Save Options", string + "; using previous value of " + n);
            return n;
        }
    }

    public OptionsPanel(Shell shell, JDialog jDialog) throws RemoteException {
        this.shell = shell;
        this.dialog = jDialog;
        this.data = shell.basis().getOptions();
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.database = new JPanel();
        this.database.setLayout(new BoxLayout(this.database, 1));
        this.database.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.tcpip = new JPanel();
        this.tcpip.setLayout(new BoxLayout(this.tcpip, 1));
        this.tcpip.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.newsserver = new JPanel();
        this.newsserver.setLayout(new BoxLayout(this.newsserver, 1));
        this.newsserver.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.appearance = new JPanel();
        this.appearance.setLayout(new BoxLayout(this.appearance, 1));
        this.appearance.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.locales = new JPanel();
        this.locales.setLayout(new BoxLayout(this.locales, 1));
        this.locales.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.superuser = new JPanel();
        this.superuser.setLayout(new BoxLayout(this.superuser, 1));
        this.superuser.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.doBackup = new JCheckBox("Backup the database on startup");
        this.database.add(this.doBackup);
        this.doBackup.setSelected(this.data.doBackup);
        this.mrFileSize = new JTextField(5);
        this.database.add(new LabeledField("Repository File Size Granularity", this.mrFileSize, "KBytes"));
        this.mrFileSize.setText(Integer.toString(this.data.maxRepositoryFileSize / 1024));
        this.dataDir = new JTextField(20);
        this.database.add(new LabeledField("Database Directory", this.dataDir, 2));
        if (this.data.dataDir.substring(this.data.dataDir.length() - this.separator.length(), this.data.dataDir.length()).equals(this.separator)) {
            this.dataDir.setText(this.data.dataDir.substring(0, this.data.dataDir.length() - this.separator.length()));
        } else {
            this.dataDir.setText(this.data.dataDir);
        }
        this.nameCfgFile = new JTextField(20);
        this.database.add(new LabeledField("Configuration File Name", this.nameCfgFile, 1));
        this.nameCfgFile.setText(this.data.configFileName);
        this.readerThreads = new JTextField(5);
        this.tcpip.add(new LabeledField("Number of Reader Threads", this.readerThreads));
        this.readerThreads.setText(Integer.toString(this.data.readThreads));
        this.retries = new JTextField(5);
        this.tcpip.add(new LabeledField("Number of Retries on Transmission Errors", this.retries));
        this.retries.setText(Integer.toString(this.data.retries));
        this.serverTimeout = new JTextField(7);
        this.tcpip.add(new LabeledField("Server Timeout ", this.serverTimeout, " Minutes"));
        this.serverTimeout.setText(Integer.toString(this.data.serverTimeout));
        this.connectionTimeout = new JTextField(7);
        this.tcpip.add(new LabeledField("Timeout on Connections ", this.connectionTimeout, " Seconds"));
        this.connectionTimeout.setText(Integer.toString(this.data.connectionTimeout));
        this.timeout = new JTextField(7);
        this.tcpip.add(new LabeledField("Timeout on Transmission Errors ", this.timeout, " Seconds"));
        this.timeout.setText(Integer.toString(this.data.timeout));
        this.failureAllowed = new JTextField(5);
        this.tcpip.add(new LabeledField("Stop talking to server after ", this.failureAllowed, " Transmission Errors"));
        this.failureAllowed.setText(Integer.toString(this.data.failureAllowed));
        this.sendToAll = new JCheckBox("Send Posted Articles to All Attached Newsservers");
        this.newsserver.add(this.sendToAll);
        this.sendToAll.setSelected(this.data.sendToAll);
        this.forwardToAll = new JCheckBox("Forward Articles Between All Attached Newsservers");
        this.newsserver.add(this.forwardToAll);
        this.forwardToAll.setSelected(this.data.forwardToAll);
        this.newsserverGroupAdmin = new JButton("Local Newsgroup Administration...");
        this.newsserver.add(this.newsserverGroupAdmin);
        this.saveWinPos = new JCheckBox("Save Window Positions");
        this.appearance.add(this.saveWinPos);
        this.saveWinPos.setSelected(this.data.saveWindowPos);
        this.removeWinPos = new JCheckBox("Remove Window Positions");
        this.appearance.add(this.removeWinPos);
        this.removeWinPos.setSelected(this.data.deleteWindowPos);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createTitledBorder("Default font for articles"));
        this.defaultCp850Font = new JRadioButton("IBM codepage 850");
        jPanel.add(this.defaultCp850Font);
        JPanel jPanel2 = new JPanel();
        jPanel2.setAlignmentX(0.0f);
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        String[] stringArray = new String[]{"#1: West European (Latin 1)", "#2: East European (Latin 2)", "#3: South European (Latin 3)", "#4: North European (Latin 4)", "#5: Cyrillic", "#6: Arabic", "#7: Greek", "#8: Hebrew"};
        this.defaultIsoFont = new JRadioButton("iso-8859:");
        jPanel2.add(this.defaultIsoFont);
        this.defaultIsoFontChooser = new JComboBox<String>(stringArray);
        jPanel2.add(this.defaultIsoFontChooser);
        this.defaultIsoFontChooser.setEditable(false);
        if (this.data.defaultFont > 0) {
            this.defaultIsoFontChooser.setSelectedIndex(this.data.defaultFont - 1);
        }
        this.defaultIsoFont.setAlignmentY(0.5f);
        jPanel.add(jPanel2);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.defaultCp850Font);
        buttonGroup.add(this.defaultIsoFont);
        if (this.data.defaultFont == 0) {
            this.defaultCp850Font.setSelected(true);
        } else {
            this.defaultIsoFont.setSelected(true);
        }
        this.defaultIsoFontChooser.addFocusListener(new OptionsPanelFocusListener(this.defaultIsoFont));
        this.locales.add(jPanel);
        this.superuser.add(Box.createVerticalGlue());
        this.superuserAddress = new JTextField(20);
        this.superuser.add(new LabeledField("Postmaster Address", this.superuserAddress));
        this.superuserAddress.setText(this.data.superuserAddress);
        this.superuserPassword = new JPasswordField(20);
        this.superuser.add(new LabeledField("Postmaster POP password", this.superuserPassword));
        ((JTextComponent)this.superuserPassword).setText(this.data.superuserPassword);
        this.superuser.add(Box.createVerticalGlue());
        jTabbedPane.addTab("Database", new CenterBox(this.database));
        jTabbedPane.setSelectedIndex(0);
        jTabbedPane.addTab("TCP/IP", new CenterBox(this.tcpip));
        jTabbedPane.addTab("Newsserver", new CenterBox(this.newsserver));
        jTabbedPane.addTab("Appearance", new CenterBox(this.appearance));
        jTabbedPane.addTab("Locales", new CenterBox(this.locales));
        jTabbedPane.addTab("Superuser", new CenterBox(this.superuser));
        this.setLayout(new BorderLayout());
        this.add("Center", jTabbedPane);
        OptionsListener optionsListener = new OptionsListener(this);
        this.ok = new JButton("Ok");
        jDialog.getRootPane().setDefaultButton(this.ok);
        JPanel jPanel3 = Shell.getOkCancelPanel(optionsListener, this.ok);
        this.newsserverGroupAdmin.addActionListener(optionsListener);
        this.add("South", jPanel3);
    }
}

