/*
 * Decompiled with CFR 0.152.
 */
package net.ibm.malamut.newsmail.ui;

import java.awt.BorderLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import net.ibm.malamut.newsmail.ui.ProgressCancelListener;
import net.ibm.malamut.newsmail.ui.Shell;

public final class ProgressBarPanel
extends JPanel {
    private JLabel text;
    private JLabel percentage;
    private int pval = 0;
    private JProgressBar bar;
    private JButton cancel;
    private boolean cancelling = false;
    private Object cancelLock = new Object();
    private DefaultBoundedRangeModel model;
    private boolean buttonEnabled = false;

    public final void enableButton(boolean bl) {
        this.buttonEnabled = bl;
        this.cancel.setEnabled(bl);
    }

    public final int getValue() {
        return this.bar.getValue();
    }

    public final void increase() {
        this.setValue(this.bar.getValue() + 1);
    }

    public final void setArea(int n, int n2) {
        this.model.setRangeProperties(n, 0, n, n2, true);
        this.bar.setValue(n);
    }

    public final void setCancelText() {
        Object object = this.cancelLock;
        synchronized (object) {
            if (!this.cancelling) {
                this.cancelling = true;
                this.text.setText(this.text.getText() + " (Cancelling...)");
            }
        }
    }

    public final void setPartialEnabled(boolean bl) {
        Shell.enableTree(this, bl);
        if (!this.buttonEnabled && bl) {
            this.cancel.setEnabled(false);
        }
    }

    public final void setText(String string) {
        Object object = this.cancelLock;
        synchronized (object) {
            this.cancelling = false;
        }
        this.text.setText(string);
    }

    public final void setTitle(String string) {
        this.setBorder(BorderFactory.createTitledBorder(string));
    }

    public final void setValue(int n) {
        this.bar.setValue(n);
        this.pval = 100 * (n - this.model.getMinimum()) / (this.model.getMaximum() - this.model.getMinimum());
        this.percentage.setText(this.pval + "%");
    }

    public ProgressBarPanel(String string, String string2, ProgressCancelListener progressCancelListener, int n) {
        super(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder(string));
        JPanel jPanel = new JPanel(new BorderLayout(4, 4));
        this.text = new JLabel(string2);
        jPanel.add("North", this.text);
        this.percentage = new JLabel("100%");
        jPanel.add("East", this.percentage);
        this.bar = new JProgressBar();
        this.model = new DefaultBoundedRangeModel();
        this.bar.setModel(this.model);
        jPanel.add("Center", this.bar);
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        this.cancel = new JButton("Cancel");
        this.cancel.setEnabled(false);
        this.cancel.setActionCommand("Cancel" + n);
        this.cancel.addActionListener(progressCancelListener);
        box.add(this.cancel);
        box.add(Box.createHorizontalGlue());
        jPanel.add("South", box);
        this.add(jPanel);
        this.setPartialEnabled(true);
    }
}

