/*
 * Copyright (c) 1994 Frank Behrens
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */


/*  $Log: snprintf.c,v $
 * Revision 1.1  1994/09/09  00:00:00  frank
 * Initial revision
 *                                                       */

static const char rcsid[] = "$Id: snprintf.c,v 1.1 1994/09/09 00:00:00 frank Rel $";


#include <stdio.h>
#include <stdarg.h>

/* a quick and dirty replacement for snprintf function */

int snprintf(char *str, size_t n, char const *fmt, ...)

{
int ret;
va_list ap;
char buffer[2048]; /* this should be enough */

va_start (ap, fmt);

ret = vsprintf (buffer, fmt, ap);
strncpy (str, buffer, n);
str[n-1] = '\0';

va_end (ap);
return (ret);
}

