/*--------------------------------------------------------------------------

                                  TONLINE.fnc

   Version 29.8.1997
     - Die Teilnehmerkennung wird automatisch auf 12 Zeichen aufgefuellt;
     - Die Telekom hat in der Maske den String 'Teilnehmerkennung' auf
       'T-Online-Kennung' geaendert.
   Version 4.6.1997
     - Beruecksichtigung von Teilnehmer- und Mitbenutzer-Abfrage;
       die Teilnehmer- und Mitbenutzer-Nr wird dazu aus 'isdnuser.cfg'
       uebergeben
     - Korrektur bei fehlerhafter Password-Eingabe
   Version 1.5.1997
     - Umschaltung in den VT100 Modus wird von ISDNPM uebernommen
     - die Zugangskennung und das Passwort werden aus dem
     - 'isdnuser.cfg' uebergeben.
   Version 21.4.1997
     - geaendertes Login mit VT100-Fenster
     - geaenderte VT100-Login-Sequenz (wie cfos)
   Version 30.7.1996
     - mit Korrektur nach Senden der Gateway-Seite
       call WAITFOR "ER-Verb" und WAITFOR "SH"
       nun vor WAITFOR prompt_string beim Warten auf Gebuehren-Info
       (ein Tip von Jupp Chudzinski)

  --------------------------------------------------------------------------*/

call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
call SysLoadFuncs

ARG Channel LocalIp HostIp Netmask DefaultIp user pass teiln mitben .

say 'TONLINE - SLIP TONLINE login script (channel' channel')'

/*--------------------------------------------------------------------------*/
/*      Initialisierung                                                     */
/*--------------------------------------------------------------------------*/
cr   = '0d'x
crlf = '0d0a'x
remain_buffer  = ''
waitfor_buffer = ''
prompt_string = '[?25h'
GatewayPage = "*190144100#"

username    = X2C(SUBSTR(user,1,LENGTH(user)-2))
password    = X2C(SUBSTR(pass,1,LENGTH(pass)-2))
teilnehmer  = X2C(SUBSTR(teiln,1,LENGTH(teiln)-2))
mitbenutzer = X2C(SUBSTR(mitben,1,LENGTH(mitben)-2))

/*say 'Anschlusskennung :' username    */
/*say 'Teilnehmernummer :' teilnehmer  */
/*say 'Mitbenutzer      :' mitbenutzer */

if teilnehmer=""  then teilnehmer=cr
if mitbenutzer="" then mitbenutzer=cr

/*--------------------------------------------------------------------------*/
/*      Start Anmeldung im T-Online                                         */
/*--------------------------------------------------------------------------*/

call SHOWSTATUS channel,"Warte auf Abfrage Anschlusskennung"
call waitfor prompt_string,20
if RC = 1 then signal failure
call flush_receive
call SHOWSTATUS channel,"Sende Anschlusskennung"
call send username
call SHOWSTATUS channel,"Warte auf Abfrage Teilnehmer / Mitbenutzer"
call waitfor prompt_string,20
if RC = 1 then signal failure
call flush_receive
if Pos('Teilnehmernummer oder # eingeben',waitfor_buffer)>0 then do
  call SHOWSTATUS channel,"Sende Teilnehmernummer"
  call send left(teilnehmer,12)
  call waitfor prompt_string,20
  if RC = 1 then signal failure
  call flush_receive
end
if Pos('T-Online-Nummer oder # eingeben',waitfor_buffer)>0 then do
  call SHOWSTATUS channel,"Sende Teilnehmernummer"
  call send left(teilnehmer,12)
  call waitfor prompt_string,20
  if RC = 1 then signal failure
  call flush_receive
end
if Pos('Mitbenutzer oder # eingeben',waitfor_buffer)>0 then do
  call SHOWSTATUS channel,"Sende Mitbenutzernummer"
  call send mitbenutzer
  call waitfor prompt_string,20
  if RC = 1 then signal failure
  call flush_receive
end
call SHOWSTATUS channel,"Sende Kennwort"
call send left(password,8)
/*if length(password) < 8 then call send cr  */
call waitfor prompt_string,20
if RC = 1 then signal failure
call flush_receive
if Pos('Falsches Kennwort',waitfor_buffer)>0 then do
  call SHOWSTATUS channel,"Fehlerhafte Anmeldung: Falsches Kennwort!"
  say 'Fehlerhafte Anmeldung: Falsches Kennwort!'
  signal failure
end

/*--------------------------------------------------------------------------*/
/*      Wechsel zum Internet-Gateway                                        */
/*--------------------------------------------------------------------------*/
call SHOWSTATUS channel,'Gehe zu Internet-Gateway Seite' gatewayPage
call send gatewayPage
call SHOWSTATUS channel,'Warte auf Gebuehren-Info ER-Verb.'
call waitfor "ER-Verb.",20
if rc=1 then signal failure
call SHOWSTATUS channel,"Warte auf SH"
call waitfor "SH",20
if rc=1 then signal failure
call SHOWSTATUS channel,"Warte auf Eingabe-Sequenz"
call waitfor prompt_string,20
if rc=1 then signal failure

call SHOWSTATUS channel,"Sende Gebhren-Besttigung 19"
call send "19"

call SHOWSTATUS channel,"Warte auf STATUS OK"
call waitfor "STATUS OK",100
if rc=1 then signal failure
call SHOWSTATUS channel,"Warte auf CR-LF"
call waitfor crlf
call SHOWSTATUS channel,"Sende Systemkennung LIN"
call send "LIN"||cr

call SHOWSTATUS channel,"Warten auf Konfigurations-Informationen..."
do forever
  call waitfor crlf
  parse var waitfor_buffer a " " b "0d0a"x
  if a="." ||"0d0a"x then leave
  select
    when a="YOURIP" then yourip=b
    when a="DESTIP" then destip=b
    when a="NETMASK" then netmask=b
    when a="DNS" then dns=b
    when a="DOMAIN_NAME" then domain_name=b
    otherwise /* ignorieren */
  end
end

do forever
  call waitfor crlf
  parse var waitfor_buffer a " " b "0d0a"x
  if a="." ||"0d0a"x then leave
end
call SHOWSTATUS channel,"Sende OK zum Start des IP"
call send "OK"||cr
call SHOWSTATUS channel,"Im Internet erfolgreich angekommen"

resolv=Value('ETC',,'OS2ENVIRONMENT')'\resolv'
resolv_sik=resolv'.~'
say "alte Resolv-Datei" resolv "sichern in" resolv_sik
say "neue Resolv-Datei" resolv "erzeugen aus DNS und DOMAIN_NAME"

if stream(resolv,'c','query exists')<>'' then do
  if stream(resolv_sik,'c','query exists')<>'' then do
    'cmd /c del' resolv_sik
  end
  'cmd /c ren' resolv FileSpec("name",resolv_sik)
  if rc=0 then do
    call lineout resolv,'domain' domain_name
    call lineout resolv,'nameserver' dns
    call stream resolv,'c','close'
  end
  else do
    say 'Kann keine Sicherungskopie von %etc%\resolv-Datei erzeugen'
  end
end
else do
  call lineout resolv,'domain' domain_name
  call lineout resolv,'nameserver' dns
  call stream resolv,'c','close'
end

say "IP-Interface und Routing konfigurieren..."

rc = SETLOCALIP(channel,yourip)


/* Die Zeilen fuer die Interfacekonfiguartion mueseen */
/* entfallen, wenn Sie mit fester IP-Adresse und      */
/* IP-Masquerading arbeiten !                         */
/* setzen Sie dafuer 'config = 0 '                    */

config = 1

if config = 1 then do

  "route -fh"
  "ifconfig" "sl0" yourip destip "netmask" netmask "mtu 296"
  "route add" "default" destip "1"

end

"ifconfig sl0 mtu 296"

/* must not be changed ! */

say 'REXX DATAMODE'
rc = ISDNDATAMODE(Channel)
say 'REXX DATAMODE END'

call SHOWSTATUS channel,"Internet beendet"

if stream(resolv_sik,'c','query exists')<>'' then do
  say "alte RESOLV-Datei" resolv_sik "restaurieren"
  if stream(resolv,'c','query exists')<>'' then do
    'cmd /c del' resolv
  end
  'cmd /c ren' resolv_sik FileSpec("name",resolv)
  if rc<>0 then do
    say 'Kann Sicherungskopie von %etc%\resolv-Datei nicht restaurieren'
  end
end

if config = 1 then do
  say "Routing-Eintrge lschen..."
  "route delete" destip yourip
  "route delete" "default" destip
end

exit 0

failure:
say "Mist! Schiefgegangen!"
  call ISDNDISCONNECT Channel
  exit 1


/*--------------------------------------------------------------------------*/
/*                            send ( sendstring)                            */
/*..........................................................................*/
/*                                                                          */
/* Routine to send a character string off to the modem.                     */
/*                                                                          */
/*--------------------------------------------------------------------------*/

send:

   parse arg sendstring
   call ISDNWRITE channel , sendstring

   return


/*----------------------------------------------------------------------*/
/*  waitfor( waitforstring , [timeout] )                                */
/*......................................................................*/
/*                                                                      */
/*                                                                      */
/*                                                                      */
/*----------------------------------------------------------------------*/

waitfor:

    parse arg waitstring , timeout
    if timeout = '' then
        timeout = 20        /* wait 20 sec */

    timeout = timeout * 10 ;    /* ISDNREAD returns after 1/10 Sek */

    waitfor_buffer = '' ; done = -1 ; curpos = 1
    do while (( done = -1) & (timeout > 0))
        if (remain_buffer \= '') then do
            line = remain_buffer
            remain_buffer = ''
        end
        else do
            line = ISDNREAD(Channel)
            if Substr(line,1,1)<>'00'x then do
              say 'ISDNREAD-Fehler'
              signal failure
            end
            line=Substr(line,2)
        end
        waitfor_buffer = waitfor_buffer || line
        if waitstring>='80'x then
          index=1
        else
          index = pos(waitstring,waitfor_buffer)
        if (index > 0 ) then do
            remain_buffer = substr(waitfor_buffer,index+length(waitstring))
            waitfor_buffer = delstr(waitfor_buffer,index+length(waitstring))
            done = 0
        end
        curpos = length(waitfor_buffer)+1
        timeout = timeout - 1
        call SysSleep 0
    end
    if (timeout = 0 ) then do
        say 'WAITFOR : timed out '
        done = 1
    end
    RC = done
return RC
/*----------------------------------------------------------------------*/
/*  flush_receive()                                                     */
/*......................................................................*/
/*                                                                      */
/*                                                                      */
/*                                                                      */
/*----------------------------------------------------------------------*/
flush_receive:

    cx = 20
    line = ''
    do while (line \= '') & (cx > 0 )
        line = ISDNREAD(Channel)
        if Substr(line,1,1)<>'00'x then do
          say 'ISDNREAD-Fehler'
          signal failure
        end
        line=Substr(line,2)
        cx = cx - 1
    end
    return

