/*
 * LOGINC.FNC   Login fuer Compuserve Classic Zugang NEU
 *
 * 25.09.2000 K. Schmidthaus
 * 07.02.2001 Jakob Rascher
*/

/****************************************************************************/
/*  folgende Info wird der REXX-Prozedur von 'ISDNPM' uebergeben :          */
/*                                                                          */
/*      'HANDLE'    : Identifikation fuer die Verbindung. Sie muss bei      */
/*                    ALLEN Funktionsaufrufen im 'ISDNPM' mit angegeben     */
/*                    werden.                                               */
/*                                                                          */
/*      'CNAME'     : 'Name' der Verbindung, wie er im 'xx.OUT' angegeben   */
/*                    wurde.                                                */
/*                                                                          */
/*      'USERID'    : 'Userid' der Verbindung aus 'xx.OUT'.                 */
/*      'PASSWORD'  : 'Password' der Verbindung aus 'xx.OUT'.               */
/*                                                                          */
/*      'PROFILE'   : Name vom 'Profile' aus 'xx.OUT'.                      */
/*                                                                          */
/*                                                                          */
/*  folgende Funktionen stellt 'ISDNPM' der REXX-Prozedur zur Verfuegung :  */
/*                                                                          */
/*                                                                          */
/*      line = ISDNPMREAD(HANDLE)                                           */
/*                                                                          */
/*          liest Zeichen von der 'Schnittstelle' ein.                      */
/*                                                                          */
/*      rc   = ISDNPMWRITE(HANDLE,String)                                   */
/*                                                                          */
/*          giebt einen 'String' auf der Schnittstelle aus.                 */
/*                                                                          */
/*      rc   = ISDNPMLOG(HANDLE,Logfileeintrag)                             */
/*                                                                          */
/*          schreibt einen 'String' in das LogFile.                         */
/*                                                                          */
/*      rc   = ISDNPMTRACE(HANDLE,String)                                   */
/*                                                                          */
/*          schreibt einen 'String' in das Tracefile.                       */
/*                                                                          */
/*      rc   = ISDNPMMESSAGE(HANDLE,MessageString)                          */
/*                                                                          */
/*          generiert einen 'MessageString' fuer das Statusfenster.         */
/*                                                                          */
/*      rc   = ISDNPMDATAMODE(HANDLE)                                       */
/*                                                                          */
/*          verlaesst den 'DialogModus' und wartet bis der 'Datenueber-     */
/*          tragungsModus' beendet ist.                                     */
/*                                                                          */
/*                                                                          */
/*      rc   = ISDNPMDISCONNECT(HANDLE)                                     */
/*                                                                          */
/*          trennt die Verbindung.                                          */
/*                                                                          */
/*      rc   = ISDNPMSENDUSERID(HANDLE)                                     */
/*                                                                          */
/*          giebt die 'UserId' auf der Schnittstelle aus.                   */
/*                                                                          */
/*      rc   = ISDNPMSENDPASSWORD(HANDLE)                                   */
/*                                                                          */
/*          giebt das 'Password' auf der Schnittstelle aus.                 */
/*                                                                          */
/*                                                                          */
/****************************************************************************/

call RxFuncAdd 'SysSleep','RexxUtil','SysSleep'

PARSE ARG HANDLE  CNAME USERID PASSWORD PROFILE .

say     CNAME
say     USERID
say     PASSWORD
say     PROFILE

CR   = '0d'x
CRLF = '0d0a'x
remain_buffer  = ''
waitfor_buffer = ''

rc = ISDNPMMESSAGE(HANDLE,'DIALOG STARTED')
call syssleep 2
rc = ISDNPMWRITE(HANDLE,CR)

rc = ISDNPMMESSAGE(HANDLE,'WAIT FOR ''Login:''')
call waitfor  "Login:" , 10
rc = ISDNPMWRITE(HANDLE,'cisv1'||CR)

rc = ISDNPMMESSAGE(HANDLE,'WAIT FOR ''Password:''')
call waitfor  "Password:" , 10
rc = ISDNPMWRITE(HANDLE,'classic'||CR)

rc = ISDNPMMESSAGE(HANDLE,'WAIT FOR ''User ID:''')
call waitfor  "User ID:" , 10
rc = ISDNPMMESSAGE(HANDLE,'SENDING USERID')
rc = ISDNPMSENDUSERID(HANDLE)
rc = ISDNPMWRITE(HANDLE,'/noint/go:pppconnect'||CR)

rc = ISDNPMMESSAGE(HANDLE,'WAIT FOR ''Password:''')
call waitfor  "Password:" , 10
rc = ISDNPMSENDPASSWORD(HANDLE)
rc = ISDNPMWRITE(HANDLE,CR)

rc = ISDNPMMESSAGE(HANDLE,'WAIT FOR ''One moment please...''')
call waitfor  "One moment please..." , 10

rc = ISDNPMMESSAGE(HANDLE,'DIALOG READY')
call SysSleep 1
rc = ISDNPMMESSAGE(HANDLE,'STARTING PPP')

say 'REXX DATAMODE'
rc = ISDNPMDATAMODE(HANDLE)
say 'REXX DATAMODE END '

exit 0

/*----------------------------------------------------------------------*/
/*  waitfor( waitforstring , [timeout] )                                */
/*......................................................................*/
/*                                                                      */
/*      diese Routine liest von der Schnittstelle, bis ein              */
/*      'waitforstring' eingetroffen ist.                               */
/*----------------------------------------------------------------------*/

waitfor:

    parse arg waitstring , timeout
    if timeout = '' then
        timeout = 20        /* wait 20 sec */

    timeout = timeout * 10 ;    /* ISDNREAD returns after 1/10 Sek */

    waitfor_buffer = '' ; done = -1 ; curpos = 1
    do while (( done = -1) & (timeout > 0))
        if (remain_buffer \= '') then do
            line = remain_buffer
            remain_buffer = ''
        end
        else do
            line = ISDNPMREAD(HANDLE)
            line=Substr(line,1)
        end
        waitfor_buffer = waitfor_buffer || line
        index = pos(waitstring,waitfor_buffer)
        if (index > 0 ) then do
            remain_buffer = substr(waitfor_buffer,index+length(waitstring))
            waitfor_buffer = delstr(waitfor_buffer,index+length(waitstring))
            done = 0
        end
        call charout,substr(waitfor_buffer,curpos)
        curpos = length(waitfor_buffer)+1
        timeout = timeout - 1
       /* call SysSleep 1 */
    end
    if (timeout = 0 ) then do
        say 'WAITFOR : timed out '
        done = 1
    end
    RC = done
return RC

/*----------------------------------------------------------------------*/
/*  flush_receive()                                                     */
/*......................................................................*/
/*                                                                      */
/*                                                                      */
/*                                                                      */
/*----------------------------------------------------------------------*/
flush_receive:

    parse arg echo
    /* if echoing the flush - take care of waitfor remainig buffer */
    if( echo \= '' ) && (length(remain_buffer) > 0 ) then do
        call charout, remain_buffer
    end
    cx = 20
    line = ''
    do while (line \= '') & (cx > 0 )
        line = ISDNPMREAD(HANDLE)
        if Substr(line,1,1)<>'00'x then do
          say 'ISDNPMREAD-Fehler'
          signal failure
        end
        line=Substr(line,2)
        if echo \= '' then
            call charout,line
        cx = cx - 1
    end
    return
