/* MSETUP.CMD, Version 1.2 */
/* Internet Access via T-Online */
/* Copyright (c) 1995 1&1 Telekommunikation GmbH */

/*********************************************************************
/
/  This REXX command file is used to register the user's E-mail
/  address.  It establishes a Telnet session with the host that
/  is determined by the current connection.  This connection is
/  supposed to be one of the T-Online Internet gateways.
/
*********************************************************************/

address cmd "@ECHO OFF"

call RxFuncAdd "SysLoadFuncs", "RexxUtil", "SysLoadFuncs"
call SysLoadFuncs

null      = "0"x   /* String terminator */
newline   = "0A"x  /* Line feed */
paragraph = newline || newline

message =,
   "Zum Registrieren Ihrer E-mail Adresse mssen Sie "   ||,
   "bereits online sein. Falls dies noch nicht der Fall "||,
   "sein sollte, brechen Sie jetzt bitte ab und starten "||,
   "zuerst den T-Online Internet Dialer. "paragraph

call InfoMessage

tcpetc = value( "ETC", , "OS2ENVIRONMENT")

if tcpetc = "" then do
   message =,
      "Die Umgebungsvariable ETC, die den Pfad zur Datei "||,
      "TCPOS2.INI weist, existiert nicht. Diese Variable "||,
      "wird bei Installation der IBM Internet Connection "||,
      "definiert, indem eine entsprechende SET Anweisung "||,
      "in die Datei CONFIG.SYS eingefgt wird. "paragraph

   call FatalError
end

tcpos2 = tcpetc"\TCPOS2.INI"

if stream( tcpos2, "command", "query exists") = "" then do
   message =,
      "Die Datei "tcpos2" existiert nicht. Prfen Sie, "   ||,
      "ob die Umgebungsvariable ETC richtig gesetzt ist. " ||,
      "Der Wert dieser Variablen weist den Pfad zur Datei "||,
      "TCPOS2.INI. "paragraph

   call FatalError
end

gate = SysIni( tcpos2, "CONNECTION", "CURRENT_CONNECTION")

if \(gate = "DxJ2400"null | gate = "DxJfast"null) then do
   message =,
      "Sie sind entweder noch nicht online oder Sie haben "||,
      "einen anderen als einen T-Online Zugang benutzt. "  ||,
      "Ein solcher Zugang ist fr die Registrierung Ihrer "||,
      "E-mail Adresse erforderlich. "paragraph

   call FatalError
end

server = SysIni( tcpos2, gate, "MAIL_GW")

if server = "ERROR:" | server = "" | server = null then do
   message =,
      "Fr den verwendeten T-Online Zugang ist kein POP " ||,
      "Mail Server eingetragen. Tragen Sie diesen Server "||,
      "im T-Online Internet Dialer nach. Wenn Ihnen das " ||,
      "zu schwierig erscheint und Sie ganz sicher gehen " ||,
      "wollen, knnen Sie auch den Internet Zugang via "  ||,
      "T-Online neu installieren. "paragraph

   call FatalError
end

address cmd "TELNETPM -p 834" server

exit

/*********************************************************************
/
/  The routine 'InfoMessage' displays a message box and offers
/  the buttons 'OK' and 'Abbruch'.  While 'OK' continues REXX
/  command file execution, 'Abbruch' terminates it.
/
*********************************************************************/

InfoMessage:

   title   = "T-Online E-mail Adresse - Hinweis"
   buttons = "OkCancel"
   infosym = "Information"
   action  = RxMessageBox( message, title, buttons, infosym )
   if action = 2 /* Cancel */ then exit
   
return

/*********************************************************************
/
/  The routine 'FatalError' displays a message box and offers
/  the button 'OK' which aborts REXX command file execution.
/
*********************************************************************/

FatalError:

   title   = "T-Online E-mail Adresse - Fehler"
   buttons = "Ok"
   infosym = "Error"
   call RxMessageBox message, title, buttons, infosym
   exit  /* Abort */
   
return
