/***********************************************************
** Telekom Online Internet Access via Datex-J
** Dial In Script v. 1.1a
** Changes: Fast and normal in one Skript
**          LoginBox
************************************************************
** The routines send, waitfor und flush_receive are derived from
** OS/2 2.0 REXX Driver for IBM TCP/IP version 2.0, ANNEX.CMD
***********************************************************/

parse arg interface , dialcmd username password

call RxFuncAdd SysLoadFuncs, RexxUtil, SysLoadFuncs
call SysLoadFuncs

/***********************************************************
** Set up some variables with convenient values
***********************************************************/
cr='0d'x
crlf='0d0a'x
ctrlc='03'x

newline='0a'x

regpage=ctrlc'190144200#'

gatewaypage=ctrlc'190144100#'

identstring='OS2 4'

tcpos2=value('ETC',,'OS2ENVIRONMENT') || '\TCPOS2.INI'
price=value('ETC',,'OS2ENVIRONMENT') || '\..\TELEKOM\PRICE.MIN'

say 'tcpos2: ' || tcpos2

gate=sysini(tcpos2,CONNECTION,CURRENT_CONNECTION)
gate=left(gate,7)

say 'gate: ' || gate

/***********************************************************
** Read the Datex-J parameters stored in DXJDIAL.INI
***********************************************************/
call ReadDxJDial

/***********************************************************
** Dial into Datex-J and enter the Internet Gateway
***********************************************************/
if gate = 'DxJ2400' then do
   initstring = modem_init_0
   dialstring = dial_prefix || default_node
end

if gate = 'DxJfast' then do
   initstring = modem_init_1
   dialstring = dial_prefix || fast_node
end

kennung   = left(account,12)
teilnehmer = left(user_no, 12)
mitbenutzer = left(co_user_no, 4)
passwort = left(password, 8)

say ''
say 'Telekom Online Internet Access via Datex-J'
/* call flush_receive 'echo' */

dial_in_loop:
say 'Dialing ...'
call send initstring || cr     
call waitfor 'OK'
call flush_receive 'echo'
call send dialstring || cr
call waitfor 'CONNECT' , 40 
if RC = 1
   then
   do
      say 'Wahlwiederholung in 40 Sekunden'
      call flush_receive
      call send 'ath' || cr
      call waitfor 'OK' ; call flush_receive 'echo'
      SIGNAL dial_in_loop
   end

/* Datex-J login procedure: select vt100 line discicpline */
call flush_receive 'echo'
call send '.'
call send cr
call flush_receive 'echo'

/* Datex-J login procedure: enter identification data */
call waitfor 'kennung:' , 30 
if RC = 1 then
do
  SIGNAL Failure 
end
call flush_receive 'echo'

call send kennung 
call waitfor 'L120', 5
/* in case Anschlu is teilnehmerfreizgig, we must enter Teilnehmer */
if RC = 1 then
do
   call send teilnehmer
end

call waitfor 'Mitbenutzer' , 5
if RC = 1 then
do
  SIGNAL Failure 
end
call flush_receive 'echo'

call send mitbenutzer
call waitfor '1' , 5 
if RC = 1 then
do
  SIGNAL Failure 
end
call flush_receive 'echo'

call send passwort
call waitfor 'L200' , 10 
if RC = 1 then
do
/* Keine Telekom-Seite; Container-Seite? */
        if lastpos("34561",waitfor_buffer)=0 then
/* Nein */
                SIGNAL Failure
end
call flush_receive 'echo'

/* Check if registration is necessary */
if stream( regfile, 'command', 'query exists') = '' then
do
   call send regpage
   call waitfor 'Absenden'

   zeit = Time('S')
   do until Time('S') > zeit+1
   end

   call flush_receive 'echo'
   call send '19'
   call waitfor 'beendet' , 10
   if RC=1 then
        SIGNAL FailureER

   call flush_receive 'echo'
end
/* Datex-J login procedure: enter X.29 gateway */
call send gatewaypage
call waitfor 'ER-Verb.'

call waitfor 'SH'
parse var waitfor_buffer minuteprice 'J' .
minuteprice = LEFT(minuteprice,13)
say 'Kosten:'||minuteprice

minutepriceold = LINEIN(price,1,1)
LINEOUT(price)
minutepriceold = LEFT(minutepriceold,13)

if minutepriceold \= minuteprice then do

  title = 'Telekom Online Gebhreninformation'
  message = cr,
    'Fr das Internet betrgt der Zeittakt' || minuteprice || crlf,
    'Hinzu kommt der Datex-J Zeittakt von 0,02/DM Min.' || cr,
    'An Werktagen von 8-18 Uhr erhht sich der Datex-J' || cr,
    'Zeittakt um DM 0,04/DM Min. (nicht an bundesein-' || cr,
    'heitlichen Feiertagen!).',
    newline || newline,
    'Soll dieser Hinweis beim nchsten Login wieder angezeigt' || cr,
    'werden? Falls Sie die Frage mit NEIN beantworten, so' || cr,
    'bekommen Sie diese Information erst wieder bei einer' || cr,
    'Tarifnderung angezeigt.' || crlf

   buttons = 'YesNoCancel'
   infosym = 'Information'
   action  = RxMessageBox( message, title, buttons, infosym )

   if action = 2 /* Cancel */ then exit 1

   if action = 6 /* Yes */ then do
     LINEOUT(price,'0',1)
     LINEOUT(price)
   end

   if action = 7 /* Nein */ then do
     LINEOUT(price,minuteprice,1)
     LINEOUT(price)
   end
end

call send '19'
call waitfor 'STATUS ' , 10
if RC=1 then
        SIGNAL FailureER


call waitfor crlf
parse var waitfor_buffer a ' ' challenge '0d0a'x
if a \= 'OK' then do
  say 'Fehler: ' a
  exit 1
end

/* Send Identification String */
crypt 'Encode'  challenge '| RXQUEUE'
parse pull response

call send IdentString || ' ' || response || cr

call waitfor crlf
parse var waitfor_buffer a '0d0a'x
if a \= 'OK' then do
  say 'Fehler: ' a
  exit 1
end


do forever
  call waitfor crlf
  parse var waitfor_buffer a ' ' b '0d0a'x

  if a = '.' || '0d0a'x then leave
  call SysIni tcpos2, gate, a, b || '0'x
end

do forever
  call waitfor crlf
  parse var waitfor_buffer a ' ' b '0d0a'x

  if a = '.' || '0d0a'x then leave

  select
    when a = 'MSG'     then 
       do 
       title = 'Telekom Online Hinweis'
       message =,
       b
       call InfoMessage
       end
    when a = 'DOREG'   then 'del' regfile
    when a = 'DONTREG' then call lineout regfile
    otherwise  /* Ignore */
  end
end

call send 'OK' || cr

parse value SysIni(tcpos2,gate,'YOURIP') with yourip '0'x
parse value SysIni(tcpos2,gate,'DESTIP') with destip '0'x
parse value SysIni(tcpos2,gate,'NETMASK') with netmask '0'x

'ifconfig sl0' yourip destip 'netmask' netmask
'route add default' destip '1'

say 'Connected to Telekom Online Internet Access'
say 'Eigene Adresse =' yourip ', Gateway-Rechner =' destip

/* Success */
exit 0

/* Failure */
Failure:
title = 'Telekom Online Hinweis'
message =,
'Bei der Eingabe der Zugangsdaten ist ein Fehler aufgetreten',
'Bitte berprfen Sie Ihre Zugangsdaten im Telekom Online Dialer Setup'
call InfoMessage
exit 1

/* FailureER */
FailureER:
title='Telekom Online Hinweis'
message =,
'Der Verbindungsaufbau zum externen Rechner ist derzeit nicht',
'mglich. Bitte versuchen Sie es spter noch einmal.'
call InfoMessage
exit 1

/**********************************************************
**                          end of main program                           
***********************************************************/


/**********************************************************
** subroutines for modem access: send, waitfor, flush_receive
***********************************************************/
/*                            send ( sendstring)                         */
/* Routine to send a character string off to the modem.                  */

send:

   parse arg sendstring
   call slip_com_output interface , sendstring

   return


/*                    waitfor ( waitstring , [timeout] )                    */
/* Waits for the supplied string to show up in the COM input.  All input    */
/* from the time this function is called until the string shows up in the   */
/* input is accumulated in the "waitfor_buffer" variable.                   */
/*                                                                          */
/* If timeout is specified, it says how long to wait if data stops showing  */
/* up on the COM port (in seconds).             */

waitfor:

   parse arg waitstring , timeout

   if timeout = '' then
     timeout = 5000    /* L O N G   delay if not specified */
   waitfor_buffer = '' ; done = -1; curpos = 1
   ORI_TIME=TIME('E')

   if (remain_buffer = 'REMAIN_BUFFER') then do
      remain_buffer = ''
   end

   do while (done = -1)
      if (remain_buffer \= '') then do
         line = remain_buffer
         remain_buffer = ''
       end
       else do
         line = slip_com_input(interface,,10)
      end
      waitfor_buffer = waitfor_buffer || line
      index = pos(waitstring,waitfor_buffer)
      if (index > 0) then do
         remain_buffer = substr(waitfor_buffer,index+length(waitstring))
         waitfor_buffer = delstr(waitfor_buffer,index+length(waitstring))
         done = 0
      end
      call charout , substr(waitfor_buffer,curpos)
      curpos = length(waitfor_buffer)+1
      if ((done \= 0) & (TIME('E')>timeout)) then do
/*        call lineout , ' WAITFOR: timed out ' */
        done = 1
       end
   end
   timeout=0
   RC=done
 return RC


/*                             flush_receive ()                             */
/* Routine to flush any pending characters to be read from the COM port.    */
/* Reads everything it can until nothing new shows up for 100ms, at which   */
/* point it returns.                                                        */
/*                                                                          */
/* The optional echo argument, if 1, says to echo flushed information.      */

flush_receive:

   parse arg echo

   /* If echoing the flush - take care of waitfor remaining buffer */
   if (echo \= '') & (length(remain_buffer) > 0) then do
      call charout , remain_buffer
      remain_buffer = ''
   end

   /* Eat anything left in the modem or COM buffers */
   /* Stop when nothing new appears for 100ms.      */

   do until line = ''
     line = slip_com_input(interface,,100)
     if echo \= '' then
        call charout , line
   end

   return


/*********************************************************************
/
/  The procedure 'ReadDxJDial' reads the file DXJDIAL.INI and
/  transforms the settings made in that file into values of
/  globally accessible variables.
/
/  DXJDIAL.INI is assumed to reside in the Telekom directory
/  which is a subdirectory of the base directory where the IBM
/  Internet Connection is installed.
/
*********************************************************************/

ReadDxJDial:

   procedure expose,
      account password user_no co_user_no,
      comport_no modem_init_0 modem_init_1,
      dial_prefix default_node fast_node,
      crypt regfile

   /* Get drive, path and name of the INI file
   */
   parse upper source . . this_cmd
   c_drive = filespec( 'drive', this_cmd )
   c_path  = filespec( 'path',  this_cmd )
   dxjdial = c_drive || c_path || 'DXJDIAL.INI'
   crypt   = c_drive || c_path || 'CRYPT.EXE'
   regfile = c_drive || c_path || 'REGISTER.OK'

   /* Preserve compatibility with version 1.0 DXJDIAL.INI format
   */
   exchange_0 = ''
   exchange_1 = ''

   /* Read the contents of the INI file
   */
   do while lines( dxjdial ) > 0
      parse value linein( dxjdial ) with keyword '=' value
      value = strip( value )  /* Strip leading/trailing blanks */
      select
         when keyword = 'Account'     then account      = value
         when keyword = 'UserNo'      then user_no      = value
         when keyword = 'CoUserNo'    then co_user_no   = value
         when keyword = 'Password'    then password     = value
         when keyword = 'ComPortNo'   then comport_no   = value
         when keyword = 'ModemInit_0' then modem_init_0 = value
         when keyword = 'ModemInit_1' then modem_init_1 = value
         when keyword = 'DialPrefix'  then dial_prefix  = value
         when keyword = 'DefaultNode' then default_node = value
         when keyword = 'FastNode'    then fast_node    = value
         when keyword = 'Exchange_0'  then exchange_0   = value
         when keyword = 'Exchange_1'  then exchange_1   = value
         otherwise  /* Ignore */
      end
   end
   call lineout dxjdial  /* Close the INI file */

   /* Decode the encoded password
   */
   if password <> '' then do
      crypt 'Decode' password '| RXQUEUE'
      parse pull password
      password = x2c( password )
   end

   /* Prefix telephone numbers with exchange codes
   */
   default_node = exchange_0 || default_node
   fast_node    = exchange_1 || fast_node

return


/*********************************************************************
/
/  The procedure 'InfoMessage' displays a message box and offers
/  the buttons 'Ok' and 'Abbruch'. While 'Ok' continues REXX
/  command file execution, 'Abbruch' terminates it.
/
*********************************************************************/

InfoMessage:

   buttons = 'OkCancel'
   infosym = 'Information'
   action  = RxMessageBox( message, title, buttons, infosym )
   if action = 2 /* Cancel */ then exit 1
   
return


/* Ende des Programms */
