#!/usr/bin/perl
#
# filename: mrtg.archive.pl
# Archive mrtg gifs and summary files
# Original author: Emanuele Leonardi <Emanuele.Leonardi@roma1.infn.it>
# Updates by: Rawlin Blake <blake@nevada.edu>

# Get date and time of execution
chop ($date = `date +%y%m%d`);
chop ($time = `date +%H:%M:%S`);

# User configuration section

# Define list of nodes to archive
#@nodes_to_archive = ('router1','router2','router3','etc');
@nodes_to_archive = ('192.168.1.1','192.168.99.16','192.168.17.1');

# Define list of interfaces for summary files
#@nodes_to_summary = ('router1.iface#','etc');
@nodes_to_summary = ('192.168.1.1.2','192.168.1.17.1');

# Define list of common gifs to link
@common_gifs = ('mrtg-l.gif','mrtg-m.gif','mrtg-r.gif','mrtg-ti.gif');

# Define working directories
$MRTG_DIR = "/home/httpd/html/mrtg";
$ARCHIVE_DIR = "$MRTG_DIR/archive";
$TO_DIR = "$ARCHIVE_DIR/$date";

# End user configuration section

print "=====
Archive $date at $time\n";

# Create daily directory and copy default GIF files
if (-e $ARCHIVE_DIR) {
   }
else {
   mkdir($ARCHIVE_DIR,755) || die "Error creating $ARCHIVE_DIR\n";
   chmod(0755,$ARCHIVE_DIR);
   print "Create $ARCHIVE_DIR\n";
}
mkdir($TO_DIR,755) || die "Error creating $TO_DIR\n";
chmod(0755,$TO_DIR);
print "Create $TO_DIR\n";
foreach $mgif ( @common_gifs ) {
    symlink("$MRTG_DIR" . "\/" . "$mgif", "$TO_DIR" . "\/" . "$mgif");
}

# For each node copy the daily gifs
foreach $node ( @nodes_to_archive ) {
    system(sprintf("cp -a %s/%s.*-day.gif %s",$MRTG_DIR,$node,$TO_DIR));
}
# For each node copy the weekly gifs on Sunday
chop ($week = `date +%w`);
if ($week == "0") {
    foreach $node ( @nodes_to_archive ) {
        system(sprintf("cp -a %s/%s.*-week.gif %s",$MRTG_DIR,$node,$TO_DIR));
    }
}
# For each node copy the monthly gifs on the first
chop ($month = `date +%d`);
if ($month == "01") {
    foreach $node ( @nodes_to_archive ) {
        system(sprintf("cp -a %s/%s.*-month.gif %s",$MRTG_DIR,$node,$TO_DIR));
    }
}
# For each node copy the yearly gifs on January first
chop ($year = `date +%m%d`);
if ($year == "0101") {
    foreach $node ( @nodes_to_archive ) {
        system(sprintf("cp -a %s/%s.*-year.gif %s",$MRTG_DIR,$node,$TO_DIR));
    }
}

# For each node copy the daily summary file and create the index file
foreach $summary ( @nodes_to_summary ) {
    printf("%s\n",$summary);
    $Summary_Source = "$MRTG_DIR/$summary.html";
    $Summary_Destination = "$TO_DIR/$summary.html";
    open(SRC,"<$Summary_Source");
    open(DST,">$Summary_Destination");
    while (<SRC>) {
	s/<A HREF[^>]*>//g;
	s/<\/A>//g;
	s/Router Overview/Router Overview of $date/;
	s/<META HTTP-EQUIV=\"Refresh\" CONTENT=300 >//;
	print DST; }
    close(SRC);
    close(DST);
    chmod(0644,$Summary_Destination);
}

# Create the general index file
$INDEX = "$TO_DIR/index.html";
print "Create $INDEX\n";
open(IDX,">$INDEX") || die "Could not open $INDEX\n";
printf IDX "
<HTML>
<HEAD><TITLE>Router Summary for %s</TITLE></HEAD>
<BODY BGCOLOR=\"#FFFFFF\">
<CENTER><H1>Router Summary for %s</H1></CENTER>
<P><UL type=square>
",$date,$date;
foreach $summary ( @nodes_to_summary ) {
    printf IDX "<LI><A HREF=\"%s.html\">%s</A></LI>\n",$summary,$summary;
}

print IDX "</UL></P></BODY></HTML>";
close(IDX);
chmod(0644,$INDEX);

chop ($time = `date +%H:%M:%S`);
print "Archive $date finished at $time\n";
# eof mrtg.archive.pl
